/*--------------------------------------------------------------------------------------------+
| Name : uart.c                                                                               |
| Purpose:                                                                                    |
| Initalize the com port interface in 9600 baud with crystal 11.0592MHz                       |
| Initalize the external interrupt 0 (P3.2).                                                  |
+--------------------------------------------------------------------------------------------*/
#include <reg51.h>
#include <stdio.h>

// com port with 9600 baud with crystal 11.0592MHz.
void init_uart(void)
{
	SCON  = 0x50;		        
    TMOD |= 0x20;               
    TH1   = 253;                
    TR1   = 1;                 
    TI    = 1; 
}

// initalize external interrupt 0 (P3.2) 
void init_int0(void)	
{
	PX0=1;	//Define Int0 high priority
	IE0=0;	//External Interrupt 0 edge flag, set when external interrupt detected, 
			//cleared when interrupt is processed.
	IT0=1;	//set to specific falling edge produce interrupt
	EX0=1;	//enable External Interrupt 0
	EA=1;	//enable all interrupt
}


