/*----------------------------------------------------------------------------------+
|                                                                                   |
|                          Print Hex8 or Hex16                                      |
|                                                                                   |
| Name: printHex.c                                                                  |                                                            |
| Purpose:                                                                          |
|   print the hex8 or hex16 data the streaming output.                              |
+----------------------------------------------------------------------------------*/

/*____________ I N C L U D E S ____________________________________________________*/

#include <reg51.h>
#include <stdio.h>

/*____________ P R O T O C O L ____________________________________________________*/
void printHex8(unsigned char hexdata);
void printHex16(int hex16);
unsigned char hex2ascii(unsigned char bits_data);

/*____________ F U N C T I O N ____________________________________________________*/

/*
	print 8 bit hex data
*/
void printHex8(unsigned char hex8)
{
	char hex8H,hex8L;
	hex8L = hex2ascii(hex8&0x0f);						// convert low byte
	hex8H = hex2ascii((hex8&0xf0)/0x0f);        		// convert high byte
	putchar(hex8H);										// print out
	putchar(hex8L);
}

/*
	print 16 bit hex data
*/
void printHex16(int hex16)
{
	char hex16H,hex16L;
	hex16H=((hex16&0xff00)/0x00ff);						// high byte 
	hex16L=((hex16&0x00ff));							// low byte 
	printHex8(hex16H);
	printHex8(hex16L);
}

/*
	convert the hex data(4 bits) to ascii code(8 bits)
*/
unsigned char hex2ascii(unsigned char bits_data)
{
	if(bits_data >=0x0f)								// all invalid data return 'F'
	{
		return 0x46;
	}
	if (bits_data >=0x00 & bits_data <=0x09)			// return '0'-'9'
	{
		bits_data +=0x30;
		return bits_data;
	}
	if (bits_data >=0x0a & bits_data <=0x0f);			// return 'A'-'F'
	{
		bits_data +=0x37;
		return bits_data;
	}
}