/*----------------------------------------------------------------------------------+
|                                                                                   |
|                    rprintf(const char *frmstr,[argments...]                       |
|                                                                                   |
| Name: rprintf.c                                                                   |                                                            |
| Purpose:                                                                          |
|    Provide the base function like standard c function printf, rprintf can print   |
|    string, integer, floating point, hex8 and hex16.                               | 
| Example:                                                                          |
|    rprintf("%i",-55);                                                             |
|    rprintf("%s","Hello");                                                         |
|    %s->string, %i->integer, %f->float, %u->hex8, %x->hex16                        | 
|                                                                                   |
| By Dillian Wong, last modify data 21/9/03                                         |
+----------------------------------------------------------------------------------*/

/*____________ I N C L U D E S ____________________________________________________*/

#include <reg51.h>
#include <stdio.h>
/*____________ P R O T O C O L ____________________________________________________*/

void rprintf(char type[],char content[]);
void printHex8(unsigned char hexdata);
void printHex16(int hex16);
void printInt(int num);
void printFloat(float flt);
void printString(char str[]);
unsigned char hex2ascii(unsigned char bits_data);


/*____________ F U N C T I O N ____________________________________________________*/


void rprintf(char type[],char content[])
{
	switch(type[1])
	{
		case 's':
					printString(content);
					break;
		case 'i':
					printInt(content);
					break;
		case 'f':
	//				printFloat(content);
					break;
		case 'u':
					printHex8(content);
					break;
		case 'x':
					printHex16(content);
					break;																		

	}	
}


/*
	print 8 bit hex data
*/
void printHex8(unsigned char hex8)
{
	char hex8H,hex8L;
	hex8L = hex2ascii(hex8&0x0f);						// convert low byte
	hex8H = hex2ascii((hex8&0xf0)/0x0f);        		// convert high byte
	putchar(hex8H);										// print out
	putchar(hex8L);
}

/*
	print 16 bit hex data
*/
void printHex16(int hex16)
{
	char hex16H,hex16L;
	hex16H=((hex16&0xff00)/0x00ff);						// high byte 
	hex16L=((hex16&0x00ff));							// low byte 
	printHex8(hex16H);
	printHex8(hex16L);
}

/*
	print interger
*/
void printInt(int num)
{
	unsigned char a,b,c,d;
	if(num<0)											// if num is negative
	{													// take 2 complement
		putchar('-');										
		num=~num+1;
	}
	if(num==0)											// if num is zero, print
	{													// zero
		putchar('0');
	}
	a=num/0x03E8;										// digit 1(MSB)
	b=(num-a*0x03E8)/0x64;								// digit 2
	c=(num-a*0x03E8-b*0x64)/0x0A;						// digit 3
	d=num-a*0x03E8-b*0x64-c*0x0A;						// digit 4(LSB)
	
	if(a!=0x00)											// no. print out
		putchar(hex2ascii(a));
	if((a+b)!=0x00)
		putchar(hex2ascii(b));
	if((a+b+c)!=0x00)
		putchar(hex2ascii(c));
	if((a+b+c+d)!=0x00)
		putchar(hex2ascii(d));
}


/*
	print float point with 4 suffix
*/
void printFloat(float flt)
{
	int num,suf;
	unsigned char a,b,c,d;

	/* interger part */
	num=flt;											
	printInt(num);
	putchar('.');

	/* float point part */
	suf=flt*10000-num*10000;								
	if(suf<0)
	{
		suf=~suf+1;
	}

	a=suf/0x03E8;										// digit 1(MSB)
	b=(suf-a*0x03E8)/0x64;								// digit 2
	c=(suf-a*0x03E8-b*0x64)/0x0A;						// digit 3
	d=suf-a*0x03E8-b*0x64-c*0x0A;						// digit 4(LSB)
	
	putchar(hex2ascii(a));								// float point print out
	if((b+c+d)!=0x00)
		putchar(hex2ascii(b));
	if((c+d)!=0x00)
		putchar(hex2ascii(c));
	if(d!=0x00)
		putchar(hex2ascii(d));
}

/*
	print string
*/
void printString(char str[])
{
	// send a string stored in RAM
	// check to make sure we have a good pointer
	if (!str) return;

	// print the string until a null-terminator
	while (*str)
		putchar(*str++);
}

/*
	convert the hex data(4 bits) to ascii code(8 bits)
*/
unsigned char hex2ascii(unsigned char bits_data)
{
	if(bits_data >=0x0f)								// all invalid data return 'F'
	{
		return 0x46;
	}
	if (bits_data >=0x00 & bits_data <=0x09)			// return '0'-'9'
	{
		bits_data +=0x30;
		return bits_data;
	}
	if (bits_data >=0x0a & bits_data <=0x0f);			// return 'A'-'F'
	{
		bits_data +=0x37;
		return bits_data;
	}
}