#ifndef _MAIN_H_
#define _MAIN_H_

//RANDOM macro
#define RANDOM(begin, end) ((rand() % ((end) - (begin) + 1)) + (begin))

//Functions
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR cmd, int showCmd);

void appInit();
void appShutdown();

void dlgConnect();
void dlgLogin();
void dlgFiles();
void dlgAdmin();
void dlgAdminFiles();
void dlgUsers();

void dlgUpload(HWND parent, std::ifstream& file,
			   unsigned long fileSize);
bool dlgDownload(HWND parent, const char* path, std::string fName);
void dlgSetShare(HWND parent);

bool getRemoteDirList(HWND lbControl, unsigned char folder);
void checkingGetRmDirList(HWND hWnd, HWND lbControl, unsigned char folder);
void uploadFile(HWND hWnd);
void downloadFile(HWND hWnd);
void deleteFile(HWND hWnd);
void renameFile(HWND hWnd);

bool serverShutdown();
void setButtonStates(HWND hWnd, BOOL state);
void sendShareState(const char* fName, unsigned char share);

void getDirList(HWND hWnd, int listboxID, int pathID, bool directory, bool prevs = true);
void getDirList(HWND hWnd, int listboxID, const char* path, bool directory, bool prevs = true);

void getUserList(HWND hWnd, int listboxID);
bool getUserInfo(HWND hWnd);
void dropUser(HWND hWnd, int listboxID);

void convertToUpper(char* str);

//void backToConnect(HWND hWndToClose);
//void endApp(HWND hWnd);

BOOL CALLBACK ConnectProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK LoginProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK FilesProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK NewUserProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK TransferProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK RenameProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lPAram);
BOOL CALLBACK ShareProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AdminProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AdminFilesProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK UserInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

#endif