#include "Client.h"
#include "main.h"
#include "../commandCodes.h"
#include <fstream>
#include <vector>

Client::Client(const Socket& s)
:sock(s), dataChannel(NULL), listener(NULL),
packetData(NULL), msg(NULL), filePath(NULL),
progBranch(CPB_HEADER), headerBytesReceived(0),
rate(0), rateCounter(0), lastRateCheck(0),
timeAtConnect(GetTickCount()),
listening(false), stage(ICV_CS_LOGIN),
admin(false), guest(false)
{
	sockaddr_in sAddr;
	int size = sizeof(sAddr);
	getpeername(sock.getAttachedSocket(), (sockaddr*)&sAddr, &size);
	strcpy(username, inet_ntoa(sAddr.sin_addr));
}

Client::~Client()
{
	if(dataChannel)
	{
		dataChannel->release();
		delete dataChannel;
	}
	if(listener)
	{
		listener->release();
		delete listener;
		listener = NULL;
	}
	if(msg)
		delete[] msg;
	if(filePath)
		delete[] filePath;
	if(packetData)
		delete[] packetData;
	sock.release();
}

bool Client::doOperations()
{
	if(listening)
	{
		if(listener->hasData())
		{
			listening = false;

			dataChannel = new Socket;
			*dataChannel = listener->accept();
			listener->release();
			delete listener;
			listener = NULL;
		}
	}
	else if(progBranch == CPB_FILE_SEND)
	{
		return sendFileBytes();
	}
	else if(progBranch == CPB_FILE_RCV)
	{
		return rcvFileBytes();
	}
	else if(progBranch == CPB_MSG_PROCESS)
	{
		progBranch = CPB_HEADER;
		unsigned char cmd = (unsigned char)msg[0];

		switch(cmd)
		{
		case ICV_OP_DISCONNECT:
			return false;
			
		case ICV_OP_LOGIN:
			if(stage == ICV_CS_LOGIN)
				login();
			else
				sock.send(ICV_SR_ERR);
			break;
			
		case ICV_OP_NEWUSER:
			newUser();			
			break;
			
		case ICV_OP_LOGOUT:
			stage = ICV_CS_LOGIN;
			sockaddr_in sAddr;
			int size;
			size = sizeof(sAddr);
			getpeername(sock.getAttachedSocket(), (sockaddr*)&sAddr, &size);
			strcpy(username, inet_ntoa(sAddr.sin_addr));

			admin = false;
			guest = false;
			break;

		case ICV_OP_TOSERVER:
			if(stage == ICV_CS_FILES && !guest)
			{
				progBranch = CPB_FILE_RCV;
				initReceive();
			}
			else
				sock.send(ICV_SR_ERR);
			break;

		case ICV_OP_TOCLIENT:
			if(stage == ICV_CS_FILES)
			{
				progBranch = CPB_FILE_SEND;
				initSend();
			}
			else
				sock.send(ICV_SR_ERR);
			break;

		case ICV_OP_GETDIRLIST:
			sendDirList();
			break;
		case ICV_OP_DELETE:
			deleteFile();
			break;
		case ICV_OP_RENAME:
			renameFile();
			break;
		case ICV_OP_GETSHARE:
			sendShare();
			break;
		case ICV_OP_SETSHARE:
			setShare();
			break;

		//Admin commands
		case ICV_OP_SHUTDOWN:
			if(admin)
			{
				extern bool quit;
				quit = true;
			}
			else
				sock.send(ICV_SR_NOACCESS);
			break;
		case ICV_OP_GETUSERLIST:
			if(admin)
				sendUserList();
			else
				sock.send(ICV_SR_NOACCESS);
			break;
		case ICV_OP_GETUSERINFO:
			if(admin)
				sendUserInfo();
			else
				sock.send(ICV_SR_NOACCESS);
			break;
		case ICV_OP_DROPUSER:
			if(admin)
			{
				int index = 1;
				unsigned char nameLen = (unsigned char)msg[index];
				++index;

				char* name = new char[nameLen + 1];
				memcpy(name, &msg[index], nameLen);
				name[nameLen] = '\0';
				if(strcmp(name, username) == 0)
				{
					sock.send(ICV_SR_ERR2);
				}
				else if(!dropClient(name))
				{
					sock.send(ICV_SR_ERR);
				}
				else
					sock.send(ICV_SR_OK);

				delete[] name;
			}
			else
				sock.send(ICV_SR_NOACCESS);
			break;
		}
		
		delete[] msg;
		msg = NULL;
	}
	else if(sock.hasData())
	{
		if(progBranch == CPB_MSG_RCV) //Receiving message body
		{
			int bytes = sock.receive(&msg[msgBytesReceived],
				totalMsgBytes - msgBytesReceived);

			if(bytes == 0)
				return false;
			else if((bytes == SOCKET_ERROR) && (WSAGetLastError() != WSAEMSGSIZE))
				return false;

			msgBytesReceived += bytes;
			if(msgBytesReceived == totalMsgBytes)
				progBranch = CPB_MSG_PROCESS;
		}
		else //Receiving message header (progBranch == CPB_HEADER)
		{
			int bytes = sock.receive(&header[headerBytesReceived],
				4 - headerBytesReceived);
			headerBytesReceived += bytes;

			if(bytes == 0)
				return false;
			else if((bytes == SOCKET_ERROR) && (WSAGetLastError() != WSAEMSGSIZE))
				return false;

			if(headerBytesReceived == 4)
			{
				progBranch = CPB_MSG_RCV;
				headerBytesReceived = 0;
				totalMsgBytes = ntohl(*(unsigned long*)header);
				msg = new char[totalMsgBytes];
				msgBytesReceived = 0;
			}
		}
	}
	return true;
}

void Client::login()
{
	unsigned long byteIndex = 1;
	unsigned char nameLen;
	unsigned char passLen;
	char* name;
	char* pass;

	nameLen = (unsigned char)msg[byteIndex];
	++byteIndex;
	
	name = new char[nameLen + 1];
	memcpy(name, &msg[byteIndex], nameLen);
	name[nameLen] = '\0';
	byteIndex += nameLen;
	
	passLen = (unsigned char)msg[byteIndex];
	++byteIndex;
	
	pass = new char[passLen + 1];
	memcpy(pass, &msg[byteIndex], passLen);
	pass[passLen] = '\0';
	
	convertToUpper(name);
	
	char namebuf[256];
	char passbuf[256];
	if(strcmp(name, "ADMIN") == 0)
	{
		std::ifstream file("adminpass.cfg");
		file.getline(passbuf, 256);
		if(strcmp(passbuf, pass) == 0)
		{
			stage = ICV_CS_FILES;
			admin = true;
			sock.send(ICV_SR_OK);
		}
		else
		{
			sock.send(ICV_SR_BADPASS);
			delete[] name;
			delete[] pass;
			return;
		}
	}
	else if(strcmp(name, "GUEST") == 0)
	{
		stage = ICV_CS_FILES;
		guest = true;
		strcpy(folderPath, "Users\\");
		sock.send(ICV_SR_OK);
		delete[] name;
		delete[] pass;
		return;
	}

	std::ifstream file("users.dat");
	while(file && !admin) //If already logged in as admin, skip this
	{
		file.getline(namebuf, 256);
		file.getline(passbuf, 256);
		if(file.eof())
			break;

		convertToUpper(namebuf);

		if(strcmp(namebuf, name) == 0)
		{
			if(strcmp(passbuf, pass) == 0)
			{
				stage = ICV_CS_FILES;
				sock.send(ICV_SR_OK);
			}
			else
				sock.send(ICV_SR_BADPASS);
			break;
		}
	}
	file.close();
	if(stage == ICV_CS_LOGIN)  //If login unsuccessful
		sock.send(ICV_SR_BADNAME);
	else
	{
		strcpy(folderPath, "Users\\");
		strcpy(username, name);
	}

	delete[] name;
	delete[] pass;
}

void Client::newUser()
{
	unsigned long byteIndex = 1;
	unsigned char nameLen;
	unsigned char passLen;
	char* name;
	char* pass;

	nameLen = (unsigned char)msg[byteIndex];
	++byteIndex;
	
	name = new char[nameLen + 2];
	memcpy(name, &msg[byteIndex], nameLen);
	name[nameLen] = '\0';
	byteIndex += nameLen;
	
	passLen = (unsigned char)msg[byteIndex];
	++byteIndex;
	
	pass = new char[passLen + 2];
	memcpy(pass, &msg[byteIndex], passLen);
	pass[passLen] = '\0';

	convertToUpper(name);

	bool found = false;
	if(strcmp(name, "SERVERSHARE") == 0 ||
		strcmp(name, "ADMIN") == 0 ||
		strcmp(name, "GUEST") == 0)
	{
		sock.send(ICV_SR_BADNAME);
		found = true;
	}
	
	char namebuf[256];
	char passbuf[256];
	std::ifstream file("users.dat");
	while(!found && file)
	{
		file.getline(namebuf, 256);
		file.getline(passbuf, 256);

		if(file.eof())
			break;
		if(strcmp(namebuf, name) == 0)
		{
			sock.send(ICV_SR_BADNAME);
			found = true;
		}
	}
	file.close();
	if(!found)
	{
		char path[MAX_PATH];
		strcpy(path, "Users\\");
		strcat(path, name);

		WIN32_FIND_DATA wfd;
		HANDLE h = FindFirstFile("Users", &wfd);
		if(h == INVALID_HANDLE_VALUE)
			CreateDirectory("Users", NULL);
		else
		{
			bool notFound = false;
			while(!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				if(!FindNextFile(h, &wfd))
				{
					notFound = true;
					break;
				}
			}
			if(notFound)
				CreateDirectory("Users", NULL);

			FindClose(h);
		}

		CreateDirectory(path, NULL);

		name[nameLen] = '\n';
		name[nameLen + 1] = '\0';
		pass[passLen] = '\n';
		pass[passLen + 1] = '\0';

		std::ofstream fout("users.dat", std::ios::out | std::ios::app);
		fout.write(name, nameLen + 1);
		fout.write(pass, passLen + 1);
		fout.close();

		sock.send(ICV_SR_OK);
	}
	
	delete[] name;
	delete[] pass;
}

void Client::deleteFile()
{
	int index = 1;
	unsigned char fNameLen = (unsigned char)msg[index];
	++index;

	filePath = new char[strlen(folderPath) + strlen(username) + 
		fNameLen + 2]; //path + username + '\\' + filename + '\0'
	strcpy(filePath, folderPath);
	strcat(filePath, username);
	strcat(filePath, "\\");
	int pathLen = strlen(filePath);
	memcpy(&filePath[pathLen], &msg[index], fNameLen);
	filePath[pathLen + fNameLen] = '\0';

	int res = DeleteFile(filePath);
	delete[] filePath;
	filePath = NULL;

	if(res == 0)
		sock.send(ICV_SR_ERR);
	else
		sock.send(ICV_SR_OK);
}

void Client::renameFile()
{
	int index = 1;

	unsigned char fNameLenOld = (unsigned char)msg[index];
	++index;

	char* fNameOld = new char[fNameLenOld + 1];
	memcpy(fNameOld, &msg[index], fNameLenOld);
	fNameOld[fNameLenOld] = '\0';
	index += fNameLenOld;

	unsigned char fNameLenNew = (unsigned char)msg[index];
	++index;

	char* fNameNew = new char[fNameLenNew + 1];
	memcpy(fNameNew, &msg[index], fNameLenNew);
	fNameNew[fNameLenNew] = '\0';
	index += fNameLenNew;

	//unsigned char maxNameLen = (fNameOld > fNameNew) ? fNameOld : fNameNew;

	filePath = new char[strlen(folderPath) + strlen(username) + 
		fNameLenOld + 2]; //path + username + '\\' + filename + '\0'
	strcpy(filePath, folderPath);
	strcat(filePath, username);
	strcat(filePath, "\\");
	strcat(filePath, fNameOld);

	char* filePathNew = new char[strlen(folderPath) + strlen(username) +
		fNameLenNew + 2];
	strcpy(filePathNew, folderPath);
	strcat(filePathNew, username);
	strcat(filePathNew, "\\");
	strcat(filePathNew, fNameNew);

	int res = rename(filePath, filePathNew);

	delete[] filePath;
	filePath = NULL;
	delete[] filePathNew;
	delete[] fNameOld;
	delete[] fNameNew;

	if(res == 0)
		sock.send(ICV_SR_OK);
	else
		sock.send(ICV_SR_ERR);
}

void Client::sendDirList()
{
	if(msg[1] == ICV_F_PERSONAL)
	{
		char path[MAX_PATH];
		strcpy(path, folderPath);
		strcat(path, username);		
		strcat(path, "\\*.*");
		
		WIN32_FIND_DATA wfd;
		HANDLE h = FindFirstFile(path, &wfd);
		if(h == INVALID_HANDLE_VALUE)
		{
			sock.send(ICV_S_END);
			return;
		}
		
		do
		{
			if(strcmp(wfd.cFileName, ".") == 0 ||
				strcmp(wfd.cFileName, "..") == 0)
				continue;
			
			sock.send(ICV_S_CONTINUE);
			sock.send((unsigned char)strlen(wfd.cFileName));
			sock.send(wfd.cFileName, strlen(wfd.cFileName));
		}while(FindNextFile(h, &wfd));
		
		sock.send(ICV_S_END);
		
		FindClose(h);
	}
	else //msg[1] == ICV_F_SHARED
	{
		std::ifstream shList("shared.dat");
		bool ok = true;
		if(!shList)
			ok = false;

		char buf[256];
		while(ok)
		{
			shList.getline(buf, 256);
			if(shList.eof())
				break;
			sock.send(ICV_S_CONTINUE);
			sock.send((unsigned char)(shList.gcount() - 1));
			sock.send(buf);
		}
		sock.send(ICV_S_END);
	}
}

void Client::sendUserList()
{
	extern std::vector<Client*> clients;
	for(int i = 0; i < clients.size(); ++i)
	{
		sock.send(ICV_S_CONTINUE);
		sock.send((unsigned char)strlen(clients[i]->getUsername()));
		sock.send(clients[i]->getUsername());
	}
	sock.send(ICV_S_END);
}

void Client::sendUserInfo()
{
	int index = 1;
	unsigned char nameLen = (unsigned char)msg[index];
	++index;

	char* user = new char[nameLen + 1];
	memcpy(user, &msg[index], nameLen);
	user[nameLen] = '\0';

	extern std::vector<Client*> clients;
	CLIENTSTATUS cs;
	bool found = false;
	for(int i = 0; i < clients.size(); ++i)
	{
		if(strcmp(clients[i]->getUsername(), user) == 0)
		{
			cs = clients[i]->getStatus();
			found = true;
			break;
		}
	}
	delete[] user;

	if(!found)
		sock.send(ICV_SR_BADNAME);
	else
	{
		sock.send(ICV_SR_OK);

		sock.send((unsigned char)cs.IP.size());
		sock.send(cs.IP.c_str());
		sock.send(htonl(cs.filesShared));
		sock.send(htonl(cs.connectedTime));
		sock.send(cs.transferType);
		if(cs.transferType != CSTT_NONE)
		{
			sock.send(htonl(cs.transferRate));
			sock.send(htonl(cs.fileSize));
			sock.send(htonl(cs.bytesTransferred));
		}
	}
}

void Client::sendShare()
{
	int index = 1;
	unsigned char len = (unsigned char)msg[index];
	++index;

	char* fName = new char[len + 1];
	memcpy(fName, &msg[index], len);
	fName[len] = '\0';
	index += len;
	
	filePath = new char[strlen(username) + len + 2];
	strcpy(filePath, username);
	strcat(filePath, "\\");
	strcat(filePath, fName);

	bool ok = true;
	readFile.clear();
	readFile.open("shared.dat");
	if(!readFile)
		ok = false;

	char buf[256];
	bool found = false;
	while(!found && ok)
	{
		readFile.getline(buf, 256);
		if(readFile.eof())
			break;

		if(strcmp(buf, filePath) == 0)
			found = true;
	}
	if(ok)
		readFile.close();

	std::string tempString;
	tempString.append(folderPath);
	tempString.append(filePath);
	HANDLE h = CreateFile(tempString.c_str(), GENERIC_READ, 0,
		NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	fileSize = GetFileSize(h, NULL);
	CloseHandle(h);

	sock.send(htonl(fileSize));
	sock.send((unsigned char)found);

	delete[] filePath;
	filePath = NULL;
}

void Client::setShare()
{
	int index = 1;
	unsigned char fNameLen = (unsigned char)msg[index];
	++index;

	std::string fName = username;
	fName.append("\\");
	fName.append(&msg[index], fNameLen);
	index += fNameLen;

	unsigned char shared = (unsigned char)msg[index];
	if(shared)
	{
		writeFile.clear();
		writeFile.open("shared.dat", std::ios::out | std::ios::app);
		writeFile << fName.c_str() << "\n";
		writeFile.close();
	}
	else
	{
		writeFile.clear();
		writeFile.open("icvtemp.tmp");
		readFile.clear();
		readFile.open("shared.dat");
		if(readFile)
		{
			char buf[256];
			while(true)
			{
				readFile.getline(buf, 256);
				if(readFile.eof())
					break;
				
				if(strcmp(buf, fName.c_str()) != 0)
					writeFile << buf << "\n";
			}
			readFile.close();
		}
		writeFile.close();
		DeleteFile("shared.dat");
		rename("icvtemp.tmp", "shared.dat");
	}
}

void Client::initReceive()
{
	unsigned long byteIndex = 1;

	unsigned char fNameLen = (unsigned char)msg[byteIndex];
	++byteIndex;
	
	char* fName = new char[fNameLen + 1];
	fName[fNameLen] = '\0';
	memcpy(fName, &msg[byteIndex], fNameLen);
	byteIndex += fNameLen;

	filePath = new char[strlen(folderPath) + strlen(username) + fNameLen + 2]; //path + username + '\\' + filename + '\0'
	strcpy(filePath, folderPath);
	strcat(filePath, username);

	CreateDirectory(filePath, NULL);

	strcat(filePath, "\\");
	strcat(filePath, fName);
	writeFile.open(filePath, std::ios::out | std::ios::binary);
	delete[] fName;
	
	packetSize = ntohl(*(unsigned long*)&msg[byteIndex]);
	byteIndex += sizeof(packetSize);
	
	fileSize = ntohl(*(unsigned long*)&msg[byteIndex]);

	packetData = new char[packetSize];
	
	fileBytesTransferred = 0;

	listener = new Socket();
	listener->listen(ICV_DATAPORT);
	listening = true;
}

bool Client::rcvFileBytes()
{
	if(sock.hasData())
	{
		unsigned char cmd;
		sock.receive((char*)&cmd, 1);

		if(cmd == ICV_S_CANCEL)
		{
			progBranch = CPB_HEADER;
			writeFile.close();
			DeleteFile(filePath);
			delete[] filePath;
			filePath = NULL;
			delete[] packetData;
			packetData = NULL;

			while(true)
			{
				int bytes = dataChannel->receive(packetData, packetSize);
				if(bytes == 0 || bytes == SOCKET_ERROR)
					break;
			}
			dataChannel->release();
			delete dataChannel;
			dataChannel = NULL;

			sock.send(ICV_SR_OK);
		}
		return true;
	}
	if(dataChannel->hasData())
	{
		int bytes = dataChannel->receive(packetData, packetSize);
		fileBytesTransferred += bytes;
		rateCounter += bytes;
		
		if(bytes == 0 || bytes == SOCKET_ERROR)
		{
			progBranch = CPB_HEADER;
			writeFile.close();

			dataChannel->release();
			delete dataChannel;
			dataChannel = NULL;
			
			if(bytes == SOCKET_ERROR)
			{
				DeleteFile(filePath);
				delete[] filePath;
				filePath = NULL;
				delete[] packetData;
				packetData = NULL;
				return false;
			}
			
			sock.send(ICV_SR_OK); //bytes == 0 so finished rcv
			resetRateData();
			return true;
		}
				
		writeFile.write(packetData, bytes);
	}
	rateTimeCheck();
	return true;
}

void Client::initSend()
{
	unsigned long byteIndex = 1;

	unsigned char fNameLen = (unsigned char)msg[byteIndex];
	++byteIndex;
	
	char* fName = new char[fNameLen + 1];
	fName[fNameLen] = '\0';
	memcpy(fName, &msg[byteIndex], fNameLen);
	byteIndex += fNameLen;

	packetSize = ntohl(*(unsigned long*)&msg[byteIndex]);
	byteIndex += sizeof(packetSize);
	packetData = new char[packetSize];

	folder = (unsigned char)msg[byteIndex];

	if(folder == ICV_F_PERSONAL)
		filePath = new char[strlen(folderPath) + strlen(username) + fNameLen + 2]; //path + username + '\\' + filename + '\0'
	else
		filePath = new char[strlen(folderPath) + fNameLen + 1];

	strcpy(filePath, folderPath);
	if(folder == ICV_F_PERSONAL)
	{
		strcat(filePath, username);
		strcat(filePath, "\\");
	}
	strcat(filePath, fName);
	delete[] fName;

	HANDLE h = CreateFile(filePath, GENERIC_READ, 0, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	fileSize = GetFileSize(h, NULL);
	CloseHandle(h);
	sock.send(htonl(fileSize));

	readFile.clear();
	readFile.open(filePath, std::ios::in | std::ios::binary);
	delete[] filePath;
	filePath = NULL;
			
	fileBytesTransferred = 0;
	
	listener = new Socket();
	listener->listen(ICV_DATAPORT);
	listening = true;
}

bool Client::sendFileBytes()
{
	//Check for cancel/connection reset
	if(sock.hasData())
	{
		unsigned char cmd;
		int bytes = sock.receive((char*)&cmd, 1);

		if(bytes == 0 || bytes == SOCKET_ERROR ||
			cmd == ICV_S_CANCEL)
		{
			progBranch = CPB_HEADER;
			readFile.close();
			delete[] packetData;
			packetData = NULL;

			dataChannel->release();
			delete dataChannel;
			dataChannel = NULL;
						
			if(cmd == ICV_S_CANCEL)
				return true;
			return false;
		}
	}

	//Do the rest of the sending stuff
	readFile.read(packetData, packetSize);
	//fileBytesTransferred += (dataChannel->send(packetData, readFile.gcount()));
	int bytes = (dataChannel->send(packetData, readFile.gcount()));
	fileBytesTransferred += bytes;
	rateCounter += bytes;

	if(fileBytesTransferred == fileSize)
	{
		progBranch = CPB_HEADER;
		readFile.close();
		delete[] packetData;
		packetData = NULL;

		dataChannel->release();
		delete dataChannel;
		dataChannel = NULL;

		resetRateData();
	}
	rateTimeCheck();
	return true;
}

void Client::rateTimeCheck()
{
	if(lastRateCheck == 0)
		lastRateCheck = GetTickCount();
	if(GetTickCount() - lastRateCheck >= 1000)
	{
		rate = rateCounter;
		rateCounter = 0;
		lastRateCheck += 1000;
	}
}
void Client::resetRateData()
{
	rate = 0;
	rateCounter = 0;
	lastRateCheck = 0;
}

void Client::disconnect()
{
	sock.send(ICV_OP_DISCONNECT);
	sock.release();
}

const char* Client::getUsername()
{
	return username;
}

CLIENTSTATUS Client::getStatus()
{
	CLIENTSTATUS cs;
	cs.connectedTime = GetTickCount() - timeAtConnect;
	switch(progBranch)
	{
	case CPB_FILE_RCV:
		cs.transferType = CSTT_TOSERVER;
		break;
	case CPB_FILE_SEND:
		cs.transferType = CSTT_TOCLIENT;
		break;
	default:
		cs.transferType = CSTT_NONE;
		break;
	}
	cs.fileSize = fileSize;
	cs.bytesTransferred = fileBytesTransferred;
	cs.transferRate = rate >> 10;

	sockaddr_in sAddr;
	int size = sizeof(sAddr);
	getpeername(sock.getAttachedSocket(), (sockaddr*)&sAddr, &size);
	cs.IP = inet_ntoa(sAddr.sin_addr);

	std::ifstream tempFile("shared.dat");
	if(!tempFile)
		cs.filesShared = 0;
	else
	{
		int counter = 0;
		char buf[1024];
		while(true)
		{
			tempFile.getline(buf, 1024);
			if(tempFile.eof())
				break;

			if(memcmp(buf, username, strlen(username)) == 0)
				++counter;
		}
		cs.filesShared = counter;
	}

	return cs;
}

void Client::convertToUpper(char* str)
{
	int len = strlen(str);
	for(int i = 0; i < len; ++i)
	{
		str[i] = toupper(str[i]);
	}
}