#ifndef _CLIENT_H_
#define _CLIENT_H_

#include "../Socket.h"
#include <fstream>

#define ICV_CS_LOGIN 1
#define ICV_CS_FILES 2

#define CPB_HEADER      1
#define CPB_MSG_RCV     2
#define CPB_MSG_PROCESS 3
#define CPB_FILE_RCV    4
#define CPB_FILE_SEND   5

#define CSTT_NONE 1
#define CSTT_TOSERVER 2
#define CSTT_TOCLIENT 3

struct CLIENTSTATUS
{
	unsigned char transferType;
	unsigned long transferRate;
	unsigned long fileSize;
	unsigned long bytesTransferred;
	DWORD connectedTime;
	std::string IP;
	unsigned long filesShared;
};

class Client
{
public:
	Client(const Socket& s);
	~Client();
	bool doOperations();
	void disconnect();

	const char* getUsername();
	CLIENTSTATUS getStatus();

protected:
	void newUser();
	void login();
	void deleteFile();
	void renameFile();
	void sendShare();
	void setShare();

	void sendDirList();
	void sendUserList();
	void sendUserInfo();

	void initReceive();
	bool rcvFileBytes();
	void initSend();
	bool sendFileBytes();

	void rateTimeCheck();
	void resetRateData();

	void convertToUpper(char* str);

	Socket sock;
	Socket* dataChannel;
	Socket* listener;

	int stage;
	DWORD timeAtConnect;
	bool admin;
	bool guest;

	int progBranch;
	bool listening;

	int headerBytesReceived;

	unsigned long msgBytesReceived;
	unsigned long totalMsgBytes;
	char* msg;
	char header[4];

	unsigned long rate;
	unsigned long rateCounter;
	DWORD lastRateCheck;

	unsigned long fileSize;
	unsigned long packetSize;
	char* filePath;
	unsigned long fileBytesTransferred;
	char* packetData;

	std::ofstream writeFile;

	unsigned char folder;
	std::ifstream readFile;

	char username[256];
	char folderPath[MAX_PATH];
};

#endif