#include "../Socket.h"
#include "../commandCodes.h"
#include "main.h"
#include "resource.h"
#include "Client.h"

#include <fstream>
#include <vector>
#include <math.h>

//Global Variables
bool quit = false;
HWND hWnd;
HINSTANCE hinst;
std::vector<Client*> clients;

//+----------------------+
//|     *WinMain()*      |
//+----------------------+

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR cmd, int showCmd)
{
	hinst = hInst;
	hWnd = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DIALOG),
		NULL, DialogProc);
	ShowWindow(hWnd, SW_SHOW);

	appInit();

	Socket server;
	if(!server.listen(ICV_PORT))
		quit = true;

	MSG msg;
	while(!quit)
	{
		if(server.hasData())
		{
			clients.push_back(new Client(server.accept()));
			int strSize = (int)log((double)clients.size()) + 2;
			char* str = new char[strSize];
			itoa(clients.size(), str, 10);
			SetDlgItemText(hWnd, IDC_CLIENTS, str);
			delete[] str;
		}
		for(int i = 0; i < clients.size(); ++i)
		{
			if(!clients[i]->doOperations())
			{
				delete clients[i];
				clients.erase(&clients[i]);
				int strSize = (int)log((double)clients.size()) + 2;
				char* str = new char[strSize];
				itoa(clients.size(), str, 10);
				SetDlgItemText(hWnd, IDC_CLIENTS, str);
				delete[] str;
			}
		}
		if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	server.release();
	appShutdown();

	return 0;
}


//+-------------------------+
//|   *Dialog Procedures*   |
//+-------------------------+

BOOL CALLBACK DialogProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_SETSHARE:
			HWND newDlg;
			newDlg = CreateDialog(hinst, MAKEINTRESOURCE(IDD_SHARING),
				hWnd, ShareProc);
			ShowWindow(newDlg, SW_SHOW);
			return true;
		case IDC_GETUSERINFO:
			newDlg = CreateDialog(hinst, MAKEINTRESOURCE(IDD_USERINFO),
				hWnd, UserInfoProc);
			ShowWindow(newDlg, SW_SHOW);
			return true;
		case IDC_CONNECTINFO:
			newDlg = CreateDialog(hinst, MAKEINTRESOURCE(IDD_CONNECTINFO),
				hWnd, ConnectInfoProc);
			ShowWindow(newDlg, SW_SHOW);
			return true;
		case IDC_CHANGEPASS:
			newDlg = CreateDialog(hinst, MAKEINTRESOURCE(IDD_CHANGEPASS),
				hWnd, ChangePassProc);
			ShowWindow(newDlg, SW_SHOW);
			return true;

		case IDC_QUIT:
			quit = true;
			DestroyWindow(hWnd);
			return true;
		}
		return true;
	case WM_CLOSE:
		quit = true;
		DestroyWindow(hWnd);
		return true;
	}
	return false;
}

BOOL CALLBACK ChangePassProc(HWND hWnd, UINT msg, WPARAM wParam,
							 LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDCANCEL:
			DestroyWindow(hWnd);
			break;

		case IDOK:
			char buf[256] = "";
			GetDlgItemText(hWnd, IDC_PASS, buf, 255);
			char buf2[256] = "";
			GetDlgItemText(hWnd, IDC_PASSCONFIRM, buf2, 255);

			if(strcmp(buf, buf2) != 0)
				break;
			
			std::ofstream file("adminpass.cfg");
			file.write(buf, strlen(buf));
			DestroyWindow(hWnd);
			break;
		}
		return true;

	case WM_CLOSE:
		DestroyWindow(hWnd);
		return true;
	}
	return false;
}

BOOL CALLBACK ShareProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		SetDlgItemText(hWnd, IDC_STATICDIR, "c:\\");
		getDirList(hWnd, IDC_DIRLIST, IDC_STATICDIR, true);
		getDirList(hWnd, IDC_FILELIST, IDC_STATICDIR, false);
		getDirList(hWnd, IDC_SHAREDFILES, "Users\\SERVERSHARE", false, false);
		return false;

	case WM_CLOSE:
		DestroyWindow(hWnd);
		return true;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_DONE:
			DestroyWindow(hWnd);
			return true;

		case IDC_SHARE:
			addSharedFile(hWnd);
			getDirList(hWnd, IDC_SHAREDFILES, "Users\\SERVERSHARE", false, false);
			return true;

		case IDC_UNSHARE:
			removeSharedFile(hWnd);
			getDirList(hWnd, IDC_SHAREDFILES, "Users\\SERVERSHARE", false, false);
			return true;

		case IDC_DIRLIST:
			if(HIWORD(wParam) == LBN_DBLCLK)
			{
				char path[MAX_PATH];
				GetDlgItemText(hWnd, IDC_STATICDIR, path, MAX_PATH);
				
				HWND ctrl = (HWND)lParam;
				char buf[MAX_PATH];
				int index = (int)SendMessage(ctrl, LB_GETCURSEL, 0, 0);
				SendMessage(ctrl, LB_GETTEXT, index, (LPARAM)buf);

				std::string newPath = path;
				if(strcmp(buf, "..") == 0)
				{
					int pos = newPath.find_last_of("\\");
					newPath.erase(pos, newPath.size() - 1);
					if(newPath.compare("c:") == 0)
						newPath.append("\\");
				}
				else
				{
					if(newPath.compare("c:\\") != 0)
						newPath.append("\\");
					newPath.append(buf);
				}

				SetDlgItemText(hWnd, IDC_STATICDIR, newPath.c_str());
				getDirList(hWnd, IDC_DIRLIST, newPath.c_str(), true, true);
				getDirList(hWnd, IDC_FILELIST, newPath.c_str(), false, false);
			}
			return true;
		}
		return true;
	}
	return false;
}

BOOL CALLBACK UserInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		HWND ctrl;
		ctrl = GetDlgItem(hWnd, IDC_USERLIST);
		int i;
		for(i = 0; i < clients.size(); ++i)
			SendMessage(ctrl, LB_ADDSTRING, 0, (LPARAM)clients[i]->getUsername());
		return false;
	case WM_CLOSE:
		DestroyWindow(hWnd);
		return true;
	
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_DONE:
			DestroyWindow(hWnd);
			break;

		case IDC_GETINFO:
			getClientInfo(hWnd);
			break;
		case IDC_DROP:
			dropClient(hWnd);
			break;
		}
		return true;
	}
	return false;
}

BOOL CALLBACK ConnectInfoProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	Socket s(false);
	std::ifstream file;
	switch(msg)
	{
	case WM_INITDIALOG:
		SetDlgItemInt(hWnd, IDC_STATICCPORT, ICV_PORT, false);
		SetDlgItemInt(hWnd, IDC_STATICFTPORT, ICV_DATAPORT, false);

		s.init();
		char buf[512];
		bool fileOk;
		file.open("inethosts.dat");
		fileOk = file.is_open();
		bool ok;
		ok = false;
		while(!file.eof() && !ok && fileOk)
		{
			file.getline(buf, 512);
			if(s.connect(buf, 80))
				ok = true;
		}
		if(!ok)
		{
			SetDlgItemText(hWnd, IDC_STATICIP, "Could not find IP");
		}
		else
		{
			sockaddr_in addr;
			int size;
			size = sizeof(addr);
			getsockname(s.getAttachedSocket(), (sockaddr*)&addr, &size);
			SetDlgItemText(hWnd, IDC_STATICIP, inet_ntoa(addr.sin_addr));
		}
		s.release();
		return false;

	case WM_CLOSE:
		DestroyWindow(hWnd);
		return true;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_DONE:
			DestroyWindow(hWnd);
			break;
		}
		return true;
	}
	return false;
}

//The listbox directory-listing
void getDirList(HWND hWnd, int listboxID, int pathID, bool directory, bool prevs)
{
	char* temp;
	int len;

	HWND path = GetDlgItem(hWnd, pathID);
	len = SendMessage(path, WM_GETTEXTLENGTH, 0, 0);
	temp = new char[len + 1];
	SendMessage(path, WM_GETTEXT, len + 1, (LPARAM)temp);

	getDirList(hWnd, listboxID, temp, directory, prevs);

	delete[] temp;
}

void getDirList(HWND hWnd, int listboxID, const char* path, bool directory, bool prevs)
{
	WIN32_FIND_DATA wfd;

	std::string searchString;
	searchString = path;
	if(strcmp(path, "c:\\") != 0)
		searchString.append("\\");
	searchString.append("*.*");

	HWND listbox = GetDlgItem(hWnd, listboxID);
	SendMessage(listbox, LB_RESETCONTENT, 0, 0);

	HANDLE h = FindFirstFile(searchString.c_str(), &wfd);
	if(h == INVALID_HANDLE_VALUE)
		return;

	int res;
	do
	{
		if( (
				directory ^
				!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			)
			&&
			(
				prevs || (strcmp(wfd.cFileName, "..") != 0)
			)
			&&
			strcmp(wfd.cFileName, ".") != 0
		   )
		{
			SendMessage(listbox, LB_ADDSTRING, 0, (LPARAM)wfd.cFileName);
		}
		
		res = FindNextFile(h, &wfd);
	}while(res != 0);

	FindClose(h);
}

void addSharedFile(HWND hWnd)
{
	int index = SendDlgItemMessage(hWnd, IDC_FILELIST, LB_GETCURSEL, 0, 0);
	if(index == LB_ERR)
	{
		MessageBox(hWnd, "No file selected.", "Error", MB_OK);
		return;
	}
	int len = SendDlgItemMessage(hWnd, IDC_FILELIST, LB_GETTEXTLEN, index, 0);
	char* fName = new char[len + 1];
	SendDlgItemMessage(hWnd, IDC_FILELIST, LB_GETTEXT, index, (LPARAM)fName);

	std::string newFName = "Users\\SERVERSHARE\\";
	newFName.append(fName);

	bool alreadyExists = false;

	WIN32_FIND_DATA wfd;
	HANDLE h = FindFirstFile(newFName.c_str(), &wfd);
	if(h != INVALID_HANDLE_VALUE &&
		!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
	{
		FindClose(h);
		if(MessageBox(hWnd, "A file with the same name already\nexists in the shared folder. Replace?", "Overwrite File", MB_YESNO) == IDNO)
			return;

		alreadyExists = true;
		DeleteFile(newFName.c_str());
	}

	CreateDirectory("Users", NULL);
	CreateDirectory("Users\\SERVERSHARE", NULL);

	len = SendDlgItemMessage(hWnd, IDC_STATICDIR, WM_GETTEXTLENGTH, 0, 0);
	char* dir = new char[len + 1];
	SendDlgItemMessage(hWnd, IDC_STATICDIR, WM_GETTEXT, len + 1, (LPARAM)dir);

	std::string origFName;
	origFName = dir;
	if(strcmp(dir, "c:\\") != 0)
		origFName.append("\\");
	origFName.append(fName);

	CopyFile(origFName.c_str(), newFName.c_str(), FALSE);
	if(!alreadyExists)
	{
		std::ofstream temp("shared.dat", std::ios::out | std::ios::app);
		temp << "SERVERSHARE\\" << fName << "\n";
	}

	delete[] dir;
	delete[] fName;
}

void removeSharedFile(HWND hWnd)
{
	int index = SendDlgItemMessage(hWnd, IDC_SHAREDFILES, LB_GETCURSEL, 0, 0);
	if(index == LB_ERR)
	{
		MessageBox(hWnd, "No file selected.", "Error", MB_OK);
		return;
	}

	int len = SendDlgItemMessage(hWnd, IDC_SHAREDFILES, LB_GETTEXTLEN, index, 0);
	char* fName = new char[len + 1];
	SendDlgItemMessage(hWnd, IDC_SHAREDFILES, LB_GETTEXT, index, (LPARAM)fName);

	std::string strPath = "Users\\SERVERSHARE\\";
	strPath.append(fName);
	delete[] fName;

	//Set file attributes to normal, so DeleteFile() won't fail
	SetFileAttributes(strPath.c_str(), FILE_ATTRIBUTE_NORMAL);
	DeleteFile(strPath.c_str());

	strPath.erase(0, 6); //erase "Users\\"

	std::ifstream inFile("shared.dat");
	if(inFile.is_open())
	{
		std::ofstream outFile("icvTemp.tmp");
		char buf[256];
		while(true)
		{
			inFile.getline(buf, 256);
			if(inFile.eof())
				break;
			
			if(strcmp(buf, strPath.c_str()) != 0)
				outFile << buf << "\n";
		}
		inFile.close();
		outFile.close();
		DeleteFile("shared.dat");
		rename("icvTemp.tmp", "shared.dat");
	}
}

void getClientInfo(HWND hWnd)
{
	int index = SendDlgItemMessage(hWnd, IDC_USERLIST, LB_GETCURSEL, 0, 0);
	if(index == LB_ERR)
	{
		MessageBox(hWnd, "No user selected.", "Error", MB_OK);
		return;
	}
	int len = SendDlgItemMessage(hWnd, IDC_USERLIST, LB_GETTEXTLEN, index, 0);
	char* username = new char[len + 1];
	SendDlgItemMessage(hWnd, IDC_USERLIST, LB_GETTEXT, index, (LPARAM)username);

	CLIENTSTATUS cs;
	bool found = false;
	for(int i = 0; i < clients.size() && !found; ++i)
	{
		if(strcmp(clients[i]->getUsername(), username) == 0)
		{
			cs = clients[i]->getStatus();
			found = true;
		}
	}
	if(!found)
	{
		MessageBox(hWnd, "Client has already disconnected.", "Error", MB_OK);
		SendDlgItemMessage(hWnd, IDC_USERLIST, LB_DELETESTRING, index, 0);
	}
	else
	{
		SetDlgItemText(hWnd, IDC_STATICIP, cs.IP.c_str());

		char tempBuf[15];

		itoa(cs.filesShared, tempBuf, 10);
		SetDlgItemText(hWnd, IDC_STATICSHARED, tempBuf);

		int seconds = cs.connectedTime / 1000;

		itoa(seconds, tempBuf, 10);
		std::string tempString = tempBuf;
		tempString.append(" seconds");
		SetDlgItemText(hWnd, IDC_STATICTIME, tempString.c_str());

		switch(cs.transferType)
		{
		case CSTT_TOSERVER:
			SetDlgItemText(hWnd, IDC_STATICTTYPE, "To Server");
			break;
		case CSTT_TOCLIENT:
			SetDlgItemText(hWnd, IDC_STATICTTYPE, "To Client");
			break;
		case CSTT_NONE:
			SetDlgItemText(hWnd, IDC_STATICTTYPE, "None");
			break;
		}

		if(cs.transferType != CSTT_NONE)
		{
			itoa(cs.transferRate, tempBuf, 10);
			tempString = tempBuf;
			tempString.append(" kb/s");
			SetDlgItemText(hWnd, IDC_STATICRATE, tempString.c_str());
			
			itoa(cs.fileSize, tempBuf, 10);
			tempString = tempBuf;
			tempString.append(" bytes");
			SetDlgItemText(hWnd, IDC_STATICSIZE, tempString.c_str());
			
			itoa(cs.bytesTransferred, tempBuf, 10);
			tempString = tempBuf;
			tempString.append(" bytes");
			SetDlgItemText(hWnd, IDC_STATICTRANSD, tempString.c_str());
		}
		else
		{
			SetDlgItemText(hWnd, IDC_STATICRATE, "");
			SetDlgItemText(hWnd, IDC_STATICSIZE, "");
			SetDlgItemText(hWnd, IDC_STATICTRANSD, "");
		}
	}

	delete[] username;
}

void dropClient(HWND hWnd)
{
	int index = SendDlgItemMessage(hWnd, IDC_USERLIST, LB_GETCURSEL, 0, 0);
	if(index == LB_ERR)
	{
		MessageBox(hWnd, "No user selected.", "Error", MB_OK);
		return;
	}
	int len = SendDlgItemMessage(hWnd, IDC_USERLIST, LB_GETTEXTLEN, index, 0);
	char* username = new char[len + 1];
	SendDlgItemMessage(hWnd, IDC_USERLIST, LB_GETTEXT, index, (LPARAM)username);

	if(!dropClient(username))
		MessageBox(hWnd, "Client already disconnected.", "Error", MB_OK);

	delete[] username;

	SendDlgItemMessage(hWnd, IDC_USERLIST, LB_DELETESTRING, index, 0);
}

bool dropClient(const char* name)
{
	bool found = false;
	for(int i = 0; i < clients.size() && !found; ++i)
	{
		if(strcmp(clients[i]->getUsername(), name) == 0)
		{
			found = true;
			break; //now i points to the matching client
		}
	}

	if(!found)
		return false;		
	
	clients[i]->disconnect();
	delete clients[i];
	clients.erase(&clients[i]);
	
	char* str = new char[(int)log((double)clients.size()) + 2];
	itoa(clients.size(), str, 10);
	SetDlgItemText(hWnd, IDC_CLIENTS, str);
	delete[] str;

	return true;
}

//+-------------------------------+
//|   *Init/Shutdown Functions*   |
//+-------------------------------+

void appInit()
{
	Socket::networkInit();
}

void appShutdown()
{
	while(clients.size() > 0)
	{
		clients.back()->disconnect();
		delete clients.back();
		clients.pop_back();
	}
	Socket::networkShutdown();
}