#ifndef _SOCKET_H_
#define _SOCKET_H_

#pragma comment(lib, "WS2_32.lib")
#include <winsock2.h>

#include <string>

class Socket
{
public:
	//General Winsock startup and shutdown
	static bool networkInit();
	static void networkShutdown();

	//Constructor/Destructor/operators
	Socket(bool init = true);
	Socket(SOCKET s);
	Socket(const Socket& s);
	~Socket();

	Socket& operator = (const Socket& s);

	//Client-side functions
	bool connect(const char* host, unsigned short port);

	//Server-side functions
	bool listen(unsigned short port, int backlog = SOMAXCONN);
	Socket accept();

	//General functions
	bool init();

	int send(unsigned char uchar);
	int send(unsigned short ushort);
	int send(unsigned long ulong);
	int send(const char* buf, int len);
	int send(const std::string& buf);

	int receive(char* buf, int len);
	int packetReceive(char* buf, int len);

	void release();

	bool hasData();
	bool writable();
	unsigned int getMaxMsgSize();
	SOCKET getAttachedSocket();

	bool valid();

protected:
	unsigned long getHost(const char* host);

	bool ok;
	int* sockRefCount;
	bool thisSocketConnected;
	SOCKET sock;
};

#endif