#ifndef _COMMANDCODES_H_
#define _COMMANDCODES_H_

//Macro defined for convenience
#define _uc(x) ((unsigned char)x)

//Protocol defines
#define ICV_PORT 23322
#define ICV_DATAPORT 23323

//Operations
#define ICV_OP_LOGIN _uc(1)
#define ICV_OP_NEWUSER _uc(2)

#define ICV_OP_TOCLIENT _uc(3)
#define ICV_OP_TOSERVER _uc(4)
#define ICV_OP_RENAME _uc(5)
#define ICV_OP_DELETE _uc(6)
#define ICV_OP_GETSHARE _uc(7)
#define ICV_OP_SETSHARE _uc(8)
#define ICV_OP_GETDIRLIST _uc(9)

#define ICV_OP_LOGOUT _uc(10)
#define ICV_OP_DISCONNECT _uc(11)

//Admin commands
#define ICV_OP_GETUSERLIST _uc(12)
#define ICV_OP_GETUSERINFO _uc(13)
#define ICV_OP_DROPUSER _uc(14)
#define ICV_OP_SHUTDOWN _uc(15)

//Status check
#define ICV_S_CONTINUE _uc(16)
#define ICV_S_END _uc(17)

#define ICV_S_CONTINUESEND ICV_S_CONTINUE
#define ICV_S_CANCEL ICV_S_END

//Server responses
#define ICV_SR_OK _uc(18)
#define ICV_SR_ERR _uc(19)
#define ICV_SR_ERR2 _uc(20)

#define ICV_SR_BADNAME _uc(21)
#define ICV_SR_BADPASS _uc(22)
#define ICV_SR_NOACCESS _uc(23)

//Folder codes - separate folders not implemented yet
#define ICV_F_PERSONAL _uc(24)
#define ICV_F_SHARED _uc(25)

#endif