#include "errLogger.h"

const DWORD progStartTime = GetTickCount();

//LogFileData struct definition
struct LogFileData
{
	std::string name;
	std::vector<char*> pastStrings;
	std::vector<unsigned long> strCounts;
	DWORD last;
	bool firstLog;
};


//***********************************
//**logToFile() function definition**
//***********************************

//The raw-data logger, no fancy stuff involved
void logToFile(const char* data, int n, char* fname)
{
	//Quit if string is NULL
	if(data == NULL || n <= 0)
		return;

	//If filename specified, use that.
	//  Default is "def_log.txt" for 1st use or
	//  else what the last specified filename was.
	static char* filename = "def_log.txt";
	if(fname != NULL)
		filename = fname;

	std::ofstream fout(filename, std::ios::app | std::ios::binary);
	fout.write(data, n);
	fout << "\r\n";
}

//Text logger, logs running time and other info
void logToFile(const char* string, char* fname)
{
	static char* filename = "def_log.txt";

	DWORD loggedTime = GetTickCount();

	//If string is NULL, set filename
	if(string == NULL)
	{
		if(fname == NULL)
			return;
		
		filename = fname;
		return;
	}
	else if(strcmp(string, "\0") == 0)
		return;

	//If filename specified, use that.
	//Default is "def_log.txt" for 1st use or
	//else what the last filename was.
	if(fname != NULL)
		filename = fname;

	//define vector of LogFileData objects
	static std::vector<LogFileData> files;

	//init the file
	std::ofstream fout(filename, std::ios::app);

	//point i to the correct LogFileData
	bool found = false;
	for(int i = 0; i < files.size(); ++i)
	{
		if(strcmp(files[i].name.c_str(), filename) == 0)
		{
			found = true;
			break;
		}
	}
	if(!found)
	{
		LogFileData lfd;
		lfd.name = filename;
		lfd.last = 0;
		lfd.firstLog = true;
		files.push_back(lfd);
	}

	//if file hasn't been written to yet, init the file
	if(files[i].firstLog)
	{
		fout << "\n";
		fout << "+-------------------------+\n";
		fout << "|     *Program Start*     |\n";
		fout << "+-------------------------+\n\n";
		files[i].firstLog = false;
	}

	//search through file's log history
	//and point j to the correct index
	found = false;
	for(int j = 0; j < files[i].pastStrings.size(); ++j)
	{
		if(strcmp(files[i].pastStrings[j], string) == 0)
		{
			found = true;
			break;
		}
	}
	if(found)
		++files[i].strCounts[j];
	else
	{
		files[i].pastStrings.push_back((char*)string);
		files[i].strCounts.push_back(1);
	} //now j = files[i].pastStrings.size() - 1

	if(loggedTime - files[i].last > 400)
		fout << "\n//Running time: " << loggedTime - progStartTime << " ms\n";
	fout << string << " - " << files[i].strCounts[j] << "\n";
	fout.close();

	files[i].last = loggedTime;
}

//*****************************************
//**logToFile() aux. functions definition**
//*****************************************

void logToFile(double value, char* fname)
{
	char temp[19];
	gcvt(value, 17, temp);
	logToFile(temp, fname);
}