'Here is a sketch to importing your own graphics made with QBASIC Paint.
'Simply change the names of the vars to the ones you need, make a picture,
'scan it in from the file, and scan its negative!  Be sure to change the
'mask% according to your screen capabilities.  For 16 colors, it should be
'15, and for 256 colors, make it 255.

'The dlay var is there to slow down your game properly, so that it can work
'On fast and slow computers.  I updated the routine so that it works properly.
'No more INTeger dlay%!  It's gonna be a single!

'I'd love to see your art with QBASIC Paint!  I like the useful tools I built
'into it to make your drawing clones shine!  All I want is a remark saying
'that you got it from me.  Say "Code derived from DoomRater's QBASIC Paint
'the Wall."

'That should be everything!  Please learn more about this engine!

DEFINT A-Z
DECLARE SUB sizeit (size%, a%, b%)
DECLARE SUB delay ()
DIM SHARED dlay AS SINGLE, cur AS SINGLE
mask% = 255       'cause I'm using SCREEN 13
dlay = .2               'For the delay routine... .2 for some lag.
SCREEN 13      'Cause I want colors!
RANDOMIZE TIMER        'A good seed!

'This code was simplified for my own use.  I took all this and ate it up
'into a ball bouncing routine.  Enjoy the bouncing ball!

'Oh yes, if your sprites are small enough, you can always use a single array
'for multiple designs!  Example would be motion frames.  Place them in the
'same array, but starting at a different number!  This'll cure your problems
'for animation!  You can then reference each frame as a number times the frame
'you want.  Or say you like creating tiles for a map instead of hand drawing
'each single screen.  You can do that, too!

'And that's exactly what I did here.  The best way to do it!

OPEN "ball.dat" FOR INPUT AS 3 'Open the data file list for reference...
LINE INPUT #3, a$
size% = VAL(a$)   'I had to do this first...
DIM ball(size% * 3 - 1), ballm(size% * 3 - 1) '*3 means that we get three
                                              'frames, and the -1 gets rid
                                              'of the last useless var.
DIM holdupdre(size%)
FOR Frame = 0 TO 2
LINE INPUT #3, file$
OPEN file$ FOR BINARY AS 1
sizeit size%, a, b  'I'm gonna assume that the var is the same... and if
                    'it's not... there'll be @#%# to pay in the end.
a$ = " "
FOR t = 0 TO a - 1
FOR m = 0 TO b - 1
GET #1, , a$  'Grab the data from the file...
PSET (t, m), ASC(a$)  'Put it on the screen...
IF ASC(a$) = 0 THEN PSET (t + a, m), mask% ELSE PRESET (t + a, m) 'Place the mask on there too...
NEXT m, t 'Loop...
CLOSE 1  'Clean up
GET (0, 0)-(a - 1, b - 1), ball(Frame * size%) 'Now grab the first ball.
GET (a, 0)-(2 * a - 1, b - 1), ballm(Frame * size%)'And its mask.
NEXT 'The next frame of the ball!
CLOSE 3 'Now we shut up that file.

'Your programming code would go here...  I'll provide an example that does
'a ball bouncing, like the kind I've seen before.

CLS
x = 159   'To start the ball in the middle
y = 100   'of the screen.
ballnum = 0  'The first sprite number is up.
xdir = 2: ydir = 2  'The higher you set these, the more choppy the
                    'animation looks, but the faster it moves on the screen!

DO
FOR t = 0 TO 24   'Let's put something on the screen, shall we?
LOCATE t + 1, 1
COLOR INT(RND * 15) + 1
PRINT "LostLostLostLostLostLostLostLostLostLost";
NEXT
GET (x, y)-(x + a - 1, y + b - 1), holdupdre  'Set up the holdupdre var
FOR t = 1 TO 100
a$ = INKEY$
cur = TIMER + dlay
PUT (x, y), holdupdre, PSET 'Place the background in there.
x = x + xdir: y = y + ydir
IF x > 320 - a OR x < 0 THEN xdir = -xdir: x = x + xdir
IF y > 200 - b OR y < 0 THEN ydir = -ydir: y = y + ydir
GET (x, y)-(x + a - 1, y + b - 1), holdupdre  'Grab the background
PUT (x, y), ballm(ballnum * size%), AND   'Mask the background
PUT (x, y), ball(ballnum * size%), OR     'And place the image there instead
ballnum = ballnum + 1: IF ballnum = 3 THEN ballnum = 0
delay
IF a$ <> "" THEN EXIT FOR
NEXT
IF a$ <> "" THEN EXIT DO
LOOP
SCREEN 0: WIDTH 80, 25
CLS
PRINT "I hope you enjoyed this frame of a program!"
PRINT : PRINT
SYSTEM

DEFSNG A-Z
SUB delay
WHILE cur > TIMER: WEND
END SUB

SUB sizeit (size%, a%, b%)
a$ = " "
GET #1, , a$
ab = ASC(a$)
GET #1, , a$
ac = ASC(a$)
a% = ab * 256 + ac
GET #1, , a$
b% = ASC(a$)
size% = a% * b%
END SUB

