package ccmenu;

import java.util.HashMap;
import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class AddController
{
  private static final String[][] CONTROLLS =
      {
        {"2", "2-Btn"},
        {"K", "Keypad"},
        {"P", "Paddles"},
        {"D", "Drive"},
        {"C", "CosmicCmd"},
        {"B", "BoostrGrp"},
        {"F", "FootCraz"},
        {"I", "KidCtrl"},
        {"V", "Joy+TPad"},
        {"L", "LGun"},
        {"JL", "Joy/LGun"},
        {"J2L", "2BJoy/LGun"},
        {"KV", "KidVid"}
      };
      private HashMap myControlls = null;

      private static final int DB_CRC        = 4;
      private static final int DB_CONTROL    = 5;
      /** The max length of a game name/discription */
     static final int MAX_GAME_NAME_LEN = 40;

     static final String SPACES = "                                                                           ";

  public AddController()
  {
    myControlls = new HashMap(CONTROLLS.length);
    for(int index=0; index < CONTROLLS.length; ++index)
    {
      myControlls.put(CONTROLLS[index][0], CONTROLLS[index][1]);
    }
  }



  public void addControllers(String[] args)
  {
    BufferedReader inBuffer=null;

    try {
      CC2Database theDb = new CC2Database();

      File controlFile = new File(args[0]);
      try {
         inBuffer=new BufferedReader(new FileReader(controlFile));
      }
      catch (FileNotFoundException ex)
      {
          throw new Exception("File " + controlFile.getAbsolutePath() +
                              " not found.");
      }

      String aLine;
      String[] entries;
      int lineNum = 0;
      RomEntry aRomEntry;
      String ctlString = null;
      StringBuffer name = null;
      int sizeToAdd = 0;

      try
      {
         while ( (aLine=inBuffer.readLine()) != null )
         {
            lineNum++;
            entries = aLine.split("\\t+");  // split on one or more tabs

            aRomEntry = theDb.lookup(entries[DB_CRC]);
            ctlString = (String)myControlls.get(entries[DB_CONTROL]);

            if(null != aRomEntry &&
              null != ctlString)
           {
              aRomEntry.setController(entries[DB_CONTROL]);


              /*
             name = new StringBuffer(aRomEntry.getName().trim());

            // here is where it happens:

            // add spaces:
            sizeToAdd = MAX_GAME_NAME_LEN - name.length() - ctlString.length();
            if(sizeToAdd > 0)
            {
              name.append(SPACES.substring(0,sizeToAdd));
              name.append(ctlString);
              aRomEntry.setName(name.toString());
            }
            else
            {
                System.err.println("too small a name: " + aLine);
            }*/
           }
         }
         theDb.writeToFile(new File(args[1]));
      }
      catch (IOException ex)
      {
          System.err.println("Error: an IOException");
      }
      finally
      {
          try
          {
             inBuffer.close();
          }
          catch(IOException ex)
          {
             System.err.println("Error: an IOException");
          }
      }



    }
    catch (Exception ex) {
      System.err.print(ex);
      ex.printStackTrace(System.err);
    }


  }


  public static void main(String[] args)
  {
    AddController addController1 = new AddController();
    addController1.addControllers(args);
  }

}
