package ccmenu;


import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionListener;

import java.io.File;

import javax.swing.*;
import javax.swing.border.*;
import java.io.IOException;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.*;


/**
 * A GUI Dialog box to get CC2 main directory menu include options
 * and pass to the CC2MenuGenerate program.
 */
public class CC2Dialog extends JFrame implements ActionListener
{
   private JButton myOpnBrowse = new JButton();
   private JButton myGenerateBtn = new JButton();
   private JFileChooser myFileChooser = new JFileChooser();
   private JTextField myInFileTxt = new JTextField();
   private GridBagLayout myGridBay = new GridBagLayout();
   private JTextArea myOutDirTxt = new JTextArea();
   private JPanel myInputPanel = new JPanel();
   private BorderLayout borderLayout2 = new BorderLayout();
   private TitledBorder myInTitleBorder;
   private JTextArea myExampleTextArea = new JTextArea();
   private JScrollPane myScrollArea = null;

   private JPanel myCheckPanel = new JPanel();


   /** Index of by names check box */
   private final static int BY_NAMES_INDEX = 0;
   /** Index of by company check box */
   private final static int BY_COMP_INDEX = 1;
   /** Index of by controller check box */
   private final static int BY_CONTROL_INDEX = 2;

   /** Current Section checkbox names and tool tip strings */
   private final static String[][] CHECKBOX_STRS =
   {
      {"By Name", "Add Section sorted by Menu names"},
      {"By Company", "Add Section sorted by Company"},
      {"By Controller", "Add section sorted by Controller Used"}
   };

   /** all check boxes */
   private JCheckBox[] myCheckBoxes = null;
   GridBagLayout gridBagLayout1 = new GridBagLayout();

   private final static Font MONO_FONT = new Font("Monospaced", Font.PLAIN, 12);
   private final static String CONT_STR = "...\n";

   private Properties myProperties = new Properties();

   /** This is what to print when no sections are added. */
   private final static String EXAMPLE_NO_TEXT = "<No items in menu>";


   /**
    * These strings give examples of the options the user adds.
    * This order must be the same as in allCheckBoxes
    */
   private static String[] EXAMPLE_TEXTS =
      {
      // example of by name:
      "7800: Ace Of Aces\n7800: Alien Brigade\n7800: Asteroids\n" +
      "7800: Ballblazer\n" + CONT_STR +
      "A-Team (Proto - Save Hannibal)\n" +
      "Acid Drop (PAL)\nAdventure\n" + CONT_STR,
      // example of by company:
      "------------20th Century Fox------------\nAlien\n" +
      "Alligator People (Proto)\n" + CONT_STR +
      "---------------Activision---------------\n" +
      "7800: Double Dragon                2-Btn\nBarnstorming\n" + CONT_STR,
      // example of by controller:
      "----------------Joystick----------------\n" +
      "7800: Asteroids\n7800: Ballblazer\n7800: Centipede\n" + CONT_STR +
      "Adventure\nAdventures of TRON\nAir Raid" + CONT_STR +
      "----------------Paddles-----------------\n" +
      "Astroblast                       Paddles\n" +
      "Bachelor Party                   Paddles\n" +
      "Bachelorette Party               Paddles\n" +
      "Backgammon                       Paddles" + CONT_STR
   };

   private final static String ROM_PATH_PROPERTY = "last.rom.path";
   private final static String PROPERTY_FILE = "cc2menu.prop";
   private final static String PROPERTY_FILE_COMMENT =
      "Sets CC2 Menu Generate attributes at startup";

   /**
    * Constructer: creates the dialog box.
    */
   public CC2Dialog()
   {
      jbInit();
      getSavedProperties();
   }


   /** Method to read in the PROPERTY_FILE and set user's last selections */
   private void getSavedProperties()
   {
      // load properties
      try
      {
         FileInputStream in = new FileInputStream(PROPERTY_FILE);
         myProperties.load(in);
         in.close();
      }
      catch (FileNotFoundException ex)
      {
      }
      catch (IOException ex)
      {
      }
      String romPath = myProperties.getProperty(ROM_PATH_PROPERTY);
      if (null == romPath || romPath.trim().length() < 1)
      {
         romPath = getDefaultPath();
      }
      myInFileTxt.setText(romPath);
   }


   /** Saves current user preferences to PROPERTY_FILE */
   private void saveProperties()
   {
      // load properties
      try
      {
         myProperties.setProperty(ROM_PATH_PROPERTY, myInFileTxt.getText());
         FileOutputStream out = new FileOutputStream(PROPERTY_FILE);
         myProperties.store(out, PROPERTY_FILE_COMMENT);
         out.close();
      }
      catch (FileNotFoundException ex)
      {
      }
      catch (IOException ex)
      {
      }
   }


   /**
    * Creates the dialog box.
    */
   private void jbInit()
   {
      //load icon
      //Image app_icon = Toolkit.getDefaultToolkit().getImage("cc2.jpg");
      Image app_icon = Toolkit.getDefaultToolkit().
         getImage(getClass().getResource("cc2.jpg"));
      if (null != app_icon)
      {
         setIconImage(app_icon);
      }

      addWindowListener(new WindowAdapter()
      {
         public void windowClosing(WindowEvent e)
         {
            System.exit(0);
         }
      });

      getContentPane().setLayout(myGridBay);

      myInTitleBorder = new TitledBorder(
         BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)),
         "Rom Directory");

      myFileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

      //myFileChooser.addChoosableFileFilter( new DirFileFilter() );

      myOpnBrowse.setMaximumSize(new Dimension(90, 27));
      myOpnBrowse.setMinimumSize(new Dimension(90, 27));
      myOpnBrowse.setPreferredSize(new Dimension(90, 27));
      myOpnBrowse.setActionCommand("Browse...");
      myOpnBrowse.setText("Browse...");
      myOpnBrowse.addActionListener(this);

      myInFileTxt.setBorder(BorderFactory.createEtchedBorder());

      myInputPanel.setLayout(borderLayout2);
      myInputPanel.setBackground(Color.lightGray);
      myInputPanel.setBorder(myInTitleBorder);
      myInputPanel.setMaximumSize(new Dimension(2147483647, 55));
      myInputPanel.add(myInFileTxt, BorderLayout.CENTER);

      myInputPanel.add(myOpnBrowse, BorderLayout.EAST);

      getContentPane().add(myInputPanel,
                           new GridBagConstraints(0, 0, 1, 3, 0.7, 0.0
                                                  , GridBagConstraints.CENTER,
                                                  GridBagConstraints.HORIZONTAL,
                                                  new Insets(1, 1, 1, 1), 10,
                                                  -2));

      Insets mainInsets = new Insets(1, 1, 1, 1);

      // generate button
      myGenerateBtn.setMaximumSize(new Dimension(80, 10));
      myGenerateBtn.setMinimumSize(new Dimension(80, 10));
      myGenerateBtn.setPreferredSize(new Dimension(80, 10));
      myGenerateBtn.setActionCommand("Generate");
      myGenerateBtn.setMnemonic('0');
      myGenerateBtn.setText("Generate...");
      myGenerateBtn.addActionListener(this);
      getContentPane().add(myGenerateBtn,
                           new GridBagConstraints(1, 0, 1, 3, 0.3, 0.0
                                                  , GridBagConstraints.CENTER,
                                                  GridBagConstraints.BOTH,
                                                  new Insets(1, 1, 1, 1), 10,
                                                  10));

      // Add sections check boxes
      JLabel secLablel = new JLabel("Add Sections");

      myCheckPanel.setMinimumSize(new Dimension(140, 140));
      myCheckPanel.setPreferredSize(new Dimension(40, 40));
      myCheckPanel.setLayout(gridBagLayout1);

      myCheckPanel.add(secLablel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
         , GridBagConstraints.NORTH, GridBagConstraints.NONE,
         new Insets(0, 0, 0, 0), 50, 10));
      myCheckBoxes = new JCheckBox[CHECKBOX_STRS.length];
      for (int index = 0; index < CHECKBOX_STRS.length; ++index)
      {
         myCheckBoxes[index] = new JCheckBox(CHECKBOX_STRS[index][0]);
         myCheckBoxes[index].setToolTipText(CHECKBOX_STRS[index][1]);
         myCheckBoxes[index].addActionListener(this);
         myCheckPanel.add(myCheckBoxes[index],
                          new GridBagConstraints(1, index, 1, 1, 0.0, 0.0
                                                 , GridBagConstraints.WEST,
                                                 GridBagConstraints.NONE,
                                                 new Insets(0, 0, 0, 0), 50, 10));
      }
      getContentPane().add(myCheckPanel,
                           new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0
                                                  , GridBagConstraints.CENTER,
                                                  GridBagConstraints.HORIZONTAL,
                                                  mainInsets, 240,
                                                  50));

      // example text area stuff
      myExampleTextArea.setLineWrap(false);
      myExampleTextArea.setFont(MONO_FONT);
      myExampleTextArea.setPreferredSize(new Dimension(50, 370));
      myExampleTextArea.setEditable(false);

      myScrollArea = new JScrollPane(myExampleTextArea,
                                     JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                                     JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
      myScrollArea.setPreferredSize(new Dimension(40, 340));
      myScrollArea.setMinimumSize(new Dimension(22, 322));

      getContentPane().add(myScrollArea,
                           new GridBagConstraints(0, 4, 3, 6, 1.0, 1.0
                                                  , GridBagConstraints.CENTER,
                                                  GridBagConstraints.BOTH,
                                                  mainInsets, 10,
                                                  10));
   }


   /**
    * Method to display the dialog on the screen.
    */
   public void showDialog()
   {
      super.setTitle("CC2 Menu Generators");

      pack();
      setExampleText();
      setLocationRelativeTo(null);
      show();
   }


   /**
    * The main method to start this Application.
    * @param args the arguments from the command line.
    */
   public static void main(String[] args)
   {
      CC2Dialog aCC2Dialog = new CC2Dialog();
      aCC2Dialog.showDialog();
   }


   void myOpnBrowse_actionPerformed(ActionEvent e)
   {
      int returnVal = 0;
      File userDir = new File(myInFileTxt.getText());
      if(userDir.exists())
      {
         myFileChooser.setCurrentDirectory(userDir);
      }
      else
      {
         String ErrorStr = "Directory " + myInFileTxt.getText() + "does not exist.";
         JOptionPane.showMessageDialog(this, ErrorStr);
         return;
      }


      returnVal = myFileChooser.showOpenDialog(this);

      if (returnVal == JFileChooser.APPROVE_OPTION)
      {
         File file = myFileChooser.getSelectedFile();
         myInFileTxt.setText(file.getAbsolutePath());
         if (myOutDirTxt.getText().length() < 1)
         {
            myOutDirTxt.setText(file.getParent());
         }
      }
   }


   /**
    * Invoked when a check box is checked.
    * @param e the ActionEvent used to determine what button was pressed
    */
   public void actionPerformed(ActionEvent e)
   {
      Thread subProcess = null;
      //Handle open button action.
      Object actObj = e.getSource();

      if (actObj == myOpnBrowse)
      {
         myOpnBrowse_actionPerformed(e);
      }
      else if (actObj == myGenerateBtn)
      {
         File directory = new File(myInFileTxt.getText());
         if (directory.exists() && directory.isDirectory())
         {
            if (askBackedupRoms())
            {
               // save the current directory
               saveProperties();
               RunGenerate asdf = new RunGenerate(directory);
               subProcess = new Thread(asdf);
               subProcess.start();
            }
         }
         else
         {
            String ErrorStr = "Directory " + myInFileTxt.getText() + "does not exist.";
            JOptionPane.showMessageDialog(this, ErrorStr);
            return;
         }
      }
      else
      {
         setExampleText();
      }
   }


   /**
    * @return a String representing the current directory
    */
   private String getDefaultPath()
   {
      String returnStr = "";

      try
      {
         File curr = new File(".").getCanonicalFile();
         returnStr = curr.getAbsolutePath();
      }
      catch (IOException ex)
      {
      }
      return returnStr;
   }


   /**
    * Displays example text in the example text area
    * according to the user's choices.
    */
   private void setExampleText()
   {
      boolean oneSelected = false;
      myExampleTextArea.setText("");
      for (int index = 0; index < myCheckBoxes.length; ++index)
      {
         if (myCheckBoxes[index].isSelected())
         {
            myExampleTextArea.append(EXAMPLE_TEXTS[index]);
            oneSelected = true;
         }
      }
      myGenerateBtn.setEnabled(oneSelected);
      if (!oneSelected)
      {
         myExampleTextArea.append(EXAMPLE_NO_TEXT);
      }
   }



   /**
    * Ask the user the if the ROMS are backed up
    * @return true if user select Yes, false otherwise.
    */
   private boolean askBackedupRoms()
   {

      int n = JOptionPane.showConfirmDialog(this,
                                            CC2MenuGenerate.WARNING_STR,
                                            "Backedup your ROMs?",
                                            JOptionPane.YES_NO_OPTION);
      return n == JOptionPane.YES_OPTION;
   }



   class RunGenerate
      implements Runnable
   {
      private ProgressDlg myProgressDlg = null;
      private File myOutDir = null;
      public RunGenerate(File directory)
      {
         myOutDir = directory;
         // create a new progressDlg
         myProgressDlg = new ProgressDlg(CC2Dialog.this, "Processing", "finding roms...");
      }


      public void run()
      {
         int totalRoms = 0;
         setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
         myProgressDlg.showDialog();
         setEnabled(false);


         CC2MenuGenerate aCC2MenuGenerate = new CC2MenuGenerate();

         try
         {
            totalRoms =
               aCC2MenuGenerate.
                  generateMenu(myOutDir,
                               myCheckBoxes[BY_NAMES_INDEX].isSelected(),
                               myCheckBoxes[BY_COMP_INDEX].isSelected(),
                               myCheckBoxes[BY_CONTROL_INDEX].isSelected(),
                               myProgressDlg);

         }
         catch (Exception ex)
         {
         }
         myProgressDlg.dispose();
         setEnabled(true);
         setCursor(null); //turn off the wait cursor
         toFront();


         // display the amount of roms:
         JOptionPane.showMessageDialog(CC2Dialog.this,
                                       "Number of Roms found: " + totalRoms,
                                       "Results", JOptionPane.DEFAULT_OPTION);
         toFront();
      }
   }
}
