package ccmenu;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */

public class GetDb
{
  private static final String OUTPUT_ROMS_DIR = "GAMES";
  private static final String OUTPUT_TXT_MENU = "MENU.TXT";
  private static final String CC2_MENU = "MENU.CC2";

  public GetDb()
  {
  }
  public void getNewEntrys()
  {
    try
    {
       // read in old db:
       CC2Database newDB = new CC2Database();

       // add enties not already in the DB
       readMenuFile(newDB);

       // save this new DB to a file
       newDB.writeToFile(new File("outDB.txt"));
    }
    catch(Exception ex)
    {
       System.out.println("Error in processing:" + ex.getMessage() +
                          "\nExiting");
       System.err.print(ex);
       ex.printStackTrace(System.err);
    }
  }

  /**
   * Reads in the menu file
   * @throws Exception
   */
  private void readMenuFile(CC2Database cc2Db)
         throws Exception
  {
    BufferedReader inBuffer = null;
    File dbfile = new File(CC2_MENU);
    File romDir = new File("./"+OUTPUT_ROMS_DIR);
    try {
      inBuffer = new BufferedReader(new FileReader(dbfile));
    }
    catch (FileNotFoundException ex) {
      throw new Exception("File " + dbfile.getAbsolutePath() +
                          " not found.");
    }


    //read each line
    char[] entryBuf = new char[RomEntry.MENU_CHAR_LEN];
    RomEntry aRomEntry;
    File romFile;
    FileHelper fileHelper = FileHelper.getInstance();
    String newCRC;
    int oldNum = 0;
    int newNum = 0;
    String romFileName;
    try
    {
      while (inBuffer.read(entryBuf) != -1)
      {

        try {
          aRomEntry = new RomEntry(entryBuf);
        }
        catch (Exception ex1)
        {
          continue;
        }
        romFileName = aRomEntry.getRomFileName().trim();
        if(romFileName.length() > 1)
        {
          // now need to take this information and get
          // the CRC value from the file
          romFile = new File(romDir, aRomEntry.getRomFileName());
          if (romFile.exists())
          {
              newCRC = fileHelper.calcCRC(romFile);
            if (null != newCRC && newCRC.trim().length() > 0)
            {
              aRomEntry.setCRC(newCRC);

              if (!cc2Db.containsKey(aRomEntry.getCRC()))
              {
                if(aRomEntry.getName().indexOf('(') > -1)
                {
                   aRomEntry.setCompany("Hack");
                }
                cc2Db.addEntry(aRomEntry);
                System.out.println("new: " + aRomEntry.getTxtMenuEntry());

                ++newNum;
              }
              else
              {
                ++oldNum;
                //System.out.println("old: " + oldNum);
              }
            }
          }
        }
      }
    }
    catch (IOException ex)
    {
        System.err.println("Error: an IOException");
    }
    finally
    {
       try
       {
          inBuffer.close();
       }
       catch (IOException ex)
       {
          System.err.println("Error: an IOException");
       }
    }
    System.out.println("already in db:" + oldNum + " added:" + newNum);
  }


  public static void main(String[] args)
  {
    GetDb getDb1 = new GetDb();
    getDb1.getNewEntrys();
  }
}
