package ccmenu;


import java.awt.*;

import javax.swing.*;


/**
 * A dialog to show progress.
 */
public class ProgressDlg extends JDialog
{
   /** the progress bar */
   private JProgressBar myProgressBar = new JProgressBar();

   private int myTotalRoms = 0;
   private JLabel myRomsToGo = new JLabel("0");
   private JLabel myRomsInMenu = new JLabel("0");
   private JLabel myRomsUnknown = new JLabel("0");
   private JLabel myRomsDup = new JLabel("0");
   GridBagLayout myGridBagLayout = new GridBagLayout();
   JLabel jLabel1 = new JLabel();
   JLabel jLabel2 = new JLabel();
   JLabel jLabel3 = new JLabel();
   JLabel jLabel4 = new JLabel("Progress...");
   JLabel jLabel5 = new JLabel();


   /**
    * Creates a non-model dialog with specified title and with the specified
    * owner Gui and maxValue as the end of the progress bar.
    * @param owner the non-null Frame from which this dialog is displayed
    * @param title String title of this ProgressDlg
    * @param text String text to display in the ProgressDlg
    */
   public ProgressDlg(Frame owner, String title, String text)
   {
      super(owner, title);
      jLabel4.setText(text);
      /*
      //myTotalRoms = maxValue;
      Container theContainer = getContentPane();
      theContainer.setLayout(new BorderLayout());

      JPanel currPanel = new JPanel();
      currPanel.add(new JLabel(text));
      getContentPane().add(currPanel, BorderLayout.PAGE_START);

      currPanel = new JPanel();
      //myProgressBar = new JProgressBar(0, maxValue);
      myProgressBar = new JProgressBar();
      myProgressBar.setStringPainted(true);
      currPanel.add(myProgressBar);
      theContainer.add(currPanel, BorderLayout.CENTER);

      currPanel = new JPanel();
      currPanel.add(new JLabel("Total Roms to go:"));
      currPanel.add(myRomsToGo);
      currPanel.add(new JLabel("Total Roms Found:"));
      currPanel.add(myRomsInMenu);
      currPanel.add(new JLabel("Total Unknown Roms:"));
      currPanel.add(myRomsUnknown);
      theContainer.add(currPanel, BorderLayout.SOUTH);*/
      jbInit();
   }

   /**
    * Sets the end value of the progress bar
    * @param max int
    */
   public void setMaximum(int max)
   {
      myProgressBar.setMaximum(max);
      myRomsToGo.setText(Integer.toString(max));
      myTotalRoms = max;
   }


   /**
    * Sets the progress bar's current value to value.
    * @param value int the new value
    * @param inMenu number of roms in the menu
    * @param unknown number of roms not found
    * @param duplicate number of duplicate known roms
    */
   public void setValue(int value, int inMenu, int unknown, int duplicate)
   {
      myRomsInMenu.setText(Integer.toString(inMenu));
      myRomsUnknown.setText(Integer.toString(unknown));
      myRomsDup.setText(Integer.toString(duplicate));

      myProgressBar.setValue(value);
   }


   /**
    * Method to display the dialog on the screen.
    */
   public void showDialog()
   {
      pack();
      setLocationRelativeTo(getParent());
      show();
   }

   public ProgressDlg() {
     try {
       jbInit();
     }
     catch(Exception e) {
       e.printStackTrace();
     }
   }
   private void jbInit()
   {

     this.getContentPane().setLayout(myGridBagLayout);
    jLabel1.setText("Total Roms Files to process:");
    jLabel2.setText("Total Roms Found:");
    jLabel3.setPreferredSize(new Dimension(140, 16));
    jLabel3.setText("Total Unknown Roms:");
    jLabel5.setText("Total Dupicate:");
    myProgressBar.setStringPainted(true);
    this.getContentPane().add(jLabel4,    new GridBagConstraints(0, 0, 5, 1, 0.1, 0.0
            ,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(myProgressBar,         new GridBagConstraints(0, 1, 2, 1, 0.3, 0.3
            ,GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(myRomsToGo,             new GridBagConstraints(1, 3, 1, 1, 0.1, 0.1
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(myRomsInMenu,            new GridBagConstraints(1, 4, 1, 1, 0.1, 0.1
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(jLabel1,      new GridBagConstraints(0, 3, 1, 1, 0.1, 0.1
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(jLabel2,      new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(jLabel3,       new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0
            ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(myRomsUnknown,   new GridBagConstraints(1, 5, 1, 1, 0.1, 0.1
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(jLabel5,    new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0
           ,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));
    this.getContentPane().add(myRomsDup,   new GridBagConstraints(1, 6, 1, 1, 0.1, 0.1
            ,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(1, 1, 1, 1), 0, 0));



   }
}

