package ccmenu;

import java.io.*;

/**
 * A little FileFilter to accept files with BIN extensions.
 */
public class RomFileFilter implements FilenameFilter
{
   private static final String[] EXTENTIONS = {"BIN", "A26", "A78"};

   public boolean accept(File aFile)
   {
       return accept(aFile.getParentFile(), aFile.getName());
   }
   public boolean accept(File dir, String name)
   {
       String filename;
       String ext;
       int dotIndex;
       int index;
       if(null != name)
       {
           filename = name;
           dotIndex = filename.lastIndexOf('.');
           if(dotIndex>0 && dotIndex<filename.length()-1)
           {
               ext = filename.substring(dotIndex+1);
               for(index = 0;index < EXTENTIONS.length;++index)
               {
                   if(ext.equalsIgnoreCase(EXTENTIONS[index]))
                   {
                      return true;
                   }
               }
           }
       }
       return false;
   }

   public String getDescription()
   {
       return "Bin files (.BIN)(.A26)(.A78)";
   }
}
