package ccmenu;


import java.io.File;

import javax.swing.filechooser.FileFilter;


/**
 * A little FileFilter to accept files with TXT extensions.
 */
public class TxtFileFilter extends FileFilter
{
  /**
   * Test if aFile has a text file extension.
   * @param aFile a File to test
   * @return true if aFile has a text file extension.
   */
  public boolean accept(File aFile)
   {
      String filename;
      String ext;
      int dotIndex;
      if(null != aFile)
      {
         filename = aFile.getName();
         dotIndex = filename.lastIndexOf('.');
         if(dotIndex>0 && dotIndex<filename.length()-1)
         {
            ext = filename.substring(dotIndex+1);
            return ext.equalsIgnoreCase("txt");
         }
      }
      return false;
   }


   /**
    * @return A description String of this filter.
    */
   public String getDescription()
   {
      return "Text (.txt)";
   }
}
