#!/usr/local/bin/perl -w

# Date   : 2-25-2000
# Author : James Dean Palmer
# Modified by: Pallav Nawani, Thu Jun 13 11:43:07 JST 2002
# Description :
#
# This script walks a directory tree performing the "sgrep" function
# on all files. The sgrep function tries to find a pattern in the file.
# This makes this script a recursive grep. Of course, sgrep can be replaced
# by any other function you might like. Since it is a perl script, you can
# search by regexps, but be careful: your regexps pass through both
# the shell and perl.
# It dumps it output to Stdout. It takes one argument, which is the expression
# You are grepping for. By default it starts from the current directory,
# and descends into subdirectories. There is no way to specify a directory
# right now, but that's rather easy to add.
# jreplace.pl pattern > log

sub sgrep {
  my ($file) = $_[0];
  my ($prefix) = $_[1];
  my ($fullpath) = $_[2];
  my ($num) = 0;
  my (@data) = ();
  
  if(!open (THEFILE, "< $file"))  {
    print "rgrep: could not open $file:$!\n";
    return;
    }
  
  chomp(@data=<THEFILE>);
  close (THEFILE);
  foreach (@data) {
    $num++;
    if(/$prefix/o) { print "$fullpath$file:$num:$_\n"; }
    }
  }

sub walk {
  my ($thisdir) = $_[0];
  my ($depth) = $_[1];
  my ($fullpath) = $_[2];
  my ($prefix) = "";
  my (@files) = ();
  my ($file) = "";
  my (@dirs) = ();
  my ($dir) = "";

  for (my $i=0; $i<$depth; $i++) { $prefix .= "-";}
  

  if (chdir $thisdir) {
    print $prefix . "Changing to directory \"$thisdir\"\n";
    }
  else {
    print $prefix . "ERROR: Could not change to directory \"$thisdir\"\n";
    return;
    }
  
  $fullpath .="$thisdir/";
  opendir THISDIR, ".";
  # Ignore dir . and ..
  readdir THISDIR;
  readdir THISDIR;
  @files = readdir THISDIR;
  closedir THISDIR;

  foreach $file (@files) {
    if ((-e $file) && (-d $file) && (!-l $file)) { 
      &walk ($file, $depth+1, $fullpath);
      if (chdir "..") {
	print $prefix . "Returning to \"$thisdir\"\n";
        }
      }
    else {
# simple grep on this file
      &sgrep ($file, $ARGV[0], $fullpath);
      }
    }
  }  

# By default walk the current directory, I guess we could get fancy
# and take arguments..

&walk (".", 0, "");
