/****************************************************************************

  SETStd.H

  Autor: Salvador Eduardo Tropea (SET).

  Objetivo: Header de propsito general.

****************************************************************************/

#ifndef S__H_SETSTD__
#define S__H_SETSTD__

#define vLOCAL static
#define NADA   void

#ifdef __GNUC__
#define far
#define strncmpi strncmp
#endif

// Variable de 8 bits
typedef unsigned char  BYTE;
// Variable de 16 bits
#ifndef NO_DEF_WORD
typedef unsigned short WORD;
#endif
typedef short SWORD;
// Variable de 32 bits
typedef unsigned long  ULONG;

#ifdef __GNUC__
// Variable de 64 bits
typedef unsigned long long int ULLONG;
#endif

#ifdef __GNUC__
// Funciones locales
#define fLOCAL   static
// Funciones locales optimizadas
#define sfLOCAL  static
// ISRs
#define fISR     void
#else
// Funciones locales
#define fLOCAL   static near pascal
// Funciones locales optimizadas
#define sfLOCAL  static near _fastcall
// ISRs
//#define fISR	 static void interrupt far
#define fISR	 void interrupt far
#endif

// End of interrupt
#define EOI   outp(0x20,0x20)
#define EOI_2 outp(0xA0,0x20)

#ifdef NDEBUG
# define AsertaEsp(a)      printf(a);getch()
# define AsertaEsp2(a,b)   printf(a,b);getch()
# define AsertaEsp3(a,b)   printf(a,b,c);getch()
# define Aserta(a)         printf(a)
# define Aserta2(a,b)      printf(a,b)
# define Aserta3(a,b,c)    printf(a,b,c)
#else
# define AsertaEsp(a);
# define Aserta(a);
# define AsertaEsp2(a,b);
# define Aserta2(a,b);
# define AsertaEsp3(a,b,c);
# define Aserta3(a,b,c);
#endif

#ifdef __GNUC__
#define Alinear    __attribute__ ((packed))
#define AlinearOn  #pragma pack(1)
#define AlinearOff #pragma pack()
#else
#define Alinear
#define AlinearOn
#define AlinearOff
#endif
#endif // S__H_SETSTD__