/****************************************************************************

  .TXI to .INFO Helper, copyright (c) 1997 by Salvador E. Tropea (SET)

  You can freely use this code.

  E-Mail: salvador@inti.edu.ar

  Telephone: (+541) 759-0013

  Postal Address:
  Salvador E. Tropea
  Curapalige 2124
  (1678) Caseros - 3 de Febrero
  Prov: Buenos Aires
  Argentina

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <sys/stat.h>
#include <string.h>
#define MAXPATH PATH_MAX

static char *temp_base,*file;
static char shell[MAXPATH],Buf[MAXPATH];
static char temp[MAXPATH],compre[MAXPATH],Buffer[1024];
static char *dest;
static FILE *h,*f;

static void PrintHelp(void)
{
 printf("
  This program generates a .info file calling to makeinfo, do not use alone
because is dangerous!

  Parameters:
  -t temporal_txi
     Name of the .info source, will be deleted!!!. The name must be without
  extention, the file must have .dat extention.

  -f output_name
     Name of the .info generated by makeinfo without extention

  -d destination
     The path where the files will be put, for example /dj/info
     Don't put an extra / at the end!!!.

SET
");
 exit(1);
}

static int FileExist(char *s)
{
 struct stat a;
 if (stat(s,&a)!=0)
    return 0;
 return S_ISREG(a.st_mode);
}

static void CallSystem(char *shell, char *error)
{
 printf("Shell: %s\n",shell);
 if (system(shell))
   {
    fprintf(stderr,"Failed calling %s\n\n",error);
    exit(1);
   }
}


static FILE *AbrirArchivo(char *nom,char *modo)
{
 FILE *f;
 if ((f=fopen(nom,modo))==NULL)
   {
    printf("Can't open the file %s\n",nom);
    exit(1);
   }
 return f;
}


static void ProcessPart(char *s, int num)
{
 char ori[MAXPATH];
 char newf[MAXPATH];
 char newf2[MAXPATH];
 char Buf[MAXPATH];
 char *p,*sen;
 int i;

 for (sen=s,p=ori; *sen!=':'; sen++,p++) *p=*sen;
 *p=0;
 printf("Original file %s\n",ori);
 for (p=ori,i=0; i<5 && *p!='.'; i++,p++) Buf[i]=*p;
 Buf[i]=0;
 sprintf(newf,"%s%03d.inz",Buf,num);
 strcpy(newf2,Buf);
 printf("New file %s\n",newf);

 printf("Renaming the file to ng2info\n");
 rename(ori,temp_base);

 printf("Converting the files to UNIX format (%s)\n",temp_base);
 sprintf(shell,"dtou %s",temp_base);
 CallSystem(shell,"dtou");

 printf("Compressing the file %s\n",temp_base);
 sprintf(shell,"gzip -f %s",temp_base);
 CallSystem(shell,"gzip");

 if (dest)
    sprintf(Buf,"%s/%s",dest,newf);
 else
    strcpy(Buf,newf);
 printf("Renaming the file %s to %s\n",compre,Buf);
 rename(compre,Buf);

 printf("Deleting the original\n");
 unlink(ori);

 sprintf(Buf,"%s%03d.inf",newf2,num);
 strcat(Buf,sen);
 strcpy(s,Buf);
}


int main(int argc, char *argv[])
{
 int i;

 printf(".txi to .info helper, by SET\n"
        "Copyright 1997, by Salvador E. Tropea <salvador@inti.edu.ar>\n\n");

 if (argc==1)
   {
    printf("Use: %s -t temporal_txi -f output_name [-d destination] [-h]\n\n",argv[0]);
    return 1;
   }

 temp_base=file=dest=NULL;
 for (i=1; i<argc; i++)
    {
     if (argv[i][0]=='-')
       {
        switch (argv[i][1])
          {
           case 't':
                if (argc>i+1)
                  {
                   i++;
                   temp_base=argv[i];
                  }
                break;

           case 'f':
                if (argc>i+1)
                  {
                   i++;
                   file=argv[i];
                  }
                break;

           case 'd':
                if (argc>i+1)
                  {
                   i++;
                   dest=argv[i];
                  }
                break;

           case 'h':
                PrintHelp();
                break;

           default:
                printf("Unknown command line option: %c\n",argv[i][1]);
                return 1;
          }
       }
     else
       printf("Unknown command line parameter: %s\n",argv[i]);
    }

 if (!temp_base || !file)
   {
    printf("Missing parameters\n");
    return 1;
   }

 strcpy(temp,temp_base);
 strcat(temp,".dat");
 strcpy(compre,temp_base);
 strcat(compre,".gz");

 printf("Generating the .info file\n");
 sprintf(shell,"makeinfo --no-validate --fill-column 78 %s",temp);
 CallSystem(shell,"makeinfo");

 printf("Deleting the temporal file\n");
 unlink(temp);

 printf("Analyzing the generated file/s\n");
 strcpy(Buf,file);
 strcat(Buf,".i1");
 if (!FileExist(Buf))
   {
    printf("The generate .info is one file or long files are supported\n");

    printf("Converting the files to UNIX format\n");
    sprintf(shell,"dtou %s.i*",file);
    CallSystem(shell,"dtou");
   
    printf("Compressing the file/s\n");
    sprintf(Buf,"gzip %s.i*",file);
    CallSystem(shell,"gzip");
   }
 else
   {
    unlink(temp);
    unlink(compre);
    printf("Makeinfo splitted the file\n");
    strcpy(Buf,file);
    strcat(Buf,".inf");
    h=AbrirArchivo(Buf,"rb");
    f=AbrirArchivo(temp,"wb");
    do
      {
       fgets(Buffer,1000,h);
       fputs(Buffer,f);
      }
    while (strnicmp("Indirect:",Buffer,9)!=0 && !feof(h));
    i=1;
    while (!feof(h))
      {
       fgets(Buffer,1000,h);
       if (Buffer[0]==31)
         {
          fputs(Buffer,f);
          break;
         }
       ProcessPart(Buffer,i);
       i++;
       fputs(Buffer,f);
      }
    while (!feof(h))
      {
       fgets(Buffer,1000,h);
       fputs(Buffer,f);
      }
    fclose(f);
    fclose(h);

    printf("Deleting original root file\n");
    unlink(Buf);
    printf("Renaming the temporal\n");
    rename(temp,temp_base);
    printf("Compressing the new root file\n");
    sprintf(shell,"gzip -f %s",temp_base);
    CallSystem(shell,"gzip");

    if (dest)
       sprintf(Buffer,"%s/%s.inz",dest,file);
    else
      {
       strcpy(Buffer,file);
       strcat(Buffer,".inz");
      }
    printf("Renaming the root (%s -> %s)\n",compre,Buffer);
    rename(compre,Buffer);

    unlink(temp_base);
    unlink(compre);
   }

 return 0;
}
