/****************************************************************************

  .NG to .INFO Converter, copyright (c) 1997 by Salvador E. Tropea (SET)

  If you want to use this code contact me first.

  E-Mail: salvador@inti.edu.ar

  Telephone: (+541) 759-0013

  Postal Address:
  Salvador E. Tropea
  Curapalige 2124
  (1678) Caseros - 3 de Febrero
  Prov: Buenos Aires
  Argentina

****************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/stat.h>
#ifndef __GNUC__
#include <dir.h>
#else
#include <limits.h>
#define MAXPATH PATH_MAX
#include <unistd.h>
#endif
#include "setstd.h"

#ifdef __GNUC__
#define PACKED __attribute__((packed))
#else
#define inline
#define PACKED
#endif

#define ENGLISH

#ifdef ESPANOL
#define S_EAbre1 "Error al abrir %s\n"
#define S_NoEsNG "No es una Norton Guide\n"
#define S_NoRAM  "No hay RAM suficiente\n"
#else
#define S_EAbre1 "Can't create: %s\n"
#define S_NoEsNG "Wrong format\n"
#define S_NoRAM  "Not enough memory\n"
#endif

#define NG_ID 18254
#define NIL -1

//#define DEBUGAGRESIVO

void LeeHEntrada(void);
void ResolverXRef(long pos);
void ResolverNombre(WORD ind,long pos);

int Verbose=0;
FILE *h,*out;
int NoPostProcess=0;

const MaxDeep=3;
char *Sections[] =
{
 "chapter",
 "section",
 "subsection",
 "subsubsection"
};
int Deep;

void ErrorMem(void)
{
 printf(S_NoRAM);
 exit(1);
}


void ForzarEspacios(char *s)
{
 for (; *s; s++)
     if (*s==' ')
        fprintf(out,"@ ");
     else
        fputc(*s,out);
}

int Nodes=0,MaxNodes=0;
char **NodeList=NULL;

int AddNodeToList(char *s)
{
 if (Nodes==MaxNodes)
   {
    MaxNodes+=40;
    NodeList=(char **)realloc(NodeList,MaxNodes*sizeof(char *));
    if (!NodeList)
       ErrorMem();
   }
 NodeList[Nodes]=strdup(s);
 if (!NodeList[Nodes])
    ErrorMem();
 Nodes++;
}

int ValiNode(char *s)
{
 int i;

 for (i=0; i<Nodes; i++)
    {
     if (strcmp(s,NodeList[i])==0)
        return 1;
    }
 return 0;
}

void CutExtraSpaces(char *s)
{
 char *d=s,*last=s;

 for (;*s && isspace(*s); s++);
 for (;*s ; s++,d++)
    {
     *d=*s;
     if (!isspace(*s))
        last=d;
    }
 last[1]=0;
}

int ValidateNode(char *r)
{
 char *s=strdup(r);
 if (!s)
    ErrorMem();
 CutExtraSpaces(s);
 if (ValiNode(s))
    return 1;
 AddNodeToList(s);
 return 0;
}


#pragma pack(1)
typedef struct
{
 WORD ID             PACKED;
 WORD Version        PACKED;
 WORD Dummy1         PACKED;
 WORD NumeroMenues   PACKED;
 char Nombre[40]     PACKED;
 char CopyR[5][66]   PACKED;
} hNG;
#pragma pack()



FILE *AbrirArchivo(char *nom,char *modo)
{
 FILE *f;
 if ((f=fopen(nom,modo))==NULL)
   {
    printf(S_EAbre1,nom);
    exit(1);
   }
 return f;
}


size_t Xor26(BYTE *Buf,size_t t,FILE *f)
{
 size_t ret,i;

 ret=fread(Buf,t,1,f);
 for (i=0;i<t;i++) Buf[i]^=26;
 return ret;
}

long Xor26Long(void)
{
 long val;
 fread((void *)&val,4,1,h);
 return val ^ 0x1A1A1A1AL;
}

WORD Xor26Word(void)
{
 WORD val;
 fread((void *)&val,2,1,h);
 return val ^ 0x1A1A;
}

/*************** Tipo 2 ****************************************************/
#pragma pack(1)
typedef struct
{
 WORD Opciones  PACKED;
 char Dummy[20] PACKED;
} TipoMenu;

typedef struct
{
 WORD Fin       PACKED;
 char Dummy[6]  PACKED;
} FinOps;
#pragma pack()

char Buffer[2000];

WORD Fines[40];
long PunMen[40];

void LeerMenu(void)
{
 TipoMenu h1;
 FinOps h2;
 long Puntero,Pos,Pos2;
 int i;

 Xor26((BYTE *)&h1,sizeof(TipoMenu),h);
 if (Verbose)
    fprintf(stderr,"Cantidad de opciones: %u\n",h1.Opciones-1);
 Pos=ftell(h);
 for (i=0; i<h1.Opciones-1; i++)
    {
     PunMen[i]=Puntero=Xor26Long();
     if (Verbose)
        fprintf(stderr,"P%d: %ld\n",i,Puntero);
    }
 for (i=0; i<h1.Opciones; i++)
    {
     Xor26((BYTE *)&h2,sizeof(FinOps),h);
     Fines[i]=h2.Fin;
     if (Verbose)
        fprintf(stderr,"Fin Ops: %u\n",h2.Fin);
    }
 for (i=0; i<h1.Opciones; i++)
    {
     Xor26((BYTE *)Buffer,Fines[i]-(ftell(h)-Pos),h);
     if (i)
       {
        Pos2=ftell(h);
        fprintf(out,"@node %s\n@%s %s\n\n",Buffer,Sections[0],Buffer);
        Deep=0;
        fseek(h,PunMen[i-1],SEEK_SET);
        LeeHEntrada();
        fseek(h,Pos2,SEEK_SET);
       }
    }
 // Saltear el nulo
 fseek(h,1,SEEK_CUR);
}

void SalteaMenu(void)
{
 TipoMenu h1;
 FinOps h2;
 long Pos;
 int i;

 Xor26((BYTE *)&h1,sizeof(TipoMenu),h);
 Pos=ftell(h);
 for (i=0; i<h1.Opciones-1; i++)
    {
     PunMen[i]=Xor26Long();
    }
 for (i=0; i<h1.Opciones; i++)
    {
     Xor26((BYTE *)&h2,sizeof(FinOps),h);
     Fines[i]=h2.Fin;
    }
 for (i=0; i<h1.Opciones; i++)
    {
     Xor26((BYTE *)Buffer,Fines[i]-(ftell(h)-Pos),h);
     if (i==0)
        fprintf(out,"%s\n\n",Buffer);
     else
       {
        ValidateNode(Buffer);
        fprintf(out,"* %s::.\n",Buffer);
       }
    }
 fprintf(out,"\n");
 // Saltear el nulo
 fseek(h,1,SEEK_CUR);
}

/*************** Tipo 0 ****************************************************/

#pragma pack(1)
typedef struct
{
 WORD Puntos    PACKED;
 WORD Dummy1    PACKED;
 WORD IndPadre  PACKED;
 long PosPadre  PACKED;
 WORD IndMenuH  PACKED;
 WORD IndMenuV  PACKED;
 char Dummy2[8] PACKED;
} hTipo0;

typedef struct
{
 WORD PosNom PACKED;
 long Punt   PACKED;
} hNomPun0;
#pragma pack()

char bufH0[100];

void LeeHasta0(void)
{
 int val,i=0;
 val=fgetc(h) ^ 26;
 while (val)
  {
   #ifdef DEBUGAGRESIVO
   fprintf(out,"-%2X-",val);
   #endif
   switch (val)
     {
      case '{':
      case '}':
      case ':':
      case ',':
      case '.':
           val='_';
           break;
      case '@':
           bufH0[i++]='@';
           break;
      case '^':
           val=fgetc(h) ^ 26;
           switch (val)
             {
              case 'A':
              case 'a':
                   fgetc(h);
                   fgetc(h);
                   val=fgetc(h) ^ 26;
                   break;
              case 'b':
              case 'B':
              case 'U':
              case 'u':
                   val=fgetc(h) ^ 26;
                   break;
             }
           break;
     }
   if (!val)
      break;
   if (val==255)
     {
      val=fgetc(h) ^ 26;
      while(val--) bufH0[i++]=' ';
     }
   else
      bufH0[i++]=val;
   val=fgetc(h) ^ 26;
   if (i>100)
     {
      fprintf(stderr,"Reference too large\n");
      exit(1);
     }
  }
 bufH0[i]=0;
}

void LeeHasta0Texto(void)
{
 int val,i=0;
 val=fgetc(h) ^ 26;
 while (val)
  {
   #ifdef DEBUGAGRESIVO
   fprintf(out,"-%2X-",val);
   #endif
   switch (val)
     {
      case '{':
      case '}':
      case '@':
           bufH0[i++]='@';
           break;
      case '^':
           val=fgetc(h) ^ 26;
           switch (val)
             {
              case 'A':
              case 'a':
                   fgetc(h);
                   fgetc(h);
                   val=fgetc(h) ^ 26;
                   break;
              case 'b':
              case 'B':
              case 'U':
              case 'u':
                   val=fgetc(h) ^ 26;
                   break;
             }
           break;
     }
   if (!val)
      break;
   if (val==255)
     {
      val=fgetc(h) ^ 26;
      while(val--) bufH0[i++]=' ';
     }
   else
      bufH0[i++]=val;
   val=fgetc(h) ^ 26;
   if (i>100)
     {
      fprintf(stderr,"Reference too large\n");
      exit(1);
     }
  }
 bufH0[i]=0;
}

void LeerVarios(void)
{
 int i;
 hTipo0 h1;
 hNomPun0 *h2;
 long Pos,Pos2;
 int *Validos;

 Xor26((BYTE *)&h1,sizeof(hTipo0),h);
 Pos=ftell(h);
 if (Verbose)
   {
    fprintf(stderr,"Contiene: %u\n",h1.Puntos);
    fprintf(stderr,"Padre: Ind: %d Pos: %ld\n",h1.IndPadre,h1.PosPadre);
    fprintf(stderr,"Pertenece a: H: %u    V: %u\n",h1.IndMenuH,h1.IndMenuV);
   }

 h2=(hNomPun0 *)malloc(sizeof(hNomPun0)*h1.Puntos);
 if (h2==NULL) ErrorMem();
 Xor26((BYTE *)h2,sizeof(hNomPun0)*h1.Puntos,h);

 Deep++;
 if (Deep>MaxDeep)
   {
    fprintf(stderr,"Too much deep\n");
    exit(1);
   }

 fprintf(out,"@menu\n");
 Validos=(int *)malloc(h1.Puntos*sizeof(int));
 if (!Validos)
    ErrorMem();
 for (i=0;i<h1.Puntos;i++)
    {
     fseek(h,Pos+h2[i].PosNom,SEEK_SET);
     LeeHasta0();
     Validos[i]=ValidateNode(bufH0);
     if (Validos[i])
        fprintf(out,"* %s: Node_%d.\n",bufH0,h2[i].Punt);
     else
        fprintf(out,"* %s::.\n",bufH0);
    }
 if (Verbose)
    fprintf(stderr,"\n");
 fprintf(out,"@end menu\n");

 for (i=0;i<h1.Puntos;i++)
    {
     fseek(h,Pos+h2[i].PosNom,SEEK_SET);
     LeeHasta0();
     if (Validos[i])
        fprintf(out,"@node Node_%d\n",h2[i].Punt);
     else
        fprintf(out,"@node %s\n",bufH0);
     fprintf(out,"@%s %s\n\n",Sections[Deep],bufH0);
     if (h2[i].Punt!=NIL)
       {
        fseek(h,h2[i].Punt,SEEK_SET);
        LeeHEntrada();
       }
     else
       fprintf(out,"\nEntrada NULA\n");
    }
 Deep--;
 free(Validos);
 free(h2);
}

void NameOfVarios(WORD ind)
{
 int i;
 hTipo0 h1;
 hNomPun0 *h2;
 long Pos,Pos2;

 Xor26((BYTE *)&h1,sizeof(hTipo0),h);
 Pos=ftell(h);
 if (Verbose)
    fprintf(stderr,"Contiene: %u\n",h1.Puntos);
 if (ind>=h1.Puntos)
   {
    fprintf(stderr,"Error, index too large\n");
    exit(1);
   }

 h2=(hNomPun0 *)malloc(sizeof(hNomPun0)*h1.Puntos);
 if (h2==NULL) ErrorMem();
 Xor26((BYTE *)h2,sizeof(hNomPun0)*h1.Puntos,h);

 for (i=0;i<h1.Puntos;i++)
    {
     fseek(h,Pos+h2[i].PosNom,SEEK_SET);
     LeeHasta0();
     if (i==ind)
       {
        if (Verbose)
           fprintf(stderr,"Solved: %s\n",bufH0);
        break;
       }
    }

 free(h2);
}

/*************** Tipo 1 ****************************************************/

#pragma pack(1)
typedef struct
{
 WORD Lineas     PACKED;
 WORD OffSeeAlso PACKED;
 WORD IndPadre   PACKED;
 long PosPadre   PACKED;
 WORD IndMenuH   PACKED;
 WORD IndMenuV   PACKED;
 long Prev       PACKED;
 long Next       PACKED;
} hTipo1;
#pragma pack()


void LeerTexto(void)
{
 hTipo1 h1;
 long Pos;
 WORD i,Cant;
 long *Offs;

 Xor26((BYTE *)&h1,sizeof(hTipo1),h);
 Pos=ftell(h);

 if (Verbose)
   {
    fprintf(stderr,"Lineas: %u\n",h1.Lineas);
    fprintf(stderr,"OffSeeAlso: %u\n",h1.OffSeeAlso);
    fprintf(stderr,"Padre: Ind: %d Pos: %ld\n",h1.IndPadre,h1.PosPadre);
    fprintf(stderr,"Pertenece a: H: %u    V: %u\n",h1.IndMenuH,h1.IndMenuV);
    fprintf(stderr,"Previo: %ld Prximo: %ld\n",h1.Prev,h1.Next);
   }
 fprintf(out,"@format\n");
 for (i=0; i<h1.Lineas; i++)
    {
     LeeHasta0Texto();
     fprintf(out,"%s\n",bufH0);
    }

 if (h1.OffSeeAlso)
   {
    fprintf(out,"\n\nSee Also:\n");
    fseek(h,Pos+h1.OffSeeAlso,SEEK_SET);
    Cant=Xor26Word();
    if (Verbose)
       fprintf(stderr,"Cantidad de SeeAlso: %u\n",Cant);
    Offs=(long *)malloc(Cant*4);
    if (Offs==NULL) ErrorMem();
    Xor26((BYTE *)Offs,Cant*4,h);
    for (i=0;i<Cant;i++)
       {
        ResolverXRef(Offs[i]);
        fprintf(out,"@xref{ ");
        ForzarEspacios(bufH0);
        LeeHasta0();
        fprintf(out,",%s }.\n",bufH0);
       }
    free(Offs);
   }
 fprintf(out,"@end format\n");
}

void NameOfFatherOfTexto(void)
{
 hTipo1 h1;
 //long Pos;
 WORD i,Cant;
 long *Offs;

 Xor26((BYTE *)&h1,sizeof(hTipo1),h);
 //Pos=ftell(h);

 if (Verbose)
   {
    fprintf(stderr,"Padre: Ind: %d Pos: %ld\n",h1.IndPadre,h1.PosPadre);
    fprintf(stderr,"Pertenece a: H: %u    V: %u\n",h1.IndMenuH,h1.IndMenuV);
   }
 ResolverNombre(h1.IndPadre,h1.PosPadre);
}

/*************** Cualquier Tipo ********************************************/
#pragma pack(1)
typedef struct
{
 WORD Tipo   PACKED;
 WORD Largo  PACKED;
} HeaderEntry;
#pragma pack()

char *Tipos[]=
{
 "Archivo o varios ttulos",
 "Ttulo con texto",
 "Men"
};

void LeeHEntrada(void)
{
 HeaderEntry h1;

 Xor26((BYTE *)&h1,sizeof(HeaderEntry),h);
 if (Verbose)
    fprintf(stderr,"Tipo de entrada: %s\n"
        "Largo de la entrada: %u\n",Tipos[h1.Tipo],h1.Largo);

 switch (h1.Tipo)
   {
    case 0: LeerVarios();
            break;
    case 1: LeerTexto();
            break;
    case 2: LeerMenu();
            break;
   }
}

void SearchMenus(int cant)
{
 HeaderEntry h1;
 long pos=ftell(h);

 fprintf(out,"@node Top\n");
 fprintf(out,"\n@menu\n\n");
 do
  {
   Xor26((BYTE *)&h1,sizeof(HeaderEntry),h);
   if (h1.Tipo==2)
      cant--;
   else
     {
      fprintf(stderr,"Error, can't find a menu.");
      exit(1);
     }
   SalteaMenu();
  }
 while (cant);
 fprintf(out,"\n@end menu\n\n");

 fseek(h,pos,SEEK_SET);
}

void ResolverXRef(long pos)
{
 HeaderEntry h1;
 long Pos=ftell(h);

 if (Verbose)
    fprintf(stderr,"Solving cross reference at %d\n",pos);
 fseek(h,pos,SEEK_SET);

 Xor26((BYTE *)&h1,sizeof(HeaderEntry),h);
 if (Verbose)
    fprintf(stderr,"Tipo de entrada: %s\n"
        "Largo de la entrada: %u\n",Tipos[h1.Tipo],h1.Largo);

 switch (h1.Tipo)
   {
    case 1: NameOfFatherOfTexto();
            break;
    case 0: fprintf(stderr,"Error, XRef to a submenu!");
            exit(1);
    case 2: fprintf(stderr,"Error, XRef to a menu!");
            exit(1);
   }

 fseek(h,Pos,SEEK_SET);
}

void ResolverNombre(WORD ind,long pos)
{
 HeaderEntry h1;
 long Pos=ftell(h);

 if (Verbose)
    fprintf(stderr,"Solving name of %d[%d]\n",pos,ind);
 fseek(h,pos,SEEK_SET);

 Xor26((BYTE *)&h1,sizeof(HeaderEntry),h);
 if (Verbose)
    fprintf(stderr,"Tipo de entrada: %s\n"
        "Largo de la entrada: %u\n",Tipos[h1.Tipo],h1.Largo);

 switch (h1.Tipo)
   {
    case 0: NameOfVarios(ind);
            break;
    case 1: fprintf(stderr,"Error, Name of a text!");
            exit(1);
    case 2: fprintf(stderr,"Error, Name of a menu!");
            exit(1);
   }

 fseek(h,Pos,SEEK_SET);
}


void CambiaExtension(char *Nombre)
{
 char nom[MAXPATH],*s;

 strcpy(nom,Nombre);
 s=strstr(nom,".ng");
 if (s!=NULL)
    *s=0;
 strcat(nom,".info");
 fprintf(out,"%s\n",nom);
 printf("Name of the generated file: %s\n",nom);
}

void SacarElNombre(char *d, char *s)
{
 char *pos;

 pos=strstr(s,".ng");
 if (pos!=NULL)
    *pos=0;
 strcpy(d,s);
}


static void CallSystem(char *shell, char *error)
{
 printf("Shell: %s\n",shell);
 if (system(shell))
   {
    fprintf(stderr,"%s\n\n",error);
    exit(1);
   }
}

void LeeNG(char *Nombre, char * temporal, char *dest)
{
 hNG Head;
 int i;
 char FileName[MAXPATH];
 char Buf[MAXPATH];
 char temp[MAXPATH];

 strcpy(temp,temporal);
 strcat(temp,".dat");

 printf("Opening %s as temporal\n",temp);
 out=AbrirArchivo(temp,"wb");
 printf("Opening %s as source\n",Nombre);
 h=AbrirArchivo(Nombre,"rb");
 fread(&Head,sizeof(hNG),1,h);
 if (Head.ID!=NG_ID)
   {
    fprintf(stderr,S_NoEsNG);
    return;
   }
 if (Verbose)
   {
    fprintf(stderr,"Versin: %d.%d\n",Head.Version>>8,Head.Version & 0xFF);
    fprintf(stderr,"Cantidad de menes: %d\n",Head.NumeroMenues);
    fprintf(stderr,"Nombre: %s\n",Head.Nombre);
    fprintf(stderr,"Copyright:\n%s\n%s\n%s\n%s\n%s\n\n",Head.CopyR[0],Head.CopyR[1],Head.CopyR[2],Head.CopyR[3],Head.CopyR[4]);
   }

 // Name of the output file
 fprintf(out,"@setfilename ");
 // Change the name to .info
 CambiaExtension(Nombre);

 SacarElNombre(FileName,Nombre);
 fprintf(out,"@direntry\n* %s: (%s). %s\n@end direntry\n\n",FileName,FileName,Head.Nombre);

 printf("Converting ....\n");
 SearchMenus(Head.NumeroMenues);
 for (i=0; i<Head.NumeroMenues; i++)
     LeeHEntrada();

 fclose(h);
 fclose(out);

 printf("Convertion successful!\n");

 if (NoPostProcess)
    printf("Skiping post process\n");
 else
   {
    sprintf(Buf,"txi2info -t %s -f %s -d %s",temporal,FileName,dest);
    CallSystem(Buf,"Failed to generate the .info");
   }
}

static void PrintHelp(void)
{
 printf("
  This program converts norton guides into .info files.

  Parameters:
  -i norton_guide
     Name for the norton guide file.

  -t temporal_file
     Name of the temporal file, must be without extention.

  -n
     No post-process, if this option is present the program doesn't call to
  txi2info, the .info source is stored in temporal_file.dat

  -d destination
     The path where the files will be put, for example /dj/info
     Don't put an extra / at the end!!!.

  The post process consist in convert the files into UNIX format and then
compress it, that's works fine without long filenames, with lfn you can
have problems if the number of files is very huge.

SET
");
 exit(1);
}

int main(int argc, char *argv[])
{
 int i;
 char *input=NULL,*temporal=NULL;
 char dest[MAXPATH];

 printf(".ng to .info converter, by SET\n"
        "Copyright 1997, by Salvador E. Tropea <salvador@inti.edu.ar>\n\n");

 if (argc==1)
   {
    printf("Use: %s -i norton_guide -t temporal_file [-n] [-d destination] [-h]\n\n",argv[0]);
    return 1;
   }

 dest[0]=0;
 for (i=1; i<argc; i++)
    {
     if (argv[i][0]=='-')
       {
        switch (argv[i][1])
          {
           case 'i':
                if (argc>i+1)
                  {
                   i++;
                   input=argv[i];
                  }
                break;

           case 't':
                if (argc>i+1)
                  {
                   i++;
                   temporal=argv[i];
                  }
                break;

           case 'd':
                if (argc>i+1)
                  {
                   i++;
                   strcpy(dest,argv[i]);
                  }
                break;

           case 'n':
                NoPostProcess=1;
                break;

           case 'h':
                PrintHelp();
                break;

           default:
                printf("Unknown command line option: %c\n",argv[i][1]);
                return 1;
          }
       }
     else
       printf("Unknown command line parameter: %s\n",argv[i]);
    }

 if (!input)
   {
    printf("Missing input file name.\n");
    return 1;
   }

 if (!temporal)
   {
    printf("Missing temporal file name.\n");
    return 1;
   }

 if (strchr(temporal,'.')!=NULL)
   {
    printf("The temporal name must be without extention\n");
    return 1;
   }

 LeeNG(input,temporal,dest);
 return 0;
}