" This is the vim syntax file for Psions OPL language
" this is the programming langauage found on The organisers and pocket computers sold
" by Psion Computers PLC (http://www.psion.com) - the greatest palmtop computer in the world !
"
" Written by : Phil Whiles - philwhiles@poboxes.com
" Version 1.0
" Date 30/03/98
"
syn clear

syn match   oplStringVar	"[a-zA-Z_][a-zA-Z0-9_]*\$"
syn match   oplComment		"rem.*$"
syn match   oplIntVar		"[a-zA-Z_][a-zA-Z0-9_]*\%"
syn match   oplLongVar		"[a-zA-Z_][a-zA-Z0-9_]*\&"
syn region  oplString	start=+"+  end=+"+  contains=oplVariables
syn match   oplNumber	"\<[0-9]*\>"
syn match   oplNumber	"\$\<[0-9]*\>"
syn match   oplNumber	"\<[0-9]*\>\&"
syn match   oplNumber	"\&\<[0-9a-fA-F]*\>"
syn match   oplHandle "\<[A-Z]\>"

syn case ignore
  syn keyword oplCommand ABS ACOS ADDR ADJUSTALLOC ALERT ALLOC APP APPEND ASC AND 
  syn keyword oplCommand ASIN AT ATAN BACK BEEP BREAK BUSY BYREF CLOSE CONST CAPTION
  syn keyword oplCommand CLS CMD$ CONTINUE COPY COS COUNT CREATE CURSOR DATETOSECS 
  syn keyword oplCommand DAY DAYS dBUTTONS dCHOICE dDATE dEDIT dEDITMULTI DEFAULTWIN DEG
  syn keyword oplCommand DELETE dFILE dFLOAT DIALOG dINIT dLONG DO DOW dPOSITION
  syn keyword oplCommand dTEXT dTIME dXINPUT EDIT TRAP ELSE ELSEIF ENDIF ENDA ENDV ENDP
  syn keyword oplCommand ENDWH EOF ERASE ERR ESCAPE EVAL EXIST EXP FIND FLAGS
  syn keyword oplCommand FINDFIELD FIRST FLT FONT FREEALLOC gAT gBORDER gBOX gBUTTON
  syn keyword oplCommand gCLOCK gCLOSE gCLS gCOPY gCREATE gCREATEBIT GET 
  syn keyword oplCommand GETEVENT gFILL gFONT gGMODE gGREY gHEIGHT gIDENTITY gINVERT GIPRINT gLINEBY
  syn keyword oplCommand gLINETO gLOADBIT gLOADFONT GLOBAL gMOVE gORDER gORIGINX gORIGINY GOTO gPATT
  syn keyword oplCommand gPEEKLINE gPOLY gPRINT gPRINTB gPRINTCLIP gRANK gSAVEBIT gSCROLL gSETWIN gSTYLE
  syn keyword oplCommand gTMODE gTWIDTH gUNLOADFONT gUPDATE gUSE gVISIBLE gWIDTH gX gXBORDER gXPRINT
  syn keyword oplCommand gY HOUR IABS ICON IF INPUT TRAP INT IOSEEK IOOPEN IOCLOSE IOREAD INCLUDE IOWRITE
  syn keyword oplCommand INTF KEYA KEYC KMOD LAST LCLOSE LEN
  syn keyword oplCommand LENALLOC LN LOADM LOC LOCAL LOCK LOG LOPEN LPRINT
  syn keyword oplCommand MAX mCARD MEAN MENU MIN mINIT MINUTE MKDIR MONTH
  syn keyword oplCommand NEXT OFF ONERR OPEN OPENR OR PAUSE PEEKB
  syn keyword oplCommand PEEKW PEEKL PEEKF PI POKEB POKEW POKEL POKEF 
  syn keyword oplCommand POS POSITION PRINT PROC RAD RAISE RANDOMIZE REALLOC RENAME 
  syn keyword oplCommand RETURN RMDIR RND SCREEN SCREENINFO SECOND SECSTODATE SETPATH SETDOC
  syn keyword oplCommand SIN SPACE SQR STD STOP STYLE SUM TAN TESTEVENT TRAP
  syn keyword oplCommand UADD UNLOADM UNTIL UPDATE UPPER$ USE USUB VAL VAR VECTOR
  syn keyword oplCommand WEEK WHILE YEAR
  syn match oplCommand "MID\$\|CHR\$\|CMD\$\|DATIM\$\|DAYNAME\$\|DIR\$\|ERR\$\|FIX\$\|GEN\$\|GET\$\|GETCMD\$"
  syn match oplCommand "HEX\$\|KEY[\$]\|LOWER\$\|LEFT\$\|MONTH\$\|NUM\$\|PARSE\$\|PEEK\$\|POKE\$\|REPT\$\|RIGHT\$"
  syn match oplCommand "SCI\$\|UPPER\$"
  syn match oplPersonal "[a-zA-Z$%]*:"
syn case match
syn match oplConstant "K[a-zA-Z0-9]*[%$&]"
syn match oplConstant "%[a-zA-Z0-9]*"

hi Longvar guifg=lightpink2
hi Intvar guifg=IndianRed2 
hi Number guifg=maroon1
hi Command guifg=SlateBlue1
hi Handle guifg=red
hi Personal guifg=Orange1
hi Constant guifg=turquoise3
hi Stringvar guifg=OliveDrab3
hi String guifg=SeaGreen2


hi link oplCommand		Command
hi link oplComment		Comment
hi link oplStringVar	StringVar
hi link oplIntVar		Intvar
hi link oplLongVar		Longvar
hi link oplString		String
hi link oplNumber		Number
hi link oplHandle		Handle
hi link oplPersonal		Personal
hi link oplConstant		Constant

let b:current_syntax = "opl"

