/*----------------------------------------------------------------------------*/
/* Cifragem de arquivos ASCII por substituicao simples                        */
/* (c) 2002 Joao Luiz Pereira Marciano                                        */
/*----------------------------------------------------------------------------*/

#include <conio.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define ALFABETO 26

/*----------------------------------------------------------------------------*/
/* estrutura de dados com a chave de substituicao                             */
/*----------------------------------------------------------------------------*/

struct {
        char antes,depois;
} Substitui[] = {'a','g','b','d','c','m','d','r','e','w',
                 'f','j','g','u','h','s','i','x','j','h',
                 'k','c','l','q','m','v','n','f','o','z',
                 'p','o','q','b','r','p','s','e','t','y',
                 'u','k','v','a','w','i','x','t','y','l',
                 'z','n'};

/*----------------------------------------------------------------------------*/
/* funcao de cifracao                                                         */
/*----------------------------------------------------------------------------*/

void cifra(char *arq_origem,char *arq_destino) {

        char c;
        int i;
        FILE *origem,*destino;

        if ((origem = fopen(arq_origem,"rt")) == NULL) {
                printf("Erro ao abrir o arquivo em texto claro\n");
                exit(1);
        }

        if ((destino = fopen(arq_destino,"wt")) == NULL) {
                printf("Erro ao abrir o arquivo em texto cifrado\n");
                exit(1);
        }

        while ((c = getc(origem)) != EOF) {

                switch(c) {
                        case '':
                        case '':
                        case '':
                        case '':
                        case '':
                        case '':
                        case '':
                        case '': c = 'a';
                                  break;
                        case '':
                        case '':
                        case '':
                        case '':
                        case '':
                        case '': c = 'e';
                                  break;
                        case '':
                        case '':
                        case '':
                        case '': c = 'i';
                                  break;
                        case '':
                        case '':
                        case '':
                        case '':
                        case '':
                        case '': c = 'o';
                                  break;
                        case '':
                        case '': c = 'c';
                                  break;

                }

                if (isalpha(c)) {

                        c = tolower(c);

                        putc(Substitui[(int)(c - 'a')].depois,destino);

                }
                else putc(c, destino);
        }

        fclose(destino);
        fclose(origem);
}

/*----------------------------------------------------------------------------*/
/* funcao de decifracao                                                       */
/*----------------------------------------------------------------------------*/

void decifra(char *arq_origem,char *arq_destino) {

        char c;
        int i;
        FILE *origem,*destino;

        if ((origem = fopen(arq_origem,"rt")) == NULL) {
                printf("Erro ao abrir o arquivo em texto cifrado\n");
                exit(1);
        }

        if ((destino = fopen(arq_destino,"wt")) == NULL) {
                printf("Erro ao abrir o arquivo em texto claro\n");
                exit(1);
        }

        while ((c=getc(origem)) != EOF) {

                c = getc(origem);

                if (isalpha(c)) {

                        for (i=0;i<ALFABETO;i++)
                                if (Substitui[i].depois == c) {
                                        putc(Substitui[i].antes,destino);
                                        break;
                                }
                }
                else putc(c, destino);
        }

        fclose(destino);
        fclose(origem);
}

/*----------------------------------------------------------------------------*/
/* funcao de descricao do uso do programa                                     */
/*----------------------------------------------------------------------------*/

void utilizacao(void) {
        printf("Utilizacao: \n");
        printf("substitui CIFRA <arq_claro> <arq_cifrado>\n");
        printf("ou\n");
        printf("substitui DECIFRA <arq_cifrado> <arq_claro>\n");
        exit(1);
}

/*----------------------------------------------------------------------------*/
/*                                Funcao principal                            */
/*----------------------------------------------------------------------------*/

void main(int argc,char *argv[]) {

        clrscr();

        if (argc != 4) {
                utilizacao();
        }

        if (!strcmp(argv[1],"CIFRA"))
                cifra(argv[2],argv[3]);

        else if (!strcmp(argv[1],"DECIFRA"))
                decifra(argv[2],argv[3]);

        else utilizacao();
}

