unit Aboutsys;

interface

uses	WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  		Buttons, ExtCtrls, Dialogs, Gfvcl, VBXCtrl, Pict;

type
  TAbout = class(TForm)
    Panel1: TPanel;
    OKButton: TBitBtn;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    GradientFill1: TGradientFill;
    GangScreen: TMemo;
    SysImage: TBiPict;
    procedure SetDetails(Const PName,Ver,Copy,Comment : String);
    procedure OKButtonClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure GangScreenClick(Sender: TObject);
    procedure SysImageClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var About: TAbout;

implementation

{$R *.DFM}

procedure TAbout.SetDetails(Const PName,Ver,Copy,Comment : String);
begin
  Caption							:= 'About' + PName ;
	ProductName.Caption	:= PName ;
	Version.Caption 		:= Ver ;
  Copyright.Caption		:= Copy ;
  Comments.Caption		:= Comment ;
end;

procedure TAbout.OKButtonClick(Sender: TObject);
begin
	Close ;
end;

procedure TAbout.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If ((Shift = [ssAlt]) and (Key = VK_SPACE)) and not GangScreen.Visible then
  Begin
    {MessageDlg('Alt+SPACE pressed down', mtInformation, [mbOK], 0);}
    GangScreen.Visible  := True ;
  End ;
end;

procedure TAbout.FormKeyPress(Sender: TObject; var Key: Char);
begin
  GangScreen.Visible := False ;
end;

procedure TAbout.GangScreenClick(Sender: TObject);
begin
  GangScreen.Visible := False ;
end;

procedure TAbout.SysImageClick(Sender: TObject);
begin
  GangScreen.Visible := True ;
end;

end.

