unit Sys_Res ;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Gauges, Buttons, VBXCtrl, Gauge,
  Switch,Aboutsys, Menus, Timerit;

CONST	ProdName	= 'Sys Info' ;
			Version		= 'Version 1.0' ;
      Copyright	= 'Copyright (c) 1995 Yves Rochat' ;
      Note			= 'First Delphi Application' ;

type
  TInfSysMain = class(TForm)
    InfSysTimer: TTimer;
    MainLabel: TPanel;
    SystemLabel: TLabel;
    GDILabel: TLabel;
    UserLabel: TLabel;
    FreeMemLabel: TLabel;
    FreeMemSize: TLabel;
    NbTaskLabel: TLabel;
    NbreTLabel: TLabel;
    UserPanel: TPanel;
    UserGauge: TGauge;
    GDIPanel: TPanel;
    GDIGauge: TGauge;
    SystemPanel: TPanel;
    SystemGauge: TGauge;
    ExitButton: TBiSwitch;
    LigneSep: TBevel;
    MainMenu: TMainMenu;
    Item_About: TMenuItem;
    LargeMemLabel: TLabel;
    LargeMemSize: TLabel;
    Bevel1: TBevel;
    Thetime: TLabel;
    Thedate: TLabel;
    TimerIterate1: TTimerIterate;
    procedure TimerUpdate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Item_AboutClick(Sender: TObject);
    procedure TimerIterate1LastTick(sender: TObject;
      iCurrentTick: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InfSysMain: TInfSysMain;

implementation

{$R *.DFM}
procedure TInfSysMain.TimerUpdate(Sender: TObject);

begin
  { Dtermine l'heure courante }
  Thetime.Caption := TimeToStr(Time) ;
  { Dtermine le pourcentage de mmoire RESOURCES libre }
	SystemGauge.Progress  := GetFreeSystemResources(GFSR_SystemResources);
  { Dtermine le pourcentage de mmoire GDI libre }
	GDIGauge.Progress     := GetFreeSystemResources(GFSR_GDIResources);
  { Dtermine le pourcentage de mmoire USER libre }
	UserGauge.Progress    := GetFreeSystemResources(GFSR_UserResources);
  { Dtermine la mmoire libre dans le Heap global }
	FreeMemSize.Caption   := IntToStr(GetFreeSpace(0) DIV 1024) + ' Ko' ;
	{ Dtermine le plus grand bloc de mmoire libre dans le Heap global }
	LargeMemSize.Caption  := IntToStr(GlobalCompact(0) DIV 1024) + ' Ko' ;
	{ Calcul du nombre de processus actifs }
  NbreTLabel.Caption := IntToStr(GetNumTasks) ;
end;

procedure TInfSysMain.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TInfSysMain.FormCreate(Sender: TObject);

Var Titre : String ;

begin
  { Dtermine le type de PROCESSEUR }
	If (GetWinFlags and wf_Cpu486) <> 0
		then	Titre := 'System CPU i486'
		else	Titre := 'System CPU 386' ;
  Application.Title			:= Titre ;
  { Dtermine le mode de WINDOWS }
	If (GetWinFlags and wf_Enhanced) <> 0
		then	Titre := Titre + ' in 386 Enhanced Mode'
		else	Titre := Titre + ' in Standard Mode' ;
  Caption								:= Titre ;
	Application.HintColor := clTeal ;
  Application.HintPause := 0 ;
  { Dtermine la date du jour }
  Thedate.Caption := DateToStr(Date) ;
end;

procedure TInfSysMain.Item_AboutClick(Sender: TObject);
begin
  About.SetDetails(ProdName,Version,Copyright,Note) ;
	About.Show
end;

procedure TInfSysMain.TimerIterate1LastTick(sender: TObject;
  iCurrentTick: Integer);
begin
	About.Hide ;
end;

end.
