;--------------------------------------------------------------------------
; Ben Weir
; CIS 35
; Assignment 4
; This program gets a string from the user.  Then it opens a file and checks
; the string against all the passwords in the file until it finds a match or
; it reaches the end of the file.  When it reads the password from the file
; it also has to decrypt it.  It then prints to the screen and printer
; whether or not it found a match.  It repeats this process 5 times.  
;--------------------------------------------------------------------------
        .model small
        .stack 100h
        .data
NumTries equ 5          ;number of passwords the user will enter
StrLen   equ 5          ;length of each password
Print    equ 0          ;1=send output to printer
;
;
;
FHandle dw ?
Eof     db 0
Match   db 0
UserPwd db 5 dup(0), '$'
FilePwd db 5 dup(0)
Code    db 'chooc'
FName   db 'passwds.dat', 0
AcptMsg db 'Password valid', 10, 13, '$'
RjctMsg db 'Invalid password!', 10, 13, '$'
Header  db '+--CIS 35 Password Checker--------+', 10, 13
        db '|Password      Status             |', 10, 13
        db '+---------------------------------+', 10, 13, '$'

        .code
        mov ax, @data
        mov ds, ax
        mov es, ax
  start:
        call OpenFile
        call WriteHeader
        mov cx, NumTries
  NextUsrPwd:
        mov match, 0
        call ResetFile
        push cx
        mov cx, StrLen
        lea si, UserPwd
        lea di, UserPwd
        call ResetUsrPwd        ;sets user password to all zeros
        call ReadString         ;get a password from keyboard
        lea bx, UserPwd
        call Printstr           ; and send it to the printer

  NextFilePwd:
        call ReadFile           ;get a password from the file
        cmp eof, 1
        jz donesearching        ;get out if at end of file

        lea bx, FilePwd
        call Crypt              ;decrypt password from file
        call Compare            ;see if they match
        cmp match, 1
;        jz donesearching

        loopnz NextFilePwd
  donesearching:        
        pop cx
        call WriteResult        ;show whether or not it's the right password
        loop NextUsrPwd

        call CloseFile
  done:
        mov ax, 4c00h
        int 21h


ResetUsrPwd proc near
;input  cx:length
;       di:location of buffer
        push cx
        push di
        
        cld
        mov al, 0
        rep stosb
        
        pop di
        pop cx
        ret
ResetUsrPwd endp

Compare proc near
;compares user password with decrypted one from file
        push cx
        lea si, UserPwd
        lea di, FilePwd
        mov cx, 6
        cld
        repz cmpsb
        cmp cx, 0
        jz matchfound
        jmp donecompare
  matchfound:
        mov match, 1
  donecompare:
        pop cx
        ret
Compare endp

ResetFile proc near
;sets file pointer to beginning of file
        push cx
        push dx
        mov eof, 0              ;erase end of file flag
        mov bx, Fhandle
        mov al, 0
        mov ah, 42h
        xor cx, cx              ;set cx, dx = 0
        xor dx, dx              ;move file pointer to 0 (start of file)
        int 21h
        pop dx
        pop cx
        ret
ResetFile endp

ReadFile proc near
;reads 5 bytes from the file unless there's no more to read
        push cx
        mov bx, Fhandle
        mov cx, 5
        mov ah, 3fh
        lea dx, Filepwd
        int 21h                 ;read file
        cmp ax, 5
        jz readok
readerror:
        mov eof, 1              ;if not 5 bytes read, must be end of file
readok:
        pop cx
        ret
ReadFile endp

WriteResult proc near
;prints whether or not the password was correct
        push cx

        mov ah, 3
        mov bh, 0
        int 10h         ;get cursor position

        mov ah, 2
        mov dl, 15      ;make sure it's in the 15th column so text is aligned
        int 10h         ;set cursor position

        mov ah, print
        cmp ah, 1
        jnz noprint       ;jump if no printer output specified
        
        mov ah, 5
        mov dl, 13
        int 21h                 ;send CR to printer to get it to column 1
        mov dl, 20h

        mov cx, 15
  newspace:
        int 21h                 ;send 15 spaces to printer to get it lined up
        loop newspace
  
  noprint:
        
        cmp match, 1
        jz correctpwd

  wrongpwd:
        lea dx, RjctMsg
        jmp showmsg

  correctpwd:
        lea dx, AcptMsg
  showmsg:
        mov ah, 9
        int 21h                 ;send msg to crt

        mov bx, dx
        call Printstr           ;also send it to the printer

        pop cx
        ret
WriteResult endp

Crypt proc near
;decrypts/encrypts a string pointed to by ds:bx
        push cx

        lea si, code
        mov cx, 5

  Cryptnewchar:
        mov al, [si]
        xor [bx], al            ;xor pwd from file by code
        inc bx                  ;point to next location
        inc si
        loop Cryptnewchar

        pop cx
        ret
Crypt endp

Printstr proc near
;sends a string to the printer
;string is pointed to by DS:BX and terminated by a '$'
        push ax
        mov ah, print
        cmp ah, 1
        jnz endstr              ;get out if Print is set to 0

        mov ah, 5               ;print char function

  nextchar:
        mov dl, [bx]
        cmp dl, '$'             ;quit when '$' encountered
        jz endstr
        int 21h                 ;send it to printer
        inc bx
        jmp nextchar
  endstr:

        pop ax
        ret
Printstr endp

WriteHeader Proc near
;draws the heading that has the Title of the program etc.
        push bx
        push dx

        lea dx, header
        mov ah, 9
        int 21h                 ;print string function

        mov bx, dx
        call Printstr           ;send it to the printer also

        pop dx
        pop bx
        ret
WriteHeader endp

OpenFile proc near
        mov ah, 3dh
        mov al, 11000000b       ;read only
        lea dx, fname           ;point to filename
        int 21h                 ;open file function
        mov Fhandle, ax         ;store file handle for future reference
        ret
OpenFile endp

CloseFile proc near
        mov ah, 3eh
        mov bx, fhandle
        int 21h                 ;close file function
        ret
CloseFile endp

readstring proc near
;enter with cx: number of characters to read
;           si: offset of place to store string
;returns    ax: number of chars entered
        
        push cx
        push si

        mov bx, si              ;save starting address

  readnewchar:
        mov ah, 8               ;char input without echo
        int 21h

        cmp al, 0dh
        jz stringdone           ;exit if they press enter

        cmp al, 8
        jz backspace            ;don't add the character if it's BS

        mov dl, al
        mov ah, 2
        int 21h                 ;show character

        mov [si], al            ;store it in buffer
        inc si
        loop readnewchar

        jmp stringdone

  backspace:
        cmp si, bx               ;don't want to backspace
        jle nomorebs             ;past start of string
        dec si
        mov byte ptr [si], 0
        mov ah, 2
        mov dl, 8
        int 21h
        mov dl, 20h             ;erase character with ' ' and another BS
        int 21h
        mov dl, 8
        int 21h
        inc cx
  nomorebs:
        cmp cx, 0
        jnz readnewchar

  stringdone:
        mov ax, si
        sub ax, bx              ;get total chars entered in AX

        pop si
        pop cx
        ret
readstring endp

        end
