
//  Lucas Lehmer Test [mersenne prime]
//
//  
//  Author : Xkey
//
//  Orig Dte of Coding	:  12-5-99
//	Dte of Last Rev			:  12-6-99
//
//  Note		:  The theory for the following was developed by
//							Edouard Lucas. The simplified form of the test/alg
//							is owing to Derrick Lehmer.
//
//  Algorithm :  (taken from David M Bressouds "Factorization and
//									Primality Testing")
//
//						 M(n) = 2^n - 1
//						 n odd ; n >= 3
//             This will test if M(n) is a mersenne prime or not
//
//						 Inits :
//											input n
//											M = 2^n - 1
//											S = 4
//
//             Loop :  for i = 2 to n - 1
//                        S = S^2 - 2  mod M
//
//             Terminate : 
//                       if S == 0 then M is a mersenne prime
//      
              
#include "lucas_lehmer.h"
#include "ZZ.h"


//  Recall that this routine is for odd n >= 3
//  1) Check that n > 2
//	2) Check that n is odd
//
//  Return vals : 
//								0 ---> failure to meet conditions of algorithm
//								1 ---> # is a mersenne prime
//							 -1 ---> # is composite
int  lucas_lehmer(long n)
{

		// Check that n >= 3
    if (n < 3)
      return 0;

		// Check that n is odd
		if ((n % 2) == 0)
      return 0;


    class ZZ   M;
		
		//  M = 2^n - 1
    power2(M, n);
    //  so far M = 2^n ..now take away 1
    M--;


    class ZZ	two, S;
		two = 2;
		S = 4;

		int i;

		for (i = 2; i < n; i++)
      {
        SubMod(S, SqrMod(S, M), two, M);						// S = S^2 - 2 % M
      }

		// now the test to see if it is a mersenne prime
    if (S == 0)
      return 1;
    else
      return -1;
}