#PBForms Created V1.50
'--------------------------------------------------------------------------------------------------
' Dump Memory - visualizzazione esadecimale o formattata di porzioni di memoria
' DLL con all'interno una funzione che visualizza la memoria a partire dall'indirizzo indicato:
'
' DumpMemory (hWnd, Address, Len, Formato)
'   hWnd    = (Dword) handle finestra padre (anche = 0)
'   Address = (Dword) indirizzo di partenza (obbligatorio, la RAM qui deve essere accessibile, se no  GPF)
'   Len     = (Dword) lunghezza del blocco di memoria da visualizzare
'   Formato = (Asciiz) formato di visualizzazione opzionale
'              una serie di lettere separate da virgole ed eventualmente precedute da un fattore moltiplicativo
'--------------------------------------------------------------------------------------------------

' #Compile Exe       ' Se si compila come EXE (c' la compilazione condizionale #If per avere il PBMain)
 #Compile Dll       ' Se si compila come DLL (c' la compilazione condizionale #If)
#Dim All

' #Debug Error On
'--------------------------------------------------------------------------------------------------
'   ** Includes **
'--------------------------------------------------------------------------------------------------
#PBForms Begin Includes
#Resource "DumpMemory.pbr"
%USEMACROS = 1
#If Not %Def(%WINAPI)
    #Include "WIN32API.INC"
#EndIf
#If Not %Def(%COMMCTRL_INC)
    #Include "COMMCTRL.INC"
#EndIf
#Include "PBForms.INC"
#PBForms End Includes
#Include  "ComDlg32.inc"
'--------------------------------------------------------------------------------------------------
'%NO_TABCONTROL      = 1  ' Tab control
'%NO_TREEVIEW        = 1  ' TreeView
'%NO_CONTROLS        = 1  ' altri controlli visuali standard
'' %NO_VARIOUS         = 1  ' routines di utilit non visuali
'%NO_DATE            = 1  ' routines di gestione date
'%NO_GRAPHIC         = 1  ' routines grafiche
'%NO_PRINT           = 1  ' routines di stampa
'%NO_CONSOLE         = 1  ' routines di gestione applicazione testuale (Console)
'#Include "..\LibUtility\LibUtility.INC"   ' <- le funzioni usate sono state direttamente incluse
'--------------------------------------------------------------------------------------------------
'   ** Constants **
'--------------------------------------------------------------------------------------------------
#PBForms Begin Constants
%IDD_DumpMemory =  101
%IDR_IMGFILE1   =  102
%IDR_IMGFILE2   =  103
%IDR_IMGFILE3   =  104
%IDC_LISTVIEW1  = 1001
%IDC_LABEL1     = 1002
%IDC_cmbAddr    = 1003
%IDC_LABEL2     = 1004
%IDC_txtLen     = 1005
%IDC_LABEL3     = 1006
%IDC_btnReload  = 1008
%IDC_LABEL4     = 1009
%IDC_cmbFormat  = 1010
%IDC_AddressDec = 1011
%IDC_btnFind    = 1012
%IDC_txtFind    = 1013
%IDC_optAscii   = 1014
%IDC_optHex     = 1015
%IDC_btnPrint   = 1018
%IDC_btnSave    = 1019
%IDC_btnCopy    = 1020
#PBForms End Constants
'--------------------------------------------------------------------------------------------------
Global hMain As Dword
Global hListview As Dword
Global AddrIni As Dword
Global LenBlock As Dword
Global FmtBlock As String
Global FindString As String
Global cxIni As Long
Global cyIni As Long
Global NomeFileSave As String
Global PrinterName As String
Global SaveFilenum As Long
Global LinePage As Long
Global szAppPath As Asciiz * 200

' array per il parse della stringa di formato
Global TipoF() As String
Global LenF() As Long
Global nElem As Long
'--------------------------------------------------------------------------------------------------
'   ** Declarations **
'--------------------------------------------------------------------------------------------------
Declare CallBack Function ShowDumpMemoryProc()
Declare Function ShowDumpMemory(ByVal hParent As Dword) As Long
#PBForms Declarations
Declare Function ListViewFindValue(ByVal hListView As Dword, ByVal nColonna As Long, ByRef Valore As String, _
       ByRef nRiga As Long, Optional ByVal Modo As String, Optional ByVal Op As String) As Integer
Declare Function ListViewDelete(ByVal hListView As Dword, Optional ByVal riga As Long) As Integer
Declare Function ListViewGet(ByVal hListView As Dword, ByVal riga As Long, ByVal colonna As Long) As String
Declare Function ListViewSet(ByRef Valore As String, ByVal hListView As Dword, ByVal riga As Long, ByVal colonna As Long, _
         Optional ByVal Modo As String) As Integer
Declare Function ListViewSetSelected(ByVal hListView As Dword, ByVal Riga As Long, Optional ByVal Modo As String) As Integer
Declare Function ListViewClickEvent(ByVal IDC_ListView As Long, ByRef Riga As Long, ByRef Colonna As Long, _
         ByVal lCbMsg As Long, ByVal lCbCtl As Long, ByVal lCbLParam As Long, _
         Optional ByRef x As Long, Optional ByRef y As Long) As Long
Declare Sub WriteError(ByVal Messaggio As String)

$Operatori = "=  <  >  <> <= >= LIKE REGEXPR"
$OpLogici  = "ANDOR "

'--------------------------------------------------------------------------------------------------
Function DumpMemory Alias "DumpMemory" (ByVal hWnd As Dword, ByVal Address As Dword, _
        ByVal L As Dword, fmt As Asciiz) Export As Dword

    AddrIni = Address
    LenBlock = L
    FmtBlock = UCase$(Trim$(fmt))
    FindString = ""
    cyIni = 226   ' Altezza iniziale della Listview
    cxIni = 452   ' Larghezza iniziale della Listview
    NomeFileSave = ""
    PrinterName = "" : LinePage = 0
    If Address = 0 Then MsgBox "Routine 'DumpMemory()' richiamata con Address = 0.",,"Dump Memory"
    If LenBlock = 0 Then LenBlock = 16
    If LenBlock > 102400 Then LenBlock = 102400

    ShowDumpMemory hWnd
    Function = -1
End Function
'-------------------------------------------------------------------------------
' Main DLL entry point called by Windows...
' SOLO SE COMPILATO COME DLL: ----------------
#If Not %Pb_Exe
Function LibMain (ByVal hInstance   As Long, _
                  ByVal fwdReason   As Long, _
                  ByVal lpvReserved As Long) As Long

    Select Case fwdReason
    Case %DLL_PROCESS_ATTACH
'    PBFormsInitComCtls (%ICC_WIN95_CLASSES Or %ICC_DATE_CLASSES Or %ICC_INTERNET_CLASSES)
        'ghInstance = hInstance
        Function = 1   'success!
        'FUNCTION = 0   'failure!  This will prevent the EXE from running.
    Case %DLL_PROCESS_DETACH
        Function = 1   'success!
    Case %DLL_THREAD_ATTACH
        Function = 1   'success!
    Case %DLL_THREAD_DETACH
        Function = 1   'success!
    End Select

End Function
#EndIf
'--------------------------------------------------------------------------------------------------
'   ** Main Application Entry Point **
'--------------------------------------------------------------------------------------------------
' SOLO SE COMPILATO COME EXE: ----------------
#If %Pb_Exe
Function PBMain()
    PBFormsInitComCtls (%ICC_WIN95_CLASSES Or %ICC_DATE_CLASSES Or %ICC_INTERNET_CLASSES)

    DumpMemory (%HWND_DESKTOP, &H00400000, 1024, "")
End Function
#EndIf
'--------------------------------------------------------------------------------------------------
Union VarConvert2
  iInt  As Integer
  iWord As Word
  Str2  As String * 2
End Union
Union VarConvert4
  iLong   As Long
  iDword  As Dword
  nSingle As Single
  Str4    As String * 4
End Union
Union VarConvert8
  iQuad   As Quad
  nDouble As Double
  nCurr   As Currency
  Str8    As String * 8
End Union

' Validazione stringa esadecimale in input; restituisce la traduzione in stringa e opzionalmente in numero
Function ValidaHex(ByRef HexIn As String, ByVal nCifre As Long, Optional ByRef numero As Quad) As String
    Local StringOut As String, s As String, c As String
    Local Num As Word, n As Integer

    Function = ""
    s = Remove$(UCase$(HexIn), Any " &H")
    If s = "" Then Exit Function
    If (Len(s) Mod 2) = 1 Or Len(s) > nCifre Then
       MsgBox "Stringa esadecimale di lunghezza errata.",,"Dump Memory"
       Exit Function
    End If
    StringOut = ""
    For n = 0 To (Len(s) / 2) -1
       c = Mid$(s, n*2+1, 2)
       Num = Val("&H" + c)
       If Hex$(Num, 2) <> c Then
          MsgBox "Stringa esadecimale errata: byte" & Str$(n) & " = " & c,,"Dump Memory"
          Exit Function
       End If
       StringOut = StringOut + Chr$(Num)
    Next n
    If VarPtr(numero) > 0 Then
       numero = Val("&H" + s)
    End If
    Function = StringOut
End Function

' Con i dati in input fa il PEEK della RAM e la mostra nella Listview
' Se Tipo  "F" fa ricerca stringa, se  "P" stampa, se  "S" salva su file di testo il dump
Function RiempieLV(Optional ByVal Tipo As String) As Integer
    Local nBytesRiga As Long, AddrFin As Dword, n As Dword, i As Dword, Address As Dword
    Local nRiga As Long, c As Byte, Elem As Long ', RigaQuad As Quad ', pStr As String Ptr, pNum As Quad Ptr
    Local RigaHex As String, ToL As String, Riga As String, RigaAscii As String, TipoElem As String
    Local sAddr As String, s As String, nLines As Long, nPag As Long
    Local v2 As VarConvert2, v4 As VarConvert4, v8 As VarConvert8

    Control Get Text hMain, %IDC_txtLen To s
    If Val(s) > 200000 Then
       LenBlock = 200000
       Control Set Text hMain, %IDC_txtLen, Trim$(Str$(LenBlock))
    Else
       If Val(s) < 16 Then
          LenBlock = 16
          Control Set Text hMain, %IDC_txtLen, Trim$(Str$(LenBlock))
       Else
          LenBlock = Val(s)
       End If
    End If

    AddrFin = AddrIni + LenBlock
    ' indice dei due vettori
    If IsFalse ArrayAttr(TipoF(),0) Then
       nElem = -1
    End If

    ListViewDelete(hListView, -1) ' Svuota la Listview
    If UCase$(Tipo) = "S" Then   ' Scrive l'intestazione delle colonne su file se richiesto
       Print #SaveFilenum, " "
       Print #SaveFilenum, "Address " & $Tab & "Hex Data  " & Space$(30) & $Tab & "Type" & $Tab & "Ascii / Number"
       Print #SaveFilenum, String$(90, "-")
    End If
    If UCase$(Tipo) = "P" Then   ' Scrive l'intestazione delle colonne in stampa se richiesto
       XPrint " "
       XPrint Space$(4) & "Address " & Space$(4) & "Hex Data  " & Space$(30) & Space$(4) & "Type" & Space$(4) & "Ascii / Number"
       XPrint Space$(4) & String$(80, "-")
    End If

    n = AddrIni : nLines = 5 : nPag = 1
    ' Reload dati
    Do While n < AddrFin
       nRiga = ListViewSet( Hex$(n,8), hListView, nRiga, 0, "Add")
       sAddr = Hex$(n,8)
       Riga = "" : RigaHex = "" : RigaAscii = ""
       TipoElem = ""

       ' Determina il numero e il tipo di bytes della riga in funzione dei vettori di formato
       If Elem > nElem Then
          nBytesRiga = 16
       Else
          If LenF(Elem) > 16 Then   ' Il vettore di formato comprende pi righe di dump
             nBytesRiga = 16
             LenF(Elem) = LenF(Elem) - 16
             TipoElem = TipoF(Elem)
             TipoF(Elem) = ""
          Else
             nBytesRiga = LenF(Elem)
             TipoElem = TipoF(Elem)
             Incr Elem
          End If
       End If

       For i = 1 To nBytesRiga
          c = Peek(n)
          Riga = Riga + Chr$(c)
          RigaHex = RigaHex + Hex$(c,2)
          If i Mod 2 = 0 Then RigaHex = RigaHex + " "
          If c < 32 Then
             RigaAscii = RigaAscii + "."
          Else
             RigaAscii = RigaAscii + Chr$(c)
          End If
          Incr n
       Next i
       ListViewSet(RigaHex, hListView, nRiga, 1)
       ' Scrive il tipo di dato o la lunghezza
       ListViewSet(TipoElem, hListView, nRiga, 2)
       ' Scrive la decodifica ASCII o Numero
       Select Case TipoElem
          Case  "B"
             s = Trim$(Str$(Asc(Riga)))
          Case  "W"
             v2.Str2 = Riga
             s = Trim$(Str$(v2.iWord))
          Case  "I"
             v2.Str2 = Riga
             s = Trim$(Str$(v2.iInt))
          Case  "D"
             v4.Str4 = Riga
             s = Trim$(Str$(v4.iDWord))
          Case  "L"
             v4.Str4 = Riga
             s = Trim$(Str$(v4.iLong))
          Case  "Q"
             v8.Str8 = Riga
             s = Trim$(Str$(v8.iQuad))
          Case  "S"
             v4.Str4 = Riga
             s = Trim$(Str$(v4.nSingle))
          Case  "F"
             v8.Str8 = Riga
             s = Trim$(Str$(v8.nDouble))
          Case  "C"
             v8.Str8 = Riga
             s = Trim$(Str$(v8.nCurr))
          Case Else
             s = RigaAscii
       End Select
       ListViewSet(s, hListView, nRiga, 3)
       If UCase$(Tipo) = "S" Then   ' il caricamento va anche salvato su file
          If Len(RigaHex) < 40 Then RigaHex = RigaHex & Space$(40 - Len(RigaHex))
          Print #SaveFilenum, sAddr & $Tab & RigaHex & $Tab & TipoElem & $Tab & s
       End If
       If UCase$(Tipo) = "P" Then   ' il caricamento va anche stampato
          If nLines+4 >= LinePage Then  ' controlla il fine pagina
             XPrint FormFeed
             Incr nPag
             XPrint " " : XPrint " "
             XPrint Space$(4) & "Address " & Space$(4) & "Hex Data  " & Space$(30) & Space$(4) & _
                  "Type" & Space$(4) & "Ascii / Number" & Space$(10) & "Pag. " & Str$(nPag)
             XPrint Space$(4) & String$(80, "-")
             nLines = 4
          End If
          If Len(RigaHex) < 40 Then RigaHex = RigaHex & Space$(40 - Len(RigaHex))
          XPrint Space$(4) & sAddr & Space$(4) & RigaHex & Space$(4) & TipoElem & Space$(8 - Len(TipoElem)) & s
       End If
       Incr nLines
    Loop


    i = Len(FindString)
    If UCase$(Tipo) = "F" And i > 0 Then   ' il caricamento  il Find di una Stringa
       Address = 0

       For n = AddrIni To (AddrFin - i)
          s = Peek$(n, i)
          If s = FindString Then
             Address = n
             Exit For
          End If
       Next
       If Address > 0 Then
          nRiga = 0
          ListViewFindValue(hListView, 0, Hex$(Address,8), nRiga, "P", ">=")
          If ListViewGet(hListView, nRiga, 0) <> Hex$(Address,8) Then Decr nRiga
          ListViewSetSelected(hListView, nRiga,"V")
          MsgBox "Stringa trovata all'indirizzo " & Hex$(Address,8),,"Dump Memory"
       Else
          MsgBox "Stringa NON presente nel blocco di memoria.",,"Dump Memory"
       End If
    End If

    Function = -1
End Function

Sub AggiornaCombo()
    Local n As Long, Index As Long, hCombo As Dword
    Local s As Asciiz * 200

    ' Prima fa eventuale aggiornamento del combo Address
    Control Get Text hMain, %IDC_cmbAddr To s
    Control Handle hMain, %IDC_cmbAddr To hCombo
    n = Combo_GetCount (hCombo)
    If n < 10 Then
       Index = Combo_FindString (hCombo, 0, s)
       If Index = -1 Then
          ComboBox Add hMain, %IDC_cmbAddr, s
       End If
    End If

    ' Poi fa eventuale aggiornamento del combo Formato
    Control Get Text hMain, %IDC_cmbFormat To s
    If Trim$(s) = "" Then Exit Sub
    Control Handle hMain, %IDC_cmbFormat To hCombo
    n = Combo_GetCount (hCombo)
    If n < 10 Then
       Index = Combo_FindString (hCombo, 0, s)
       If Index = -1 Then
          ComboBox Add hMain, %IDC_cmbFormat, s
       End If
    End If

End Sub
' Decodifica la stringa formato e riempie i vettori corrispondenti
Function DecodeFormato() As Long
    Local Fatt As Long, n As Long, k As Long, i As Long   '  nElem As Long
    Local s As String

  Try
    Function = 0
    nElem = -1
    Control Get Text hMain, %IDC_cmbFormat To s
    If Trim$(s) = "" Then Exit Function

    s = Remove$(s, Any " *.-")
    s = UCase$(s)
    Replace Any ";:|!/" With ",,,,," In s
    Control Set Text hMain, %IDC_cmbFormat, s
    nElem = ParseCount(s) - 1
    Dim ArrElem(0:nElem) As String
    Parse s, ArrElem()

    ReDim TipoF(0:nElem) As Global String
    ReDim LenF(0:nElem) As Global Long
    k = 0
    For n = 0 To nElem
      'If Trim$(ArrElem(n))
        If k > UBound(TipoF) Then
              ReDim Preserve TipoF(k)
              ReDim Preserve LenF(k)
        End If
        LenF(k) = 0
        ' decodifica l'elemento
        If InStr(ArrElem(n), "B") > 0 Then
           TipoF(k) = "B" :  LenF(k) = 1
        End If
        If InStr(ArrElem(n), "I") > 0 Then
           TipoF(k) = "I" :  LenF(k) = 2
        End If
        If InStr(ArrElem(n), "L") > 0 Then
           TipoF(k) = "L" :  LenF(k) = 4
        End If
        If InStr(ArrElem(n), "W") > 0 Then
           TipoF(k) = "W" :  LenF(k) = 2
        End If
        If InStr(ArrElem(n), "D") > 0 Then
           TipoF(k) = "D" :  LenF(k) = 4
        End If
        If InStr(ArrElem(n), "Q") > 0 Then
           TipoF(k) = "Q" :  LenF(k) = 8
        End If
        If InStr(ArrElem(n), "S") > 0 Then
           TipoF(k) = "S" :  LenF(k) = 4
        End If
        If InStr(ArrElem(n), "F") > 0 Then
           TipoF(k) = "F" :  LenF(k) = 8
        End If
        If InStr(ArrElem(n), "C") > 0 Then
           TipoF(k) = "C" :  LenF(k) = 8
        End If
        ArrElem(n) = Remove$(ArrElem(n), Any "ABCDEFGHIJKLMNOPQRSTUVXYWZ")
        ' Decodifica l'eventuale numero rimasto
        If LenF(k) = 0 Then  ' E' una lunghezza di stringa
           If Val(ArrElem(n)) > 0 Then
              LenF(k) = Val(ArrElem(n))
              ' Mette la lunghezza come indicatore di tipo
              TipoF(k) = Trim$(Str$(LenF(k)))
              Incr k
           End If
        Else        ' E' un fattore moltiplicativo
           Fatt = Val(ArrElem(n)) ' fattore di duplicazione
           Incr k
           If Fatt > 1 And Fatt <= 100 Then
              ' Duplica l'ultimo valore inserito per Fatt-1 volte
              For i = 2 To Fatt
                 If k > UBound(TipoF) Then
                    ReDim Preserve TipoF(k)
                    ReDim Preserve LenF(k)
                 End If
                 TipoF(k) = TipoF(k-1) :  LenF(k) = LenF(k-1)
                 Incr k
              Next
           End If
        End If

    Next

    nElem = UBound(TipoF)

  Catch
    MsgBox Str$(Err) & " - " & Error$
    ' Controllo del vettore caricato
    'MsgBox("Ubound vettori =" & Str$(Ubound(TipoF)))
    'For i = 0 To UBound(TipoF)
    '   Msgbox(Str$(i) & " - " & TipoF(i) & " - " & Str$(LenF(i)))
    'Next
  End Try
  Function = -1
End Function
' Genera la testata del file DIF
Function OpenDIF(ByRef nomeTabella As String, Optional ByVal nColonne As Long, Optional ByVal nRighe As Long, Optional ByVal flag As Long) As String
   Function = "TABLE" + $CrLf + "0,1" + $CrLf + """" + nomeTabella + """" + $CrLf + "VECTORS" + $CrLf + _
        "0," + Trim$(Str$(nRighe)) + $CrLf + """""" + $CrLf + "TUPLES" + $CrLf + "0," + Trim$(Str$(nColonne)) + $CrLf + _
        """""" + $CrLf + "DATA" + $CrLf + "0,0" + $CrLf + """""" + $CrLf
End Function
' Genera un inizio record nel DIF
Function NewLineDIF() As String
   Function = "-1,0" + $CrLf + "BOT" + $CrLf
End Function
' Genera il valore nella stringa DIF
' Num indica il tipo di valore numerico; ValString deve essere gi stato tradotto in stringa
Function PutDIF(ByRef ValString As String, Optional ByVal flag As String) As String
   Local s As String

   flag = UCase$(flag)
   s = ""

   If Mid$(flag, 1, 1) = "N" Then
      s = s + "0," + ValString + $CrLf + "V" + $CrLf
   Else
      Replace $CrLf With "\n" In ValString
      Replace $Dq With Chr$(34,34) In ValString
      s = s + "1,0" + $CrLf + """" + ValString + """" + $CrLf
   End If

   Function = s

End Function
' Chiude la stringa DIF con "EOD" (end of data)
Function CloseDIF() As String
   Function = "-1,0" + $CrLf + "EOD" + $CrLf
End Function
' Scrive il contenuto della stringa nella Clipboard secondo il formato specificato (default = %CF_TEXT)
Function ClipboardPut(ByRef Oggetto As String, Optional ByVal cfFormat As Long, Optional ByVal NoClear As Long) As Long
   Local lpMem As Asciiz Ptr
   Local hMem  As Dword, MsgErr As Asciiz * 256

   If Len(Oggetto) = 0 Then Exit Function
   If cfFormat = 0 Then cfFormat = %CF_TEXT
   ' Allocate global memory block
   hMem  = GlobalAlloc(%GHND, Len(Oggetto) + 1)

   ' lock it and get pointer to memory location
   lpMem = GlobalLock(hMem)
   If lpMem = 0 Then
      Call FormatMessage(%FORMAT_MESSAGE_FROM_SYSTEM, ByVal 0&, _
           GetLastError(), ByVal MAKELANGID(%LANG_NEUTRAL, %SUBLANG_DEFAULT), _
           MsgErr, SizeOf(MsgErr), ByVal 0&)
      WriteError(MsgErr)
      Exit Function
   End If
   ' copy object into memory object
   @lpMem = Oggetto

   ' unlock the memory object
   GlobalUnlock hMem

   ' add object to the clipboard
   OpenClipboard 0
   ' Svuota la Clipboard solo se non c' NoClear
   If NoClear = 0 Then EmptyClipboard
   SetClipboardData cfFormat, hMem
   CloseClipboard

   Function = -1
End Function

' Copia il contenuto della Listview nella Clipboard in formato DIF
'   (il flag "S" indica che devono essere copiate solo le righe selezionate)
' In ogni caso la stringa DIF generata viene restituita al chiamante, che la pu salvare su file
Function ListView2Clipboard(ByVal hListview As Dword, Optional ByVal flag As String, Optional ByVal nomeTabella As String) As String
   Local hHeader As Dword, nRighe As Long, nCol As Long, n As Long, i As Long, flagSel As Long, flagWrite As Long
   Local DifString As String, TextString As String, s As String, szText As Asciiz * 256
   Local phdi As HD_ITEM

   Function = ""
   If hListview = 0  Then Exit Function
   flag = UCase$(flag)
   flagSel = 0 : TextString = ""
   If Mid$(flag,1,1) = "S" Then flagSel = -1
   hHeader = ListView_GetHeader(hListView)
   nRighe = ListView_GetItemCount (hListView)                    ' restituisce il numero di item (righe)
   nCol = Header_GetItemCount(hHeader)                           ' restituisce il numero di colonne
   If Trim$(nomeTabella) = "" Then nomeTabella = "LISTVIEW"
   If nRighe <= 0 Or nCol <= 0 Then Exit Function
   ' Scrive la testata DIF
   DifString = OpenDIF(nomeTabella, nRighe+1, nCol)
   ' Prima scrive le intestazioni delle colonne
   DifString = DifString + NewLineDIF()
   For i = 0 To nCol - 1
      phdi.Mask = %HDI_TEXT      ' indica che  richiesto il testo dell'header
      phdi.pszText = VarPtr(szText)    ' punta alla var. Asciiz che conterr il testo dell'header
      phdi.cchTextMax = SizeOf(szText)    ' lunghezza massima della variabile
      Header_GetItem(hHeader, i, phdi)
      s = szText
      DifString = DifString + PutDIF(s)
      TextString = TextString + s + $Spc + $Tab
   Next

   ' Poi scrive i dati
   For n = 0 To nRighe - 1
      flagWrite = -1
      If flagSel Then
         If IsFalse ListView_GetItemState(hListView, n, %LVIS_SELECTED) Then
            flagWrite = 0
         End If
      End If
      If flagWrite Then
         DifString = DifString + NewLineDIF()
         TextString = TextString + $CrLf
         For i = 0 To nCol - 1
            ListView_GetItemText(hListView, n, i, szText, SizeOf(szText))
            s = szText
            DifString = DifString + PutDIF(s)
            TextString = TextString + s + $Spc + $Tab
         Next
      End If
   Next
   DIFstring = DifString + CloseDIF()

   ' Mette la stringa DIF nella Clipboard
   If InStr(flag, "N") = 0 Then
      Call ClipboardPut(TextString, %CF_TEXT)
      Call ClipboardPut(DifString, %CF_DIF, 1)
   End If
   Function = DifString
End Function

'--------------------------------------------------------------------------------------------------
'   ** CallBacks **
'--------------------------------------------------------------------------------------------------
CallBack Function ShowDumpMemoryProc()
    Local s As String, n As Long, num As Quad
    Local cx As Long, cy As Long, result As Long
    Local Riga As Long, Col As Long, Evento As Long

    Evento = ListViewClickEvent(%IDC_LISTVIEW1, Riga, Col, CbMsg, CbCtl, CbLParam)
    If Evento = %NM_DBLCLK Then
       If Col = 0 Then
          s = ListViewGet(hListView, riga, 0)
          Control Set Text CbHndl, %IDC_cmbAddr, s
       End If
       If Col = 1 Then
          s = ListViewGet(hListView, riga, 1)
          s = Remove$(s, " ")
          If Len(s) = 8 Then
             result = MsgBox ("Inserisco il dato " & s & " come indirizzo?",%MB_YESNO,"Memory Dump")
             If result = %IDYES Then
                Control Set Text CbHndl, %IDC_cmbAddr, s
             End If
          End If
       End If
    End If

    Select Case As Long CbMsg
        Case %WM_INITDIALOG
            ' Initialization handler

        Case %WM_NCACTIVATE
            Static hWndSaveFocus As Dword
            If IsFalse CbWParam Then
                ' Save control focus
                hWndSaveFocus = GetFocus()
            ElseIf hWndSaveFocus Then
                ' Restore control focus
                SetFocus(hWndSaveFocus)
                hWndSaveFocus = 0
            End If

        Case %WM_SIZE
            'Adjust size of ListView when size of dialog changes.
            Dialog Get Client CbHndl To cx, cy
            Control Set Size CbHndl, %IDC_LISTVIEW1, cxIni, cy - 58

        Case %WM_COMMAND
            ' Process control notifications
            Select Case As Long CbCtl

                Case %IDC_btnReload
                    If CbCtlMsg = %BN_CLICKED Or CbCtlMsg = 1 Then
                       Control Get Text CbHndl, %IDC_cmbAddr To s
                       s = ValidaHex(s, 8, num)
                       If s <> "" Then
                          s = Hex$(num, 8)
                          Control Set Text CbHndl, %IDC_cmbAddr, s
                          AddrIni = num
                          DecodeFormato()

                          RiempieLV("")
                          AggiornaCombo()
                          Control Set Text CbHndl, %IDC_AddressDec, "("+Trim$(Str$(AddrIni))+")"
                       End If
                    End If

                Case %IDC_btnFind
                    If CbCtlMsg = %BN_CLICKED Or CbCtlMsg = 1 Then
                       Control Get Text CbHndl, %IDC_txtFind To s
                       Control Get Check CbHndl, %IDC_optHex To n
                       If n = 1 Then
                          s = ValidaHex(s, 16)
                       End If
                       If s <> "" Then
                          FindString = s
                          RiempieLV("F")
                       End If
                    End If

                Case %IDC_btnSave
                    If CbCtlMsg = %BN_CLICKED Or CbCtlMsg = 1 Then
                       ' Prima legge e valida indirizzo di partenza e formato
                       Control Get Text CbHndl, %IDC_cmbAddr To s
                       s = ValidaHex(s, 8, num)
                       If s <> "" Then
                          s = Hex$(num, 8)
                          Control Set Text CbHndl, %IDC_cmbAddr, s
                          AddrIni = num
                          DecodeFormato()
                          AggiornaCombo()
                          Control Set Text CbHndl, %IDC_AddressDec, "("+Trim$(Str$(AddrIni))+")"
                       End If
                       ' Poi ricarica i dati salvandoli su file
                       NomeFileSave = "DumpMemory.txt"
                       If SaveFileDialog (CbHndl, "Salvataggio Dump Memory", NomeFileSave, ".", "Text Files|*.txt", "txt", 0) Then
                           SaveFilenum = FreeFile
                           Open NomeFileSave For Output As SaveFilenum
                           If Err > 0 Then
                              MsgBox "Errore in apertura " & NomeFileSave & $Cr & Error$(Err)
                           Else
                              Control Get Text hMain, %IDC_txtLen To s
                              Print #SaveFilenum, "Dump Memory from Hexadecimal Address " & Hex$(AddrIni,8) " - Length: " & s & " bytes"
                              Print #SaveFilenum, "Application: " & szAppPath
                              If Err > 0 Then
                                 MsgBox "Errore in scrittura di " & NomeFileSave & $Cr & Error$(Err)
                              Else
                                 RiempieLV("S")
                                 Close #SaveFilenum
                                 Shell("Notepad " & NomeFileSave)
                              End If
                           End If
                           ErrClear
                       End If
                    End If

                Case %IDC_btnPrint
                    If CbCtlMsg = %BN_CLICKED Or CbCtlMsg = 1 Then
                       ' Prima legge e valida indirizzo di partenza e formato
                       Control Get Text CbHndl, %IDC_cmbAddr To s
                       s = ValidaHex(s, 8, num)
                       If s <> "" Then
                          s = Hex$(num, 8)
                          Control Set Text CbHndl, %IDC_cmbAddr, s
                          AddrIni = num
                          DecodeFormato()
                          AggiornaCombo()
                          Control Set Text CbHndl, %IDC_AddressDec, "("+Trim$(Str$(AddrIni))+")"
                       End If
                       ' Poi ricarica i dati stampandoli
                       ' Sceglie la stampante e determina il numero di linee per pagina
                       XPrint Attach Choose, "DumpMemory"
                       PrinterName = XPrint$
                       If PrinterName = "" Then Exit Function
                       XPrint Get Lines To LinePage
                       '  Msgbox Str$(LinePage)
                       Control Get Text hMain, %IDC_txtLen To s
                       XPrint " "  : XPrint " "
                       XPrint Space$(4) & "Dump Memory from Hexadecimal Address " & Hex$(AddrIni,8) " - Length: " & s & " bytes"
                       XPrint Space$(4) & "Application: " & szAppPath
                       RiempieLV("P")
                       XPrint Close
                    End If

                Case %IDC_btnCopy
                    If CbCtlMsg = %BN_CLICKED Or CbCtlMsg = 1 Then
                       ListView2Clipboard(hListview, "", "DumpMemory")
                    End If

            End Select
    End Select
End Function
'--------------------------------------------------------------------------------------------------
' Routines di utilit
'--------------------------------------------------------------------------------------------------
' Codifica una stringa in modo sia possibile usarla nel contesto indicato da TipoCodifica
Function CodeString(ByRef StringaInput As String, ByVal TipoCodifica As String) As String
'   "SQL"       raddoppia gli apici (') in ('')
'   "REGEXP"    modifica  .\*+?|^$()[]{}  anteponendogli una \
'   "HTML"      cerca i caratteri significativi per l'HTML e vi sostituisce il corrispondente codice
    Dim StringaOut As String, Tipo As String

    Tipo = UCase$(Mid$(Trim$(TipoCodifica), 1, 1))
    StringaOut = StringaInput
    Select Case Tipo
        Case "S"
           Replace "'" With "''" In StringaInput
        Case "R"
           If InStr(StringaInput, Any ".\*+?|^$()[]{}") > 0 Then
              Replace "\" With "\\" In StringaOut
              Replace "." With "\." In StringaOut
              Replace "*" With "\*" In StringaOut
              Replace "+" With "\+" In StringaOut
              Replace "?" With "\?" In StringaOut
              Replace "|" With "\|" In StringaOut
              Replace "^" With "\^" In StringaOut
              Replace "$" With "\$" In StringaOut
              Replace "(" With "\(" In StringaOut
              Replace ")" With "\)" In StringaOut
              Replace "[" With "\[" In StringaOut
              Replace "]" With "\]" In StringaOut
              Replace "{" With "\{" In StringaOut
              Replace "}" With "\}" In StringaOut
           End If
        Case "H"
           Replace "&" With "&amp;" In StringaInput
           Replace "<" With "&lt;" In StringaInput
           Replace ">" With "&gt;" In StringaInput
           Replace $Dq With "&quot;" In StringaInput
    End Select
    Function = StringaOut
End Function

Function CfrItems(ByVal Valore As String, ByVal Op As String, ByVal Valore1 As String, ByVal TipoOp As String) As Integer
    ' Ritorna True (-1) se il confronto tra Valore e Valore1 con l'operatore Op1  vero
    Dim Posiz As Long

    If TipoOp = "T" Then  '  un confronto tra stringhe con Trim preventivo degli spazi
       Valore = Trim$(Valore)
       Valore1 = Trim$(Valore1)
    End If
    Select Case Op
       Case "="
          If TipoOp = "N" Then
             Function = (Val(Valore) = Val(Valore1))
          Else
             Function = (Valore = Valore1)
          End If
       Case "<"
          If TipoOp = "N" Then
             Function = (Val(Valore) < Val(Valore1))
          Else
             Function = (Valore < Valore1)
          End If
       Case ">"
          If TipoOp = "N" Then
             Function = (Val(Valore) > Val(Valore1))
          Else
             Function = (Valore > Valore1)
          End If
       Case "<>"
          If TipoOp = "N" Then
             Function = (Val(Valore) <> Val(Valore1))
          Else
             Function = (Valore <> Valore1)
          End If
       Case "<="
          If TipoOp = "N" Then
             Function = (Val(Valore) <= Val(Valore1))
          Else
             Function = (Valore <= Valore1)
          End If
       Case ">="
          If TipoOp = "N" Then
             Function = (Val(Valore) >= Val(Valore1))
          Else
             Function = (Valore >= Valore1)
          End If
       Case "LIKE"   ' trasforma l'espressione di confronto del LIKE in espressione regolare
          Valore1 = "^" & CodeString(UCase$(Valore1), "REGEXPR")
          Replace "%" With ".*" In Valore1
          Valore = UCase$(Valore)
          RegExpr Valore1 In Valore To Posiz
          If Posiz > 0 Then
             Function = -1
          Else
             Function = 0
          End If
       Case "REGEXPR"
          RegExpr Valore1 In Valore To Posiz
          If Posiz > 0 Then
             Function = -1
          Else
             Function = 0
          End If
       Case Else
          WriteError("Operatore '" & Op & "' errato in CfrItems().")
    End Select
End Function
' Imposta una riga del Listview con i valori contenuti nel vettore in input
Function ListViewSetRow(ByRef Row() As String, ByVal hListView As Dword, ByVal riga As Long, _
         Optional ByVal Modo As String) As Integer
   ' Se Modo = "Add" la linea viene inserita nella posizione "riga"; se riga < 0 la linea viene accodata in fondo
    Local n As Integer, nTotCol As Integer, TotRighe As Long, nCol As Integer, lc1 As Long, uc1 As Long
    Local tLVI As LV_ITEM
    Local szBuf  As Asciiz * 255

    Function = 0
    If hListView <= 0 Then  Exit Function
    If IsFalse ArrayAttr(Row(), 0) Or ArrayAttr(Row(),3) <> 1 Then
       WriteError("Array Riga in input errato in ListViewSetRow().")
       Exit Function
    End If
    Modo = Mid$(UCase$(Trim$(Modo)),1,1)
    lc1 = LBound(Row)     ' colonne di partenza/arrivo dell'array Row in input
    uc1 = UBound(Row)
    nTotCol = Header_GetItemCount(ListView_GetHeader(hListView))  ' restituisce il numero di colonne
    nCol = 0
    If riga < 0 Or Modo = "A" Then
       If riga < 0 Then
          riga = ListView_GetItemCount(hListView)
       End If
       tLVI.stateMask = %LVIS_FOCUSED
       tLVI.pszText   = VarPtr(szBuf)
       tLVI.iItem     = riga
       For n = lc1 To uc1
          szBuf =  Row(n)   ' szBuf contiene il testo da visualizzare
          tLVI.iSubItem = nCol
          tLVI.lParam   = riga
          If nCol = 0 Then
              tLVI.mask = %LVIF_TEXT Or %LVIF_PARAM Or %LVIF_STATE
              If ListView_InsertItem(hListView, tLVI) < 0 Then
                 Exit Function
              End If
          Else
              tLVI.mask = %LVIF_TEXT
              ListView_SetItem(hListView, tLVI)
          End If
          Incr nCol
          If nCol >= nTotCol Then Exit For
       Next n
    Else
       For n = lc1 To uc1
          szBuf = Row(n)
          ListView_SetItemText(hListView, riga, nCol, szBuf)
          Incr nCol
          If nCol >= nTotCol Then Exit For
       Next
    End If
    Function = -1
End Function

' Imposta la Listview vuota con le intestazioni delle colonne
Function ListViewSetColumns(ByVal hListView As Dword, Optional ByRef ArrayHeader() As String, _
         Optional ByRef ArrayColumnWidth() As Integer, Optional ByVal Modo As String) As Integer
    Local lc1 As Long, uc1 As Long     ' estremi inferiore e superiore dell'array di header (monodimensionale)
    Local i As Integer, lCol As Integer
    Local tLVC   As LV_COLUMN
    Local szBuf  As Asciiz * 255
    Local lStyle As Long

    Function = 0
    Modo = Mid$(UCase$(Modo),1,1)
    If hListView <= 0 Then  Exit Function
    If VarPtr(ArrayHeader()) = 0 Or Modo = "D" Then
       ListView_DeleteAllItems(hListView)
       Do While ListView_DeleteColumn(hListView, 0) : Loop
       Function = -1
       Exit Function
    End If
    If IsFalse ArrayAttr(ArrayHeader(), 0) Or ArrayAttr(ArrayHeader(),3) <> 1 Then
       WriteError("Array Headers in input errato in ListViewSetColumns().")
       Exit Function
    End If
    lc1 = LBound(ArrayHeader)     ' colonne
    uc1 = UBound(ArrayHeader)
    ' Cancella tutto il contenuto della Listview preesistente
    If Modo <> "A" Then
       ListView_DeleteAllItems(hListView)
       Do While ListView_DeleteColumn(hListView, 0) : Loop
    End If

    lStyle = ListView_GetExtendedListViewStyle(hListView)
    ' Modificare la prossima istruzione per cambiare lo stile della Listview
    ListView_SetExtendedListViewStyle(hListView, lStyle Or %LVS_EX_FULLROWSELECT _
      Or %LVS_EX_GRIDLINES)
    'ListView_SetBkColor(hListView, %Gray)

    ' Load column headers.
    tLVC.mask    = %LVCF_FMT Or %LVCF_TEXT Or %LVCF_SUBITEM
    tLVC.fmt     = %LVCFMT_LEFT
    tLVC.pszText = VarPtr(szBuf)
    lCol = 0                    ' contatore colonne della listview, a partire da 0
    For i = lc1 To uc1          ' per ognuna delle colonne visibili sulla listview
        szBuf = ArrayHeader(i)
        tLVC.iOrder = lCol
        If ListView_InsertColumn(hListView, lCol, tLVC) = -1 Then
            Exit Function
        End If
        Incr lCol
    Next

    If VarPtr(ArrayColumnWidth()) = 0 Then
       ' Auto size columns.
       For i = 0 To (lCol - 1)
          ListView_SetColumnWidth(hListView, i, %LVSCW_AUTOSIZE_USEHEADER)
       Next lCol
    Else
       ' Imposta la larghezza delle colonne sulla base degli elementi del vettore ArrayColumnWidth()
       If IsFalse ArrayAttr(ArrayColumnWidth(), 0) Or ArrayAttr(ArrayColumnWidth(),3) <> 1 Then
          WriteError("Array ColumnWidth in input errato in ListViewSetColumns().")
          Exit Function
       End If
       lc1 = LBound(ArrayColumnWidth)
       uc1 = UBound(ArrayColumnWidth)
       For i = 0 To (lCol - 1)
          If lc1 <= uc1 And ArrayColumnWidth(lc1) >= 0 Then
             ListView_SetColumnWidth(hListView, i, ArrayColumnWidth(lc1))
          Else
             ListView_SetColumnWidth(hListView, i, %LVSCW_AUTOSIZE_USEHEADER)
          End If
          Incr lc1
       Next lCol
    End If

    Function = -1
End Function
' Ottiene il valore di una cella della Listview
Function ListViewGet(ByVal hListView As Dword, ByVal riga As Long, ByVal colonna As Long) As String
    Local pszText As Asciiz * 256
    If hListView <= 0 Then  Exit Function
    If riga < 0 Or colonna < 0 Then
       WriteError("Numero Riga o Colonna errato (" & Str$(riga) & "," & Str$(colonna) & ") in ListViewGet().")
       Function = ""
       Exit Function
    End If
    ListView_GetItemText(hListView, riga, colonna, pszText, SizeOf(pszText))
    Function = pszText
End Function
' Imposta il valore di una cella della listview
Function ListViewSet(ByRef Valore As String, ByVal hListView As Dword, ByVal riga As Long, ByVal colonna As Long, _
         Optional ByVal Modo As String) As Integer
   ' Se Modo = "Add" e se non esiste la linea, viene aggiunta vuota in fondo prima di impostare il valore della cella
    Local nTotRighe As Long, nTotCol As Integer, n As Integer
    Local pszText As Asciiz * 255
    Local Row() As String

    If hListView <= 0 Then  Exit Function
    nTotCol = Header_GetItemCount(ListView_GetHeader(hListView))
    nTotRighe = ListView_GetItemCount (hListView)

    Modo = Mid$(UCase$(Trim$(Modo)),1,1)
    If (riga < 0 And Modo <> "A") Or colonna < 0 Or colonna >= nTotCol Then
       WriteError("Numero Riga o Colonna errato (" & Str$(riga) & "," & Str$(colonna) & ") in ListViewSet().")
       Function = -1
       Exit Function
    End If

    pszText = Valore
    ' If (riga >= nTotRighe And Modo = "A") Then
    If (Modo = "A") Then
       ReDim Row(nTotCol-1)
       For n = 0 To (nTotCol-1)
          If n = colonna Then
             Row(n) = Valore
          Else
             Row(n) = ""
          End If
       Next
       Call ListViewSetRow(Row(), hListView, -1, "Add")
       Function = nTotRighe
    Else
       If riga >= nTotRighe Then
          Function = -1
       Else
          ListView_SetItemText(hListView, riga, colonna, pszText)
          Function = riga
       End If
    End If
End Function
Function ListViewDelete(ByVal hListView As Dword, Optional ByVal riga As Long) As Integer
    If hListView <= 0 Then  Exit Function
    If riga < 0 Then
       Function = ListView_DeleteAllItems(hListView)
    Else
       Function = ListView_DeleteItem(hListView, riga)
    End If
End Function
' ListViewGetSelected():  ritorna vero (-1) se la riga  selezionata
Function ListViewGetSelected(ByVal hListView As Dword, ByVal riga As Long) As Integer
    Function = ListView_GetItemState(hListView, riga, %LVIS_SELECTED)
End Function
' ListViewSetSelected():  seleziona o deseleziona la riga specificata; se Modo = "N" deseleziona, se "V" rende visibile
' Se Riga < 0 seleziona o deseleziona tutta la Listview
Function ListViewSetSelected(ByVal hListView As Dword, ByVal Riga As Long, Optional ByVal Modo As String) As Integer
    Local TipoSel As Long, n As Long, Count As Long
    If hListView <= 0 Then  Exit Function
    Modo = Mid$(UCase$(Modo),1,1)
    If Modo = "N" Then TipoSel = 0 Else TipoSel = %LVIS_SELECTED
    If Riga < 0 Then
       Count = ListView_GetItemCount (hListView)
       For n = 0 To Count-1
          ListView_SetItemState(hListView, n, TipoSel, %LVIS_SELECTED)
       Next n
    Else
       If Modo = "V" Then
          SetFocus(hListView)
          ListView_EnsureVisible(hListView, riga, 0)
       End If
       ListView_SetItemState(hListView, riga, TipoSel, %LVIS_SELECTED)
    End If
    SetFocus(hListView)
End Function
' ListViewFindValue() cerca il Valore nella colonna specificata della ListView
'   nRiga  indica il numero di riga da cui parte la ricerca e restituisce in output la riga trovata (la prima  sempre la 0)
'   Modo pu essere: "S" seleziona la riga trovata; "P" si posiziona soltanto sulla riga trovata
Function ListViewFindValue(ByVal hListView As Dword, ByVal nColonna As Long, ByRef Valore As String, _
       ByRef nRiga As Long, Optional ByVal Modo As String, Optional ByVal Op As String) As Integer
    Local TotRighe As Long, TotCol As Long, i As Long, Result As Integer
    Local TipoColonna As String, Item As String, pszText As Asciiz * 256

    Function = 0 : Result = 0
    If hListView <= 0 Then  Exit Function
    TotRighe = ListView_GetItemCount (hListView)   ' restituisce il numero totale di righe
    If TotRighe <= 0 Or nRiga >= TotRighe Then  Exit Function
    ' Controllo del numero di colonna in input
    TotCol = Header_GetItemCount(ListView_GetHeader(hListView))    ' restituisce il numero totale di colonne
    If TotCol <= 0 Or nColonna >= TotCol Then
       WriteError("Numero di colonna (" & Str$(nColonna) & ") errata in ListViewFindValue().")
       Exit Function
    End If
    ' Determina se il confronto deve essere numerico
    Modo = UCase$(Modo)
    Op = UCase$(Op) : TipoColonna = "S"   ' confronto tra stringhe
    If InStr(Op, "T") > 0 Or InStr(Modo, "T") > 0 Then TipoColonna = "T"   ' confronto tra stringhe con Trim
    If InStr(Op, "N") > 0 Or InStr(Modo, "N") > 0 Then TipoColonna = "N"   ' confronto tra stringhe numeriche
    Op = Remove$(Op, Any "TN ")
    If Trim$(Op) = "" Then Op = "="
    ' Controlla l'operatore di confronto
    If InStr($Operatori, Op) = 0 Then
       WriteError("Operatore (" & Op & ") errato in ListViewFindValue().")
       Exit Function
    End If

    ' Cerca il valore nella ListView
    For i = nRiga To (TotRighe - 1)
       ListView_GetItemText(hListView, i, nColonna, pszText, SizeOf(pszText))
       Item = pszText
       If CfrItems(Item, Op, Valore, TipoColonna) Then
          nRiga = i
          Result = -1
          Exit For
       End If
    Next i
    ' Se Modo = "S" seleziona la riga trovata
    If Result = -1 Then
       If InStr(Modo, "S") > 0 Then
          SetFocus(hListView)
          ListView_EnsureVisible(hListView, nRiga, 0)
          ListView_SetItemState(hListView, nRiga, %LVIS_SELECTED, %LVIS_SELECTED)
       End If

    End If

    Function = Result
End Function
' Inserito nella Callback, restituisce Riga e Colonna della Listview cliccata dall'utente
Function ListViewClickEvent(ByVal IDC_ListView As Long, ByRef Riga As Long, ByRef Colonna As Long, _
         ByVal lCbMsg As Long, ByVal lCbCtl As Long, ByVal lCbLParam As Long, _
         Optional ByRef x As Long, Optional ByRef y As Long) As Long
    Local pNmLv As NM_LISTVIEW Ptr

    Function = 0
    If lCbMsg = %WM_NOTIFY And lCbCtl = IDC_ListView Then
        pNmLv = lCbLParam
        Select Case @pNmLv.hdr.code
            Case  %NM_CLICK, %NM_RCLICK, %NM_DBLCLK, %NM_RDBLCLK
                Function = @pNmLv.hdr.code
                Riga = @pNmLv.iItem
                Colonna = @pNmLv.iSubItem
                ' MsgBox "Riga: " & Str$(@pNmLv.iItem) & " Colonna: " & Str$(@pNmLv.iSubItem)
                If VarPtr(x) > 0 Then x = @pNmLv.ptAction.x
                If VarPtr(y) > 0 Then y = @pNmLv.ptAction.y
        End Select
    End If
End Function

' Cambia il testo di un tooltip gi creato oppure lo associa al controllo la prima volta
Function SetToolTip(ByVal hDlg As Dword, ByVal tl As Long, ByVal hWndToolTip As Dword, ByRef TestoTip As String) As Integer
   Static TlInfo As TOOLINFO  ' Struttura in output (per scrivere nuovo testo)
   Local TInf As TOOLINFO     ' Struttura in input (per leggere tooltip esistente)
   Local r As Long, x As Long, y As Long, yAltezza As Long, xLarghezza As Long
   Local hControl As Dword
   Static hInst As Long

      If tl <= 0 Or hDlg <= 0 Or hWndToolTip <= 0 Then
         Function = 0
         Exit Function
      End If

      hInst = GetModuleHandle("")
      Control Handle hDlg, tl To hControl
      Control Get Client hDlg, tl To xLarghezza, yAltezza
      Dialog Units hDlg, xLarghezza, yAltezza To Pixels xLarghezza, yAltezza

      TlInfo.hwnd = hControl
      TlInfo.uId = hControl
      TlInfo.hinst = hInst
      TlInfo.uFlags = %TTF_SUBCLASS     ' Or %TTF_TRACK Or %TTF_ABSOLUTE '  Or %TTF_IDISHWND
      TlInfo.lpszText = StrPtr(TestoTip)
      TlInfo.rec.nLeft = 0
      TlInfo.rec.nTop = 0
      TlInfo.rec.nRight = xLarghezza
      TlInfo.rec.nBottom = yAltezza
      TlInfo.cbSize = SizeOf( TOOLINFO )

      TInf.hwnd = hControl
      TInf.uId = hControl
      TInf.hinst = hInst
      TInf.cbSize = SizeOf( TOOLINFO )
      r = SendMessage( hWndToolTip, %TTM_GETCURRENTTOOL, 0, VarPtr( TInf ) )
      ' Se il tooltip relativo al controllo  gi presente, aggiorna soltanto il testo contenuto
      If r Then
         SendMessage hWndToolTip, %TTM_UPDATETIPTEXT, 0, VarPtr( TlInfo )
      Else  ' altrimenti lo aggiunge e lo attiva
         SendMessage( hWndToolTip, %TTM_ADDTOOL, 0, VarPtr( TlInfo ) )
         SendMessage( hWndToolTip, %TTM_ACTIVATE, 1, VarPtr( TlInfo ) )
      End If

      Function = -1
End Function

' Crea il ToolTip e lo associa al controllo
Function CreateToolTip(ByVal hDlg As Dword, ByVal ID_Control As Long, ByRef TestoToolTip As String, _
         Optional ByVal Balloon As Integer, Optional ByVal MaxWidth As Long) As Dword
   Local hWndToolTip As Dword
   Static hInst As Long, nPixel As Long
   Local Stile As Long
   Local Tip As String

      If ID_Control <= 0 Or hDlg <= 0 Then
         Function = 0
         Exit Function
      End If

      ' Crea il ToolTip
      hInst = GetModuleHandle("")
      If Balloon Then
         Stile = %WS_POPUP Or %TTS_NOPREFIX Or %TTS_ALWAYSTIP Or %TTS_BALLOON
      Else
         Stile = %WS_POPUP Or %TTS_NOPREFIX Or %TTS_ALWAYSTIP
      End If
      hWndToolTip = CreateWindowEx( %WS_EX_TOPMOST, $TOOLTIPS_CLASS, "", Stile, _
        %CW_USEDEFAULT, %CW_USEDEFAULT, %CW_USEDEFAULT, _
        %CW_USEDEFAULT, hDlg, 0, hInst, ByVal %NULL)

      SetWindowPos( hWndToolTip, %HWND_TOPMOST, 0, 0, 0, 0, _
        %SWP_NOMOVE Or %SWP_NOSIZE Or %SWP_NOACTIVATE )

      SendMessage( hWndToolTip, %TTM_SETDELAYTIME, %TTDT_INITIAL, 500 ) 'time a pointer must remain stationary before the tooltip appears
      SendMessage( hWndToolTip, %TTM_SETDELAYTIME, %TTDT_AUTOPOP, 5000 ) 'time a tooltip window remains visible If the Pointer is stationary
      SendMessage( hWndToolTip, %TTM_SETDELAYTIME, %TTDT_RESHOW, 100 ) 'time before subsequent tooltips to appear
      If MaxWidth <= 10 Then
         nPixel = 400
      Else
         nPixel = MaxWidth
      End If
      SendMessage hWndToolTip, %TTM_SETMAXTIPWIDTH, 0, nPixel

      ' Imposta il testo del ToolTip
      SetToolTip( hDlg, ID_Control, hWndToolTip, TestoToolTip)

      Function = hWndToolTip

End Function 'CreateToolTip

Global ErrorMode As String * 1 ' Gestione dell'errore: "D" display, "L" filelog, "E" Eventlog, "S" shell, "I" ignora

Sub WriteError(ByVal Messaggio As String)
       MsgBox Messaggio,%MB_ICONERROR,"Error"
End Sub

'--------------------------------------------------------------------------------------------------
'   ** Dialogs **
'--------------------------------------------------------------------------------------------------
Function ShowDumpMemory(ByVal hParent As Dword) As Long
    Local lRslt As Long, hWndToolTip As Dword, Tip As String
    Dim ArrayHeader(3) As String
    Dim ArrayColumnWidth(3) As Integer

    GetModuleFileName(GetModuleHandle(ByVal %NULL), szAppPath, SizeOf(szAppPath))

#PBForms Begin Dialog %IDD_DumpMemory->->
    Local hDlg   As Dword
    Local hFont1 As Dword
    Local hFont2 As Dword
    Local hFont3 As Dword

    Dialog New  hParent, "Dump Memory - " + szAppPath, 181, 94, 458, 284, %WS_POPUP Or %WS_DLGFRAME Or _
        %WS_THICKFRAME Or %WS_CAPTION Or %WS_SYSMENU Or %WS_MINIMIZEBOX Or %WS_MAXIMIZEBOX Or _
        %WS_VISIBLE Or %DS_MODALFRAME Or %DS_3DLOOK Or %DS_NOFAILCREATE Or %DS_SETFONT Or _
        %DS_CENTER, %WS_EX_WINDOWEDGE Or %WS_EX_CONTROLPARENT Or %WS_EX_LEFT Or _
        %WS_EX_LTRREADING Or %WS_EX_RIGHTSCROLLBAR, To hDlg
    Control Add ComboBox,  hDlg, %IDC_cmbAddr, , 50, 21, 65, 85, %WS_CHILD Or %WS_VISIBLE Or _
        %WS_TABSTOP Or %WS_VSCROLL Or %CBS_DROPDOWN Or %CBS_UPPERCASE, %WS_EX_LEFT Or _
        %WS_EX_LTRREADING Or %WS_EX_RIGHTSCROLLBAR
    Control Add TextBox,   hDlg, %IDC_txtLen, "", 215, 21, 35, 12, %WS_CHILD Or %WS_VISIBLE Or _
        %WS_TABSTOP Or %ES_RIGHT Or %ES_AUTOHSCROLL Or %ES_NUMBER, %WS_EX_CLIENTEDGE Or _
        %WS_EX_LEFT Or %WS_EX_LTRREADING Or %WS_EX_RIGHTSCROLLBAR
    Control Add ComboBox,  hDlg, %IDC_cmbFormat, , 50, 36, 405, 90, %WS_CHILD Or %WS_VISIBLE Or _
        %WS_TABSTOP Or %CBS_DROPDOWN, %WS_EX_LEFT Or %WS_EX_LTRREADING Or %WS_EX_RIGHTSCROLLBAR
    Control Add Button,    hDlg, %IDC_btnReload, "Reload", 252, 21, 30, 12
    Control Add "SysListView32", hDlg, %IDC_LISTVIEW1, "ListView1", 2, 55, 452, 225, %WS_CHILD Or _
        %WS_VISIBLE Or %WS_BORDER Or %WS_TABSTOP Or %LVS_REPORT Or %LVS_SHOWSELALWAYS, _
        %WS_EX_LEFT Or %WS_EX_RIGHTSCROLLBAR
    Control Add Label,     hDlg, %IDC_LABEL1, "Hex Address", 1, 23, 44, 10
    Control Add Label,     hDlg, %IDC_LABEL2, "Length:", 174, 22, 41, 10
    Control Add Label,     hDlg, %IDC_LABEL3, "Format:", 1, 38, 45, 10
    Control Add Label,     hDlg, %IDC_LABEL4, "Visualizzazione della memoria RAM a partire " + _
        "dall'indirizzo esadecimale indicato.", 1, 5, 270, 10
    Control Add Label,     hDlg, %IDC_AddressDec, "", 119, 22, 51, 11
    Control Add Button,    hDlg, %IDC_btnFind, "Find", 293, 21, 31, 12
    Control Add TextBox,   hDlg, %IDC_txtFind, "", 325, 21, 65, 12
    Control Add Option,    hDlg, %IDC_optAscii, "Ascii", 395, 21, 32, 10
    Control Add Option,    hDlg, %IDC_optHex, "Hex", 425, 21, 30, 10
    Control Add ImgButton, hDlg, %IDC_btnPrint, "#" + Format$(%IDR_IMGFILE2), 410, 0, 20, 19
    Control Add ImgButton, hDlg, %IDC_btnSave, "#" + Format$(%IDR_IMGFILE1), 385, 0, 20, 19
    Control Add ImgButton, hDlg, %IDC_btnCopy, "#" + Format$(%IDR_IMGFILE3), 435, 0, 20, 19

    hFont1 = PBFormsMakeFont("MS Sans Serif", 8, 700, %FALSE, %FALSE, %FALSE, %ANSI_CHARSET)
    hFont2 = PBFormsMakeFont("Courier New", 9, 400, %FALSE, %FALSE, %FALSE, %ANSI_CHARSET)
    hFont3 = PBFormsMakeFont("Courier New", 10, 400, %FALSE, %FALSE, %FALSE, %ANSI_CHARSET)

    Control Send hDlg, %IDC_cmbAddr, %WM_SETFONT, hFont1, 0
    Control Send hDlg, %IDC_cmbFormat, %WM_SETFONT, hFont2, 0
    Control Send hDlg, %IDC_LISTVIEW1, %WM_SETFONT, hFont3, 0
#PBForms End Dialog

    Control Send hDlg, %IDC_txtLen, %EM_LIMITTEXT, 6, 0
    Control Send hDlg, %IDC_txtFind, %EM_LIMITTEXT, 20, 0

    Control Handle hDlg, %IDC_LISTVIEW1 To hListView
    ArrayHeader(0) = " Address" : ArrayHeader(1) = " Hex Data" : ArrayHeader(2) = "Type" : ArrayHeader(3) = " Ascii / Number"
    ArrayColumnWidth(0) = 90 : ArrayColumnWidth(1) = 340 : ArrayColumnWidth(2) = 44 : ArrayColumnWidth(3) = 180

    ListViewSetColumns(hListView, ArrayHeader(), ArrayColumnWidth())

    Control Set Text hDlg, %IDC_cmbAddr, Hex$(AddrIni,8)
    ComboBox Add hDlg, %IDC_cmbAddr, Hex$(AddrIni,8)
    Control Set Text hDlg, %IDC_AddressDec, "("+Trim$(Str$(AddrIni))+")"
    Control Set Text hDlg, %IDC_txtLen, Trim$(Str$(LenBlock))
    Control Set Text hDlg, %IDC_cmbFormat, FmtBlock
    ComboBox Add hDlg, %IDC_cmbFormat, FmtBlock
    Control Set Check hDlg, %IDC_optAscii, 1
    ' Imposta i Tooltip dei controlli
    hWndToolTip = CreateToolTip(hDlg, %IDC_cmbAddr, "Indirizzo di inizio visualizzazione nell'address-space del processo corrente.")
    SetToolTip(hDlg,%IDC_txtLen, hWndToolTip, "Lunghezza del blocco di memoria visualizzato")
    SetToolTip(hDlg,%IDC_txtFind, hWndToolTip, "Scrivere il testo o l'esadecimale da cercare nel blocco di memoria")
    SetToolTip(hDlg,%IDC_btnReload, hWndToolTip, "Ricarica il blocco di memoria da visualizzare")
    SetToolTip(hDlg,%IDC_btnFind, hWndToolTip, "Ricarica il blocco di memoria cercando la stringa voluta")
    SetToolTip(hDlg,%IDC_btnSave, hWndToolTip, "Salva il Dump in un file di testo")
    SetToolTip(hDlg,%IDC_btnCopy, hWndToolTip, "Copia il Dump nella Clipboard")
    SetToolTip(hDlg,%IDC_btnPrint, hWndToolTip, "Stampa il Dump")
    SetToolTip(hDlg,%IDC_LISTVIEW1, hWndToolTip, "Doppio click sull'Address per modificare l'indirizzo di partenza di visualizzazione")
    Tip = "Eventuale formato di decodifica della parte iniziale del blocco visualizzato:" & $Cr
    Tip = Tip + "scrivere i tipi di dati voluti eventualmente preceduti da un fattore moltiplicativo" & $Cr
    Tip = Tip + "oppure scrivere il numero di bytes del campo;  l'elenco  separato da virgole." & $Cr
    Tip = Tip + "I formati sono i seguenti: B (byte), I (Integer), W (Word), L (Long), D (Dword) " & $Cr
    Tip = Tip + "Q (BigInt di 8 bytes), S (Float di 4 bytes), F (Float di 8 bytes), C (Currency di 8 bytes) "
    SetToolTip(hDlg,%IDC_cmbFormat, hWndToolTip, Tip)

    hMain = hDlg

    DecodeFormato()
    RiempieLV("")

    Dialog Show Modal hDlg, Call ShowDumpMemoryProc To lRslt

#PBForms Begin Cleanup %IDD_DumpMemory
    DeleteObject hFont1
    DeleteObject hFont2
    DeleteObject hFont3
#PBForms End Cleanup

    Function = lRslt
End Function
'--------------------------------------------------------------------------------------------------
