(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 14, L0, center, nohscroll, italic;
	fontset = section, "TimesET", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "TimesET", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "NTHarmonica", 12, L0, nohscroll;
	fontset = smalltext, "Futuris", 10, L0, nohscroll;
	fontset = input, "NTCourierVK", 11, L-5, nowordwrap, bold;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65280;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, B65280;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, center, nohscroll;
	fontset = special2, "Times New Roman", 12, L0, nohscroll;
	fontset = special3, "Times New Roman", 12, L0, nohscroll;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 12, L0, nohscroll;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = title; inactive; startGroup; nohscroll; center; ]
El Gamal
:[font = subsubtitle; inactive; nohscroll; center; ]
Fomin Stanislav 
:[font = special1; inactive; nohscroll; center; ]
Demonstration of the El Gamal public key encryption system.
:[font = subsection; inactive; startGroup; nohscroll; ]
Reference
:[font = subsubsection; inactive; locked; startGroup; nohscroll; ]
Author
:[font = smalltext; inactive; endGroup; nohscroll; ]
  
 - 
 375
stas@server.ru
:[font = subsubsection; inactive; locked; startGroup; nohscroll; ]
Copyright Notice
:[font = smalltext; inactive; nohscroll; ]
Copyright  1992    
:[font = smalltext; inactive; preserveAspect; endGroup; nohscroll; ]
Permission is hereby granted to make copies of	this file for any purpose other than direct profit,
or as part of a commercial product, provided this copyright notice is left intact.	Sale is prohibited.
	
Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.
:[font = subsubsection; inactive; startGroup; nohscroll; ]
Version
:[font = smalltext; inactive; endGroup; nohscroll; ]
Notebook Version 2.2 (E)
:[font = subsubsection; inactive; startGroup; nohscroll; ]
Requirements
:[font = smalltext; inactive; nohscroll; ]
Mathematica Version: 2.2 or higher.
:[font = input; initialization; endGroup; endGroup; nowordwrap; ]
*)
If[$VersionNumber < 2.2, Print[
  "This package requires Mathematica version 2.0 or higher."]]
(*
:[font = section; inactive; startGroup; nohscroll; ]
 
:[font = subsection; inactive; startGroup; nohscroll; ]
 .
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]

       .

:
	 g, y -    G.
	   x, ,  g^x=y 
	 .

,         g 
   ,  G -     ( 
 g).

:[font = subsection; inactive; startGroup; nohscroll; ]
 .
:[font = text; inactive; nohscroll; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; plain; fontName = "NTHarmonica"; fontSize = 12; ]

           
   .
          p  g - 
  GF[p]. ,     GF[p] 
       (   
 ).       
  ,  ,   
     . ,  
 g   ,  
	1) g^(p-1)=1
	2) g^d <> 1      d<p-1  -  p-1
       
 p-1,     (p-1)/q ,  q -   p-1. 

    GF[p] -    1  p-2.

        (    ) 
    z -    0  p-1.
     z0=g^z   z0    . 

:[font = subsection; inactive; nohscroll; ]
.

:[font = text; inactive; nohscroll; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; plain; fontName = "NTHarmonica"; fontSize = 12; ]
     (  )     
    GF[p].      .
	1)    k  GF[p]
	2) 
		1) 1=g^k 	mod p
		2) c2=x+z0^k	mod p
	3)   (1,2).

   .

:[font = subsection; inactive; nohscroll; ]

:[font = text; inactive; endGroup; nohscroll; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; plain; fontName = "NTHarmonica"; fontSize = 12; ]

     :
	1) c1^z=g^kz
	2) z0^k=g^zk
:
	c2-c1^z= (x+g^zk) - g^kz = x


,        
 ,   ,    
 .

:[font = subsection; inactive; preserveAspect; startGroup; nohscroll; ]

:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
 .       .		
		"", , 1996

 .         .		
		"", , 1994

 .              .
		 2.   .
		"", , 1977

 ..	     .
			.	.	

:[font = subsection; inactive; preserveAspect; startGroup; nohscroll; ]
 .
:[font = text; inactive; preserveAspect; endGroup; nohscroll; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; plain; fontName = "NTHarmonica"; fontSize = 12; ]

EGPrime[digits]		      .
EGPrimitif[p]		   GF[p]
EGStringToList[text, n]	      Z[n]
EGListToString[text, n]	    Z[n]   
EGEncodeNumber[x, z0,g,p]	     z0
EGDecodeNumber[x,z,p]	    z
EGEncode[text,z0,g,p]	     z0
EGDecode[l, z,p]		     z	




:[font = subsection; inactive; startGroup; nohscroll; ]

:[font = text; inactive; nohscroll; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; plain; fontName = "NTHarmonica"; fontSize = 12; ]
    .




:[font = text; endGroup; endGroup; nohscroll; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]





:[font = section; inactive; startGroup; nohscroll; ]

:[font = subsection; inactive; startGroup; nohscroll; ]

:[font = input; initialization; nowordwrap; ]
*)
BeginPackage["EGPackages`"];
(*
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
EGPrime::usage =
"EGPrime[digits]       ..";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGPrimitif::usage =
"EGPrimitif[p]	   GF[p]";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGStringToList::usage =
"EGStringToList[text, n]       Z[n]";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGListToString::usage =
"EGListToString[text, n]     Z[n]  ";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGEncodeNumber::usage =
"EGEncodeNumber[x, z0,g,p]      z0";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGDecodeNumber::usage =
"EGDecodeNumber[x,z,p]     z";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGEncode::usage =
"EGEncode[text,z0,g,p]      z0";
(*
:[font = input; initialization; nowordwrap; ]
*)
EGDecode::usage =
"EGDecode[l, z,p]      z	";
(*
:[font = input; initialization; endGroup; nowordwrap; ]
*)
Begin["`Private`"];
(*
:[font = subsection; inactive; preserveAspect; startGroup; nohscroll; ]
 
:[font = input; initialization; preserveAspect; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)
EGPrime[digits_Integer] :=
  Module[{candidat},
    candidat = Random[Integer, {10^(digits-1), 10^digits-1}];
    If[EvenQ[candidat], cand++];
    While[!PrimeQ[candidat], cand += 2];
    candidat
  ]
(*
:[font = subsection; inactive; initialization; preserveAspect; nohscroll; ]
*)
   GF[p]
(*
:[font = input; initialization; preserveAspect; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)

EGPrimitifTest1[x_Integer,p_Integer]:=
	Return[If[ PowerMod[x,p-1,p]==1, True, False]];

(*
:[font = input; initialization; preserveAspect; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)

EGPrimitifTest2[x_Integer,p_Integer,divs_List]:=
    Module[
	{i,len,pm},
	 len	  = Length[divs];
	 If[len<3, Return[True]];	
	 For[
		i=2, i<len, i++, 
		pm = PowerMod[x, (p-1)/divs[[i]], p];
		If[ pm==1, Return[False]; 
		  ];
	    ];	
	 Return[True]
	]


(*
:[font = input; initialization; preserveAspect; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)
EGPrimitif[p_Integer] :=
  Module[{candidat,divs},
    divs = Divisors[p-1];
    candidat = Random[Integer, {2, p-1}];
    While[(!EGPrimitifTest1[candidat,p]) 
		|| (!EGPrimitifTest2[candidat,p,divs]),
	 candidat =Mod[candidat+2, p];
	]; 
    Return[candidat];
  ]




(*
:[font = input; initialization; preserveAspect; endGroup; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)



(*
:[font = subsection; inactive; startGroup; nohscroll; ]
  
:[font = input; initialization; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)
EGEncodeNumber[x_Integer, z0_Integer, g_Integer, p_Integer]:=
  Module[{c1,c2,k},
	k  = Random[Integer,0,p-1];
	c1 = PowerMod[g, k, p];
	c2 = Mod[ x + PowerMod[z0, k, p], p];
	List[c1,c2]
	]

(*
:[font = input; initialization; endGroup; nowordwrap; backColorRed65280; backColorGreen65280; backColorBlue65280; fontColorRed0; fontColorGreen0; fontColorBlue0; bold; fontName = "System"; fontSize = 10; ]
*)
EGDecodeNumber[ crypt_, z_Integer, g_Integer, p_Integer]:=
  Module[{x},
	x = Mod[ crypt[[2]] - PowerMod[ crypt[[1]], z], p];
	x
	]
(*
:[font = subsection; inactive; startGroup; nohscroll; ]
 
:[font = input; initialization; nowordwrap; ]
*)
ConvertString[str_String] :=
  Fold[Plus[256 #1, #2]&, 0, ToCharacterCode[str]]
(*
:[font = input; initialization; nowordwrap; ]
*)
EGStringToList[text_String, n_Integer] :=
  Module[
    { 
      blockLength = Floor[N[Log[256, n]]],
      strLength = StringLength[text]
    },    
    ConvertString /@ Table[StringTake[text, 
        {i, Min[strLength, i + blockLength - 1]}],
      {i, 1, strLength, blockLength}]
  ] /; n > 256
(*
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
MakeList[0] = {};
(*
:[font = input; initialization; nowordwrap; ]
*)
MakeList[num_Integer] :=
  Append[MakeList[Quotient[num, 256]], Mod[num, 256]]
(*
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
ConvertNumber[num_Integer] := FromCharacterCode /@ MakeList[num]
(*
:[font = input; initialization; endGroup; nowordwrap; ]
*)
EGListToString[l_List] :=
  StringJoin[ConvertNumber /@ l]
(*
:[font = subsection; inactive; startGroup; nohscroll; ]
  
:[font = input; initialization; nowordwrap; ]
*)
EGEncode[text_String, z0_Integer, g_Integer, p_Integer] :=
  EGEncodeNumber[#, z0, g, p]& /@
    EGStringToList[text, p] /; p > 256
(*
:[font = input; initialization; endGroup; nowordwrap; ]
*)
EGDecode[l_List, z0_Integer, p_Integer] :=
  EGListToString[EGDecodeNumber[#, z0, p]& /@ l]
(*
:[font = subsection; inactive; startGroup; nohscroll; ]

:[font = input; initialization; nowordwrap; ]
*)
End[ ];
(*
:[font = input; initialization; startGroup; nowordwrap; ]
*)
EndPackage[ ];
(*
:[font = message; inactive; formatted; output; endGroup; endGroup; endGroup; endGroup; nowordwrap; ]
Can't Format Cell


;[o]
EndPackage::noctx: No previous context defined.
^*)