;**********************************************************
;*  atod877.ASM
;**********************************************************
	list p=16f877

	; Include file, change directory if needed
	include "p16f877.inc"

;***** VARIABLE DEFINITIONS
AtoD_HI		EQU     0x20        ; variable used for saving 
AtoD_LO		EQU     0x21        ; 

	; Start at the reset vector
	org	0x000
	nop
	goto	Start

	org	0x20
Start:
	bsf	STATUS,RP0	; Select Bank1
	bcf	STATUS,RP1
	movlw	B'10000111'	; TMR0 prescaler, 1:256
	movwf	OPTION_REG
	movlw	h'FF'		; PORTB all as inputs
	movwf	TRISB
	clrf	TRISC		; PORTC all as outputs
	;
	movlw	B'00001110'	;Left justify,1 analog channel
	movwf	ADCON1		;VDD and VSS references
	;
	bcf	STATUS,RP0	; Select Bank0
	;
	movlw	B'01000001'	; Fosc/8 [7-6], A/D ch0 [5-3], a/d on [0]
	movwf	ADCON0

	clrf	PORTC		; CLEAR PORT C
Main
	btfss	INTCON,T0IF	;Wait for Timer0 to timeout
	goto	Main
	bcf	INTCON,T0IF

	bsf	ADCON0,GO	; Start A/D conversion
Wait:
	btfsc	ADCON0,GO	; Wait for conversion to complete
	goto	Wait
        movfw   ADRESH		; Write A/D result to AtoD_HI,AtoD_LO
        movwf   AtoD_HI
        bsf     STATUS,RP0	; Select BANK1
        bcf     STATUS,RP1
        movfw	ADRESL
        bcf     STATUS,RP0      ; Select BANK0
        movwf   AtoD_LO   
	movwf	PORTC		; Write Low byte value to PORTC
WaitPush:
	btfsc	PORTB,0		; Wait push button press
	goto	WaitPush
	goto	Main		;Do it again

	end
