/* Fenix - Compilador/intrprete de videojuegos
 * Copyright (C) 1999 Jos Luis Cebrin Page
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Variables globales de propsito general */

#include <SDL_types.h>

#include "files.h"
#include "xctype.h"

/* ---------------------------------------------------------------------- */
/* Mdulos generales de mantenimiento de datos                            */
/* ---------------------------------------------------------------------- */

#include "typedef.h"
#include "constants.h"
#include "identifiers.h"
#include "strings.h"

/* ---------------------------------------------------------------------- */
/* Compilador                                                             */
/* ---------------------------------------------------------------------- */

#include "segment.h"
#include "varspace.h"
#include "token.h"
#include "codeblock.h"
#include "procdef.h"
#include "compiler.h"

extern int autoinclude ;	/* Incluye ficheros en el DCB automticamente */
extern int imports[] ;		/* Cdigos de cadena con nombres de imports */
extern int nimports ;		/* Nmero de imports */

/* Funciones para guardar y cargar un fichero DCB */

#include "dcb.h"

extern void dcb_add_file (const char * filename) ;
extern int  dcb_save (const char * filename, int options) ;

/* Funciones del sistema (no definidas) */

typedef struct _sysproc
{
	int    code ;
	char * name ;
	char * paramtypes ;
	BASETYPE type ;
	int    params ;
	int    id ;
}
SYSPROC ;

extern SYSPROC * sysproc_get (int id) ;
extern char *    sysproc_name (int code) ;

/* Compilador de expresiones fijas */

extern int compile_fixed_expresion() ;

/* Constantes DIV */

extern void div_init() ;

#include "offsets.h"
#include "pslang.h"

