/* Fenix - Compilador/intrprete de videojuegos
 * Copyright (C) 1999 Jos Luis Cebrin Page
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "identifiers.h"

/* ---------------------------------------------------------------------- */
/* Gestor de identificadores                                              */
/* ---------------------------------------------------------------------- */

static identifier * identifier_hash[64] ;
static int          identifier_code = 1 ;
int                 identifier_count = 0 ;

int identifier_hash_value (const char * string)
{
	int t = 0 ;
	const char * ptr = string ;

	while (*ptr) t = (t << 1) | *ptr++ ;
	return (t & 63) ;
}

identifier * identifier_first()
{
	int n ;

	for (n = 0 ; n < 64 ; n++)
	{
		if (identifier_hash[n])
			return identifier_hash[n] ;
	}
	return 0 ;
}

identifier * identifier_next (identifier * id)
{
	int n ;

	if (id->next) return id->next ;

	n = identifier_hash_value (id->name) ;
	for (n++ ; n < 64 ; n++)
	{
		if (identifier_hash[n])
			return identifier_hash[n] ;
	}
	return 0 ;
}

void identifier_init ()
{
	int i ;

	for (i = 0 ; i < 64 ; i++) identifier_hash[i] = 0 ;

	identifier_count = 0 ;
	identifier_code = 1 ;
}

void identifier_dump ()
{
	int i ;
	identifier * ptr ;

	printf ("---- %d identifiers ----\n", identifier_count) ;
	for (i = 0 ; i < 64 ; i++)
	{
		ptr = identifier_hash[i] ;
		while (ptr)
		{
			printf ("%4d: %-32s [%04d]\n", ptr->code, ptr->name, i) ;
			ptr = ptr->next ;
		}
	}
}

int identifier_add_as (const char * string, int code)
{
	int hash = identifier_hash_value(string) ;
	identifier * w = (identifier *)malloc(sizeof(identifier)) ;

	if (!w)
	{
		fprintf (stdout, "identifier_add: sin memoria\n") ;
		exit(1);
	}

	w->name = strdup(string) ;
	if (!w->name)
	{
		fprintf (stdout, "identifier_add: sin memoria\n") ;
		exit(1);
	}

	w->code = code ;
	w->next = identifier_hash[hash] ;
	identifier_hash[hash] = w ;
	identifier_count++ ;
	
	return 1 ;
}

int identifier_add (const char * string)
{
	int code = identifier_code++ ;
	if (!identifier_add_as (string, code)) return 0 ;
	return code ;
}

int identifier_search (const char * string)
{
	int hash = identifier_hash_value (string) ;
	identifier * ptr = identifier_hash[hash] ;

	while (ptr)
	{
		assert (ptr->name) ;
		if (ptr->name[0] == *string)
		{
			if (strcmp (string, ptr->name) == 0)
				break ;
		}
		ptr = ptr->next ;
	}
	return ptr ? ptr->code : 0 ;
}

const char * identifier_name (int code)
{
	int i ;
	identifier * ptr ;

	for (i = 0 ; i < 64 ; i++)
	{
		ptr = identifier_hash[i] ;
		while (ptr)
		{
			if (ptr->code == code)
				return ptr->name ;
			ptr = ptr->next ;
		}
	}
	return 0 ;
}

int identifier_search_or_add (const char * string)
{
	int result ;

	result = identifier_search (string) ;
	return result ? result : identifier_add (string) ;
}

int identifier_next_code ()
{
	return identifier_code ;
}
