/* 
 *
 *  Consola Feniv v0.1
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fxc.h"

#define VERSION "Consola FXC 0.76b (" __DATE__ " " __TIME__ ")"

#include "messages.c"

/* ---------------------------------------------------------------------- */

int debug = 0 ;

#define MAX_FILES 64

int n_files = 0 ;
char files[MAX_FILES][256] ;

int load_file (char * filename)
{
	long   size ;
	file * fp = file_open (filename, "rb0") ;
	char * source ;

        if (n_files == MAX_FILES)
                compile_error (MSG_TOO_MANY_FILES) ;
        strcpy (files[n_files++], filename) ;

	if (!fp)
	{
		fprintf (stdout, MSG_FILE_NOT_FOUND "\n", filename) ;
		exit (1) ;
	}

	size = file_size (fp) ;

	source = (char *) malloc(size+1) ;
	if (!source)
	{
		fprintf (stdout, MSG_FILE_TOO_BIG "\n", filename) ;
		exit (1) ;
	}

	if (!file_read (fp, source, size))
	{
		fprintf (stdout, MSG_READ_ERROR "\n", filename) ;
		exit (1) ;
	}
	source[size] = 0 ;
	file_close (fp) ;

	token_init (source, n_files-1) ;
        return n_files-1 ;
}

extern int full_screen, double_buffer ;

int dcb_options = 0 ;

main (int argc, char **argv)
{
	char * filename = 0 ;
	char dcbname[256] ;
	int i, j ;
 
    printf (VERSION " - Adaptacin de Fenix Proyecto 1\n") ;

	for (i = 1 ; i < argc ; i++)
	{
		if (argv[i][0] == '-')
		{
			j = 1 ;
			while (argv[i][j])
			{
				if (argv[i][j] == 'c') dos_chars = 1 ;
				if (argv[i][j] == 'i')
				{
					if (argv[i][j+1] == 0)
					{
						if (i == argc-1)
						{
							printf (MSG_DIRECTORY_MISSING "\n") ;
							exit (1) ;
						}
						file_addp (argv[i+1]);
						i++ ;
						break ;
					}
					file_addp (argv[i]+j+1) ;
					break ;
				}
				j++ ;
			}
		}
		else
		{
			if (filename)
			{
				printf (MSG_TOO_MANY_FILES "\n") ;
				return 0 ;
			}
			filename = argv[i] ;
		}
	}
	if (!filename)
	{
		printf (MSG_USING
#ifdef DEBUG
			MSG_OPTION_D
#endif
                        MSG_OPTIONS,
			argv[0]) ;
		return 0 ;
	}

	strcpy (dcbname, filename) ;
	if (strchr(dcbname, '.')) *strchr(dcbname, '.') = 0 ;
    strcat (dcbname, ".ccb") ;

	init_c_type() ;

	identifier_init() ;
	constants_init() ;
	string_init () ;
	compile_init () ;
	div_init() ;

	load_file (filename) ;
	compile_program() ;
	dcb_save (dcbname, dcb_options) ;

	return 1 ;
}

