/* Fenix - Compilador/intrprete de videojuegos
 * Copyright (C) 1999 Jos Luis Cebrin Page
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fxc.h"

/* ----------------------------------------------------------------------- */
/* Este mdulo contiene las definiciones de constantes, locales y globales */
/* predefinidos, as como el cdigo que los carga y define cada una de las */
/* funciones del sistema (es llamado antes de empezar a compilar).         */
/* ----------------------------------------------------------------------- */

struct
{
	char * name ;
	int    code ;
} 
keys[] =
{
	{ 0, 0 }
} ;

char * locals_def =
"	STRUCT reserved \n"
"		process_id ; \n"
"		id_scan ; \n"
"		process_type ; \n"
"		type_scan ; \n"
"		status = 2 ; \n"
"		param_offset ; \n"
"		program_index ; \n"
"		is_executed ; \n"
"		is_painted ; \n"
"		distance_1 ; \n"
"		distance_2 ; \n"
"		frame_percent ; \n"
"		box_x0, box_y0 ; \n"
"		box_x1, box_y1 ; \n"
"	END \n"
" \n"
"	father ; \n"
"	son ; \n"
"	smallbro ; \n"
"	bigbro ; \n"
"	priority ; \n"
"	ctype ; \n"
"	cflags ; \n"
"	x ; \n"
"	y ; \n"
"	z ; \n"
"	graph ; \n"
"	flags ; \n"
"	size = 100 ; \n"
"	angle ; \n"
"	region ; \n"
"	file ; \n"
"	pointer xgraph ; \n"
"	height ; \n"
"	cnumber ; \n"
"	resolution ; \n"
 ;

char * globals_def = 
"	STRUCT mouse \n"
"		x, y ; \n"
"		graph ; \n"
"		file ; \n"
"		z = -512 ; \n"
"		angle ; \n"
"		size = 100 ; \n"
"		flags ; \n"
"		region ; \n"
"		left, middle, right ; \n"
"	END \n"
" \n"
"	STRUCT scroll[9] \n"
"		x0, y0 ; \n"
"		x1, y1 ; \n"
"		z = 512 ; \n"
"		camera ; \n"
"		ratio = 200; \n"
"		speed ; \n"
"		region1 = -1 ; \n"
"		region2 = -1 ; \n"
"		flags1 ; \n"
"		flags2 ; \n"
"               follow = -1 ; \n"
"		reserved[6] ;		// Tamao: 20 dwords  \n"
"	END \n"
" \n"
"	STRUCT joy \n"
"		left ; \n"
"		right ; \n"
"		up ; \n"
"		down ; \n"
"		button1 ; \n"
"		button2 ; \n"
"		button3 ; \n"
"		button4 ; \n"
"	END \n"
" \n"
"	STRUCT setup \n"
"		card ; \n"
"		port ; \n"
"		irq ; \n"
"		dma ; \n"
"		dma2 ; \n"
"		master ; \n"
"		sound_fx ; \n"
"		cd_audio ; \n"
"	END \n"
" \n"
"	timer[9] ; \n"
" \n"
"	text_z = -256; \n"
"	fading ; \n"
"	shift_status ; \n"
"	ascii ; \n"
"	scan_code ; \n"
"	joy_filter ; \n"
"	joy_status ; \n"
"	restore_type ; \n"
"	dump_type ; \n"
"	max_process_time ; \n"
"	 \n"
"	// Modo 7 \n"
"	 \n"
"	STRUCT m7[9] \n"
"		camera ; \n"
" \n"
"		height   = 32 ; \n"
"		distance = 64 ; \n"
"		horizon  = 0 ; \n"
"		focus    = 256 ; \n"
"		z        = 256 ; \n"
"		color    = 0 ; \n"
"		flags    = 0 ; \n"
"		reserved[1] ; \n"
"	END \n"
" \n"
"	// No documentados \n"
" \n"
"	fps ; \n"
" \n"
"	// Propios de Fenix \n"
" \n"
"	text_flags ; \n"
"	pansep = 64 ; \n"
"	reverb = 0 ; \n"
"	volume = 128 ; \n"
"	sound_freq = 22050; \n"
"	sound_mode = 1 ; \n" 
"   graph_mode = 0; \n"
" \n"
"       argc ; \n"
"       string argv[32] ; \n"
" \n"
"	speed_gauge = 0 ; \n"
"   textcolor ; \n"
"   backcolor ; \n"
 ;

struct
{
	char * name ;
	int    code ;
} 
constants_def[] =
{
	{ "M320X200",		3200200 },
	{ "M320X240",		3200240 },
	{ "M320X400",		3200400 },
	{ "M360X240",		3600240 },
	{ "M376X282",		3760282 },
	{ "M400X300",		4000300 },
	{ "M512X384",		5120384 },
	{ "M640X400",		6400400 },
	{ "M640X480",		6400480 },
	{ "M800X600",		8000600 },
	{ "M1024X768",		10240768 },
	{ "M1280X1024",		12801024 },
	{ "MODE_16BITS",	1 },
	{ "TRUE",		1 },
	{ "FALSE",		0 },
	{ "S_KILL",		0 },
	{ "S_WAKEUP",		1 },
	{ "S_SLEEP",		2 },
	{ "S_FREEZE",		3 },
	{ "S_KILL_TREE",	100 },
	{ "S_WAKEUP_TREE",	101 },
	{ "S_SLEEP_TREE",	102 },
	{ "S_FREEZE_TREE",	103 },
	{ "ALL_TEXT",		0 },
	{ "ALL_SOUND",		-1 },
	{ "G_WIDE",		0 },
	{ "G_HEIGHT",		1 },
	{ "G_CENTER_X",		2 },
	{ "G_CENTER_Y",		3 },
	{ "G_X_CENTER",		2 },
	{ "G_Y_CENTER",		3 },
	{ "G_PITCH",		4 },
	{ "G_DEPTH",		5 },
	{ "G_FRAMES",		6 },
	{ "G_ANIMATION_STEPS",	7 },
	{ "G_ANIMATION_STEP",	8 },
	{ "G_ANIMATION_SPEED",	9 },
	{ "PF_NODIAG",		1 },
	{ "PF_REVERSE",		2 },
	{ "C_SCREEN",		0 },
	{ "C_SCROLL",		1 },
	{ "C_M7",		2 },
	{ "PARTIAL_DUMP",	0 },
	{ "COMPLETE_DUMP",	1 },
	{ "NO_RESTORE",		-1 },
	{ "PARTIAL_RESTORE",	0 },
	{ "COMPLETE_RESTORE",	1 },
	{ "C_0",		1 },
	{ "C_1",		2 },
	{ "C_2",		4 },
	{ "C_3",		8 },
	{ "C_4",		16 },
	{ "C_5",		32 },
	{ "C_6",		64 },
	{ "C_7",		128 },
	{ "C_8",		256 },
	{ "C_9",		512 },
	{ "MIN_INT",		-32767 },
	{ "MAX_INT",		32767 },
	{ "PI",			180000 },
	{ "BACKGROUND",         0 },
	{ "SCREEN",             -1 },
	{ "O_READ",             0 },
	{ "O_READWRITE",        1 },
	{ "O_RDWR",             1 },
	{ "O_WRITE",            2 },
	{ "O_ZREAD",            3 },
	{ "O_ZWRITE",           4 },
	{ "VAR_STRING",			2 },
	{ "VAR_INT",			3 },
	{ "VAR_FLOAT",			4 },
	{ "VAR_BYTE",			5 },
	{ "VAR_WORD",			6 },
	{ 0, 0 }
} ;

void div_init ()
{
	int i = 0, code ;
	while (keys[i].name)
	{
		code = identifier_search_or_add (keys[i].name) ;
		constants_add (code, keys[i].code) ;
		i++ ;
	}
	i = 0 ;
	while (constants_def[i].name)
	{
		code = identifier_search_or_add (constants_def[i].name) ;
		constants_add (code, constants_def[i].code) ;
		i++ ;
	}

	token_init (globals_def, 0) ;
	compile_varspace (&global, globaldata, 1) ;
	token_init (locals_def, 0) ;
	compile_varspace (&local, localdata, 1) ;
}
