/* Fenix - Compilador/intrprete de videojuegos
 * Copyright (C) 1999 Jos Luis Cebrin Page
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>

#include "fxc.h"
#include "messages.c"

/* Este fichero contiene slo las definiciones de las funciones del sistema */

#define SYSMACRO(a) 0
#include "sysprocs.h"

int sysproc_add (char * name, char * paramtypes, int type, void * func)
{
	static SYSPROC * last = 0 ;
	static int sysproc_count = 0 ;

	if (!last) 
	{
		last = sysprocs ;
		sysproc_count++ ;
		while (last[1].name) last++, sysproc_count++ ;
	}
	last[1].code = last[0].code + 1 ;
	last[1].name = name ;
	last[1].paramtypes = paramtypes ;
	last[1].params = strlen(paramtypes) ;
	last[1].type = type ;
	last[1].id   = 0 ;
	last++ ;
	sysproc_count++ ;
	if (sysproc_count == MAX_SYSPROCS)
		compile_error (MSG_TOO_MANY_SYSPROCS) ;
	return last->code ;
}

SYSPROC * sysproc_get (int id)
{
	SYSPROC * s = sysprocs ;

	while (s->name)
	{
		if (!s->id) s->id = identifier_search_or_add(s->name) ;
		if (s->id == id) return s ;

		s++ ;
	}
	return 0 ;
}

char * sysproc_name (int code)
{
	SYSPROC * s = sysprocs ;

	while (s->name)
	{
		if (s->code == code) return s->name ;
		s++ ;
	}
	return 0 ;
}

