/*
 *  Fenix - Videogame compiler/interpreter
 *  Current release       : FENIX - PROJECT 1.0 - R 0.76
 *  Last stable release   : 
 *  Project documentation : http://fenix.divsite.net
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  Copyright  1999 Jos Luis Cebrin Page
 *  Copyright  2002 Fenix Team
 *
 */

/*
 * FILE        : main.c
 * DESCRIPTION : Main entry point for FXI
 *
 * HISTORY:
 *
 */

/*
 * INCLUDES
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <windows.h>

#include "fxi.h"
#include "SDL_Types.h"

/*
 *  GLOBAL VARIABLES
 */

int debug = 0 ;		/* EXTERN defined in fxi.h */
int fxi   = 0 ;		/* EXTERN defined in fxi.h */

CONSOLE_CURSOR_INFO curinfo;
unsigned int shortcursor = 0x0607, tallcursor = 0x0507, normalcursor = 0x0407,
         nocursor = 0x2000;
HANDLE si,so;

/*
 *  FUNCTION : do_exit
 *
 *  Exits from the program cleanly ending operations
 *
 *  PARAMS:
 *      INT n: ERROR LEVEL to return to OS
 *
 *  RETURN VALUE: 
 *      No value
 *
 */

void
do_exit(int n)
{
	exit(n) ;
}

/*
 *  FUNCTION : main
 *
 *  Main function for FXI
 *
 *  PARAMS:
 *      INT n: ERROR LEVEL to return to OS
 *
 *  RETURN VALUE: 
 *      No value
 *
 */

main (int argc, char **argv)
{
	char * filename = 0 ;
	char dcbname[256] ;
	INSTANCE * mainproc_running ;
	int i, j ;
	int norun = 0 ;
	char * ptr ;

	/* Find out if we are calling fxi.exe or whatever.exe */
 	ptr = argv[0] + strlen(argv[0]) ;
 	while (ptr > argv[0] && ptr[-1] != '\\' && ptr[-1] != '/') 
 		ptr-- ;
 	fxi = (strncmp(ptr,"fxi",3) == 0) || (strncmp(ptr,"FXI",3) == 0) ;
 
	/* Init RAND generator */
	srand (time(NULL)) ;

    /* Init Win32 Console info */
    si = GetStdHandle (STD_INPUT_HANDLE);
    so = GetStdHandle (STD_OUTPUT_HANDLE);
    SetConsoleMode (si, ENABLE_WINDOW_INPUT );
    SetConsoleTitle ("conFxi");
    setcursor (shortcursor);
    setcursor (nocursor);

	if (fxi) {
       /* we are calling FXI.EXE */
	}

 	if (!fxi) {
		/* calling WHATEVER.EXE must guess DCB/DAT filename */
 		filename = ptr ;
 		while (*ptr != '.') ptr++ ;
 		*ptr = 0 ;
	} else {
		/* Calling FXI.EXE so we must get all command line params */
		for (i = 1 ; i < argc ; i++) {
			if (argv[i][0] == '-') {
				j = 1 ;
				while (argv[i][j]) {
					if (argv[i][j] == 'r') norun = 1 ;
					if (argv[i][j] == 'i') {
						if (argv[i][j+1] == 0) {
							if (i == argc-1)
                                printf("You must provide a directory\n") ;
							file_addp (argv[i+1]);
							i++ ;
							break ;
						}
						file_addp (argv[i]+j+1) ;
						break ;
					}
					j++ ;
				}
			} else {
				if (!filename) {
					filename = argv[i] ;
					if (i < argc-1)
						memmove (&argv[i], &argv[i+1],
							sizeof(char*) * (argc-i-1)) ;
					argc-- ;
					i-- ;
				}
			}
		}

		if (!filename) {
            printf(VERSION " - Adaptacin de Fenix Proyecto 1\n"
                "Uso: %s [opciones] archivo.ccb\n\n",
				argv[0]) ;
			return 0 ;
		}
	}

	string_init () ;
	init_c_type() ;
	
	/* Init application title for windowed modes */
	strcpy (dcbname, filename) ;

	if (!file_exists(dcbname))
	{
		/* Hack: con FXI renombrado, se permite que el fichero
         * de datos tenga una extensin .DAT en vez de .CCB */

 		if (!fxi)
 		{
 			strcat (dcbname, ".dat") ;
 			if (!file_exists(dcbname))
 			{
 				strcpy (dcbname, filename) ;
                strcat (dcbname, ".ccb") ;
 			}
 		}
 		else
 		{
            strcat (dcbname, ".ccb") ;
 		}
	}

	if (!dcb_load (dcbname))
		return -1 ;

	sysproc_init () ;

	if (argc > 32) argc = 32 ;
	for (i = 0 ; i < argc ; i++)
	{
		int * ptr = &GLODWORD(ARGV_TABLE+i*4) ;
		*ptr = string_new(argv[i]) ;
		string_use (*ptr) ;
	}
	GLODWORD(ARGC) = argc-1 ;

     // Inicialization Console Functions
    GLODWORD(TEXTCOLOR) = 8;
    GLODWORD(BACKCOLOR) = 1;

	if (mainproc)
	{
		mainproc_running = instance_new (mainproc, 0) ;
		instance_go_all () ;
	}

    //SetConsoleTextAttribute (so, 15, 7 );
    SetConsoleTextAttribute (so, 7 + ( 16 * ( 0 ) ) );
    setcursor (normalcursor);

	do_exit(0);
}

