/*
 *  Fenix - Videogame compiler/interpreter
 *  Current release       : FENIX - PROJECT 1.0 - R 0.76
 *  Last stable release   : 
 *  Project documentation : http://fenix.sourceforge.net
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  Copyright  1999 Jos Luis Cebrin Page
 *  Copyright  2002 Fenix Team
 *
 */

/*
 * FILE        : sysprocs.h
 * DESCRIPTION : Defines FENIX language function SPECS and handlers
 *
 * HISTORY     : 0.73 - ADDED 0xEF MEMORY_TOTAL
 *				 0.73 - ADDED 0xF7 MEMORY_FREE
 *
 */

#ifndef SYSMACRO

/*
 *  IN FXI: SYSMACRO returns a function pointer
 *  IN FXC: Already defined to return 0
 */

#define SYSMACRO(a) a

#endif

#define MAX_SYSPROCS 512

SYSPROC sysprocs[MAX_SYSPROCS] =
{
	/* Depurado */
	{ 0x00, "SAY"                   , "S"     , TYPE_DWORD  , 1 , SYSMACRO(div_say) },
	/* Matemticas */
	{ 0x10, "RAND"                  , "II"    , TYPE_DWORD  , 2 , SYSMACRO(div_rand) },
	{ 0x11, "RAND_SEED"             , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_rand_seed) },
	{ 0x12, "ABS"                   , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_abs) },
	{ 0x13, "POW"                   , "FF"    , TYPE_FLOAT  , 2 , SYSMACRO(div_pow) },
	{ 0x14, "FGET_ANGLE"            , "IIII"  , TYPE_DWORD  , 4 , SYSMACRO(div_fget_angle) },
	{ 0x15, "FGET_DIST"             , "IIII"  , TYPE_DWORD  , 4 , SYSMACRO(div_fget_dist) },
	{ 0x16, "NEAR_ANGLE"            , "III"   , TYPE_DWORD  , 3 , SYSMACRO(div_near_angle) },
	{ 0x19, "SQRT"                  , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_sqrt) },
	{ 0x20, "COS"                   , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_cos) },
	{ 0x21, "SIN"                   , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_sin) },
	{ 0x22, "TAN"                   , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_tan) },
	{ 0x23, "ACOS"                  , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_acos) },
	{ 0x24, "ASIN"                  , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_asin) },
	{ 0x25, "ATAN"                  , "F"     , TYPE_FLOAT  , 1 , SYSMACRO(div_atan) },
	/* Interaccin entre procesos */
	{ 0x34, "GET_ID"                , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_get_id) },
	{ 0x36, "SIGNAL"                , "II"    , TYPE_DWORD  , 2 , SYSMACRO(div_signal) },
	{ 0x37, "LET_ME_ALONE"          , ""      , TYPE_DWORD  , 0 , SYSMACRO(div_let_me_alone) },
	{ 0x38, "EXIT"                  , "SI"    , TYPE_DWORD  , 2 , SYSMACRO(div_exit) },
	/* Entrada/Salida */
	{ 0x50, "KEY"                   , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_key) },
	/* Fecha */
	{ 0x9A, "TIME"                  , ""      , TYPE_DWORD  , 0 , SYSMACRO(div_time) },
	{ 0x9B, "FTIME"                 , "SI"    , TYPE_STRING , 2 , SYSMACRO(div_ftime) },
	/* Ficheros */
	{ 0xA0, "SAVE"                  , "SPI"   , TYPE_DWORD  , 3 , SYSMACRO(div_save) },
	{ 0xA1, "LOAD"                  , "SP"    , TYPE_DWORD  , 2 , SYSMACRO(div_load) },
	{ 0xA2, "FOPEN"                 , "SI"    , TYPE_DWORD  , 2 , SYSMACRO(div_fopen) },
	{ 0xA3, "FCLOSE"                , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_fclose) },
	{ 0xA4, "FREAD"                 , "IPI"   , TYPE_DWORD  , 3 , SYSMACRO(div_fread) },
	{ 0xA5, "FWRITE"                , "IPI"   , TYPE_DWORD  , 3 , SYSMACRO(div_fwrite) },
	{ 0xA6, "FSEEK"                 , "III"   , TYPE_DWORD  , 3 , SYSMACRO(div_fseek) },
	{ 0xA7, "FTELL"                 , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_ftell) },
	{ 0xA8, "FLENGTH"               , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_filelength) },
	{ 0xA9, "FPUTS"                 , "IS"    , TYPE_DWORD  , 2 , SYSMACRO(div_fputs) },
	{ 0xAA, "FGETS"                 , "I"     , TYPE_STRING , 1 , SYSMACRO(div_fgets) },
	{ 0xAB, "FEOF"                  , "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_feof) },
        { 0xAC, "FILE"                  , "S"     , TYPE_STRING , 1 , SYSMACRO(div_file) },
        /* Funciones de Consola */
        { 0xB0, "CLS"                   , ""      , TYPE_UNDEFINED, 0 , SYSMACRO(div_cls) },
        { 0xB1, "LOCATE"                , "II"    , TYPE_UNDEFINED, 2 , SYSMACRO(div_locate) },
        { 0xB2, "SETCOLOR"              , "II"    , TYPE_UNDEFINED, 2 , SYSMACRO(div_setcolor) },
        { 0xB3, "PRINT"                 , "S"     , TYPE_UNDEFINED, 1 , SYSMACRO(div_print) },
        { 0xB4, "PRINTLN"               , "S"     , TYPE_UNDEFINED, 1 , SYSMACRO(div_println) },
        { 0xB5, "GETKEY"                , ""      , TYPE_WORD,      0 , SYSMACRO(div_getkey) },
        { 0xB6, "INKEY"                 , ""      , TYPE_WORD,      0 , SYSMACRO(div_inkey) },
        /* Tratamiento de cadenas */
	{ 0xD0, "LEN"                   , "S"     , TYPE_DWORD  , 1 , SYSMACRO(div_strlen) },
	{ 0xD1, "UCASE"                 , "S"     , TYPE_STRING , 1 , SYSMACRO(div_strupper) },
	{ 0xD2, "LCASE"                 , "S"     , TYPE_STRING , 1 , SYSMACRO(div_strlower) },
	{ 0xD3, "SUBSTR"                , "SII"   , TYPE_STRING , 3 , SYSMACRO(div_substr) },
	{ 0xD4, "FIND"                  , "SS"    , TYPE_DWORD  , 2 , SYSMACRO(div_strfind) },
	{ 0xD5, "ITOA"                  , "I"     , TYPE_STRING , 1 , SYSMACRO(div_itos) },
	{ 0xD6, "FTOA"                  , "F"     , TYPE_STRING , 1 , SYSMACRO(div_ftos) },
	{ 0xD7, "ATOI"                  , "S"     , TYPE_DWORD  , 1 , SYSMACRO(div_stoi) },
	{ 0xD8, "ATOF"                  , "S"     , TYPE_FLOAT  , 1 , SYSMACRO(div_stof) },
	{ 0xD9, "ASC"                   , "S"     , TYPE_BYTE   , 1 , SYSMACRO(div_asc) },
	{ 0xDA, "CHR"                   , "I"     , TYPE_STRING , 1 , SYSMACRO(div_chr) },
	/* Extensiones adicionales */
	{ 0xEF, "MEMORY_TOTAL"		, ""	  , TYPE_FLOAT  , 0 , SYSMACRO(div_memory_total) },
	{ 0xF0, "ALLOC"      		, "I"     , TYPE_POINTER, 1 , SYSMACRO(div_alloc) },
	{ 0xF1, "FREE"       		, "P"     , TYPE_DWORD  , 1 , SYSMACRO(div_free) },
	{ 0xF2, "REALLOC"    		, "PI"    , TYPE_POINTER, 2 , SYSMACRO(div_realloc) },
	{ 0xF3, "EXISTS"     		, "I"     , TYPE_DWORD  , 1 , SYSMACRO(div_running) },
	{ 0xF4, "MEMSET"     		, "PBI"   , TYPE_DWORD  , 3 , SYSMACRO(div_memset) },
	{ 0xF5, "MEMSETW"    		, "PWI"   , TYPE_DWORD  , 3 , SYSMACRO(div_memsetw) },
	{ 0xF6, "MEMCOPY"    		, "PPI"   , TYPE_DWORD  , 3 , SYSMACRO(div_memcopy) },
	{ 0xF7, "MEMORY_FREE"		, ""	  , TYPE_FLOAT  , 0 , SYSMACRO(div_memory_free) },
	{ 0    ,0                       , ""      , TYPE_DWORD  , 0 , 0  }
} ;
