// ===============================================================
//   COMANDOS.C
// ===============================================================

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

#include "comandos.h"
#include "parser.h"
#include "hbasic.h"

int ftos, gtos;
extern int linea_fuente;

extern CONSOLE_CURSOR_INFO curinfo;
extern unsigned int shortcursor, tallcursor, nocursor, normalcursor;

struct etiqueta tabla_etiquetas[NUM_ETI];

struct for_estructura fpila[FOR_NEXT];

struct comandos tabla[] = {
   { "print",    PRINT },
   { "input",    INPUT },
   { "if",       IF },
   { "then",     THEN },
   { "else",     ELSE },
   { "goto",     GOTO },
   { "for",      FOR },
   { "next",     NEXT },
   { "to",       TO },
   { "gosub",    GOSUB },
   { "return",   RETURN },
   { "end",      END },
   { "rem",      REM },
   { "wait_key", WAIT_KEY},
   { "cls",      CLS},
   { "locate",   LOCATE},
   { "color",    COLOR},
   { "",         END }
};


//-----------------------------------------------
void busca_etiquetas() {
//-----------------------------------------------
   int direc;
   char *temp;

   etiqueta_inicializacion();
   temp = prog;

   obtiene_token();
   if (token_tipo ==  NUMERO) {
      strcpy(tabla_etiquetas[0].nombre, token);
      tabla_etiquetas[0].p = prog;
    }
    busca_fdl();
    do {
       obtiene_token();
       if (token_tipo == NUMERO) {
          direc = obtiene_siguiente_etiqueta(token);
          if (direc == -1 || direc == -2)
             (direc == -1) ? serror(5) : serror(6);
          strcpy(tabla_etiquetas[direc].nombre, token);
          tabla_etiquetas[direc].p = prog;
       }
      if(tok != FDL) busca_fdl();
   } while(tok != TERMINADO);
   prog = temp;
   linea_fuente = 1;
}


//-----------------------------------------------
void busca_fdl() {
//-----------------------------------------------
   while(*prog != '\n' && *prog != '\0') ++prog;
}


//-----------------------------------------------
int obtiene_siguiente_etiqueta(char *s) {
//-----------------------------------------------
   register int t;

   for(t = 0; t < NUM_ETI; ++t) {
      if(tabla_etiquetas[t].nombre[0] == 0) return t;
      if(!strcmp(tabla_etiquetas[t].nombre, s)) return -2;
   }
   return -1;
}

//-----------------------------------------------
char *busca_etiqueta(char *s) {
//-----------------------------------------------
   register int t;

   for(t = 0; t < NUM_ETI; ++t)
      if(!strcmp(tabla_etiquetas[t].nombre, s))
         return tabla_etiquetas[t].p;

   return '\0';
}


//-----------------------------------------------
void etiqueta_inicializacion() {
//-----------------------------------------------
   register int t;

   for(t = 0; t < NUM_ETI; ++t)
      tabla_etiquetas[t].nombre[0] = '\0';
}


//-----------------------------------------------
void ejecuta_comando() {
//-----------------------------------------------
   //printf("%s %d %d\n",token,tok,token_tipo);
   if (token_tipo == VARIABLE) {
      devolver();
      asignacion();
   }
   else
      switch(tok) {
         case PRINT:
            print();
            break;
         case GOTO:
            ejecuta_goto();
            break;
         case IF:
            ejecuta_if();
            break;
         case FOR:
            ejecuta_for();
            break;
         case NEXT:
            next();
            break;
         case INPUT:
            input();
            break;
         case GOSUB:
            gosub();
            break;
         case RETURN:
            greturn();
            break;
         case REM:
            rem();
            break;
         case WAIT_KEY:
            wait_key();
            break;
         case CLS:
            cls();
            break;
         case LOCATE:
            locate();
            break;
         case COLOR:
            color();
            break;
         case END:
         case TERMINADO:
            setcursor (normalcursor);
            exit(0);
            break;
      }
}

//-----------------------------------------------
void asignacion() {
//-----------------------------------------------
   int var, valor;
   char valor_cad[255];

   /* Toma el nombre de la variable */
   obtiene_token();
   if (!isalpha(*token)) {
      serror(4);
      return;
   }

   var = toupper(*token) - 'A';
   // printf("\nVar : %d \n",var);

   switch(*(prog-1)) {
      case '$':
         obtiene_token();
         if (*token != '=') {
            serror(3);
            return;
         }
         obtiene_expresion_cadena(var_cad[var]);
         break;
      default:
         /* toma el = */
         obtiene_token();
         if (*token != '=') {
            serror(3);
            return;
         }

         /* toma el valor */
         obtiene_expresion(&valor);
         //printf("\nValor : %d \n",valor);

         /* asigna la variable */
         var_num[var] = valor;

   }
}

//-----------------------------------------------
void print() {
//-----------------------------------------------
   int respuesta;
   int len=0, espacios;
   char ultimo_delim;

   do {
      obtiene_token();    /* va al siguiente */
      if (token_tipo == COMILLA) {
         printf("%s",token);
         len += strlen(token);
         obtiene_token();
      }
      else
      {
         if (*(prog-1)=='$')      // es una variable string?
            printf( var_cad[toupper((int)(*token))-'A'] );
         else {
            devolver();
            obtiene_expresion(&respuesta);
            obtiene_token();
            len += printf(" %d", respuesta);
         }
     }

     ultimo_delim = *token;

     if (*token == ',') {
        espacios = 8 - (len % 8);
        len += espacios;
        while(espacios) {
           printf(" ");
           espacios--;
        }
     }
     else
        if (*token == ';'); /* nada */
        else
           break;

   } while (*token == ',');

   if (ultimo_delim != ';' && ultimo_delim != ',')
      printf("\n");
}

//-----------------------------------------------
void ejecuta_goto() {
//-----------------------------------------------
   char *loc;

   obtiene_token();
   loc = busca_etiqueta(token);
   if (loc == '\0')
      serror(7);
   else
      prog = loc;
}

//-----------------------------------------------
void ejecuta_if() {
//-----------------------------------------------
   int cond;

   obtiene_expresion(&cond);
   if (cond) {
      do {
         obtiene_token();
         ejecuta_comando();
      } while(tok != ELSE && tok != FDL && tok != TERMINADO);
      if (tok == ELSE)
         busca_fdl();
   } else {
      while (tok != ELSE && tok != FDL)
         obtiene_token();
      ejecuta_comando();
   }
}


//-----------------------------------------------
void fpone(struct for_estructura i) {
//-----------------------------------------------
   if (ftos > FOR_NEXT)
      serror(10);

  fpila[ftos] = i;
  ftos++;
}


//-----------------------------------------------
struct for_estructura fsaca() {
//-----------------------------------------------
   ftos--;
   if(ftos < 0)
      serror(11);

   return(fpila[ftos]);
}

//-----------------------------------------------
void ejecuta_for() {
//-----------------------------------------------
   struct for_estructura i;
   int valor;

   obtiene_token(); /* toma el control del var */
   if (!isalpha(*token)) {
      serror(4);
   }

   i.var = toupper(*token) - 'A';

   obtiene_token();
   if (*token != '=') {
      serror(3);
   }

   obtiene_expresion(&valor);
   var_num[i.var] = valor;

   obtiene_token();
   if (tok != TO)
      serror(9);

   obtiene_expresion(&i.objetivo);

   if (valor >= var_num[i.var]) {
      i.loc = prog;
      fpone(i);
   } else
      while(tok != NEXT)
         obtiene_token();
}

//-----------------------------------------------
void next() {
//-----------------------------------------------
   struct for_estructura i;

   i = fsaca();
   var_num[i.var]++;
   if (var_num[i.var] > i.objetivo)
      return;
   fpone(i);
   prog = i.loc;
}

//-----------------------------------------------
void input() {
//-----------------------------------------------
   char cur_var, vars[5]; // 5 variables por input
   int i, cad_var=0, num_de_vars=0; // maximo

   obtiene_token();
   if (token_tipo == COMILLA) {
      printf(token);
      obtiene_token();
      if(*token != ',' && *token != ';')
         serror(1);
      if (*token==';')
         printf("? ");
      else
         printf(" ");
    } else
        printf("? ");
    do {
       obtiene_token();     // toma la varialbe
       vars[num_de_vars] = toupper(*token) - 'A';
       num_de_vars++;
       if (*(prog-1)=='$')
          cad_var = 1;
       if (num_de_vars > 1 && cad_var)
          serror(0);
       obtiene_token();    // toma el siguiente caracter
    } while(*token==',');  // es otro?

    cur_var=vars[0];

    if(cad_var) {
       // Lee la variable string
       fgets(var_cad[cur_var],80,stdin);
       var_cad[cur_var][strlen(var_cad[cur_var])-1]=0;
    } else {
       // Lee las variables enteras
       for(i=0;i<num_de_vars;i++)
          scanf("%d", &(var_num[vars[i]]));
    }
}

//-----------------------------------------------
void gpone(char *s) {
//-----------------------------------------------
   gtos++;
   if (gtos == SUB_NEXT) {
      serror(12);
      return;
   }

   gpila[gtos] = s;
}


//-----------------------------------------------
char *gsaca() {
//-----------------------------------------------
   if (gtos == 0) {
      serror(13);
      return 0;
   }

   return(gpila[gtos--]);
}


//-----------------------------------------------
void gosub() {
//-----------------------------------------------
   char *loc;

   obtiene_token();
   loc = busca_etiqueta(token);
   if (loc == '\0')
      serror(7);
   else {
      gpone(prog);
      prog = loc;
   }
}

//-----------------------------------------------
void greturn() {
//-----------------------------------------------
   prog = gsaca();
}

//-----------------------------------------------
void wait_key() {
//-----------------------------------------------
    getch();
}

//-----------------------------------------------
void rem() {
//-----------------------------------------------
   busca_fdl();
}


//-----------------------------------------------
void cls() {
//-----------------------------------------------
   COORD coord;
   DWORD written;

   coord.X = 0;
   for (coord.Y = 0; coord.Y <= 24; coord.Y++)
      FillConsoleOutputCharacter(so, ' ', 80, coord, &written);
   for (coord.Y = 0; coord.Y <= 79; coord.Y++)
      FillConsoleOutputAttribute(so, TEXTCOLOR, 80, coord, &written);
   SetConsoleCursorPosition (so, (COORD) { 0, 0 });
}

//-----------------------------------------------
void locate() {
//-----------------------------------------------
  int x,y;

  obtiene_expresion( &x );
  obtiene_token();
  if ( *token != ',' )
     serror( 1 );
  obtiene_expresion( &y );
  SetConsoleCursorPosition (so, (COORD) {x - 1, y - 1});
}


//-----------------------------------------------
void color() {
//-----------------------------------------------
  int texto,fondo;

  obtiene_expresion( &texto );
  obtiene_token();
  if ( *token != ',' )
     serror( 1 );
  obtiene_expresion( &fondo );
  SetConsoleTextAttribute (so, texto-1 + ( 16 * ( fondo - 1 ) ) );
}


//------------------------------------------------
void outdebug( const char *cadena ) {
//-----------------------------------------------
   printf("%s\n", cadena );
}

//-----------------------------------------------
/* Uso esta rutina para debugear */
void a( float numero, int parada ) {
//-----------------------------------------------
   printf( "\nLlego a Punto : %f\n", numero );
   if ( parada )
      exit( 1 );
}

//-----------------------------------------------
VOID setcursor (UINT shape) {
//-----------------------------------------------
   if (shape == nocursor)
      curinfo.bVisible = FALSE;
   else
      curinfo.bVisible = TRUE;
   if (shape == shortcursor) curinfo.dwSize = 20;
   if (shape == tallcursor) curinfo.dwSize = 90;
   if (shape == normalcursor) curinfo.dwSize = 5;
   SetConsoleCursorInfo (so, &curinfo);
}



