// ===============================================================
//   COMANDOS.H
// ===============================================================

#ifndef __COMMANDS_H
#define __COMMANDS_H

#define NUM_ETI       1000
#define ETI_LARGO       10
#define SUB_NEXT	25
#define FOR_NEXT	25

// estructuras y datos globales

extern int ftos; /* inicio del chequeo del FOR */
extern int gtos; /* inicio del GOTO */

extern struct comandos {
   char comando[20];
   char tok;
} tabla[];

struct for_estructura {
   int var;
   int objetivo;
   char *loc;
};

struct etiqueta {
   char nombre[ETI_LARGO];
   char *p;
};

extern HANDLE si, so;


extern char *gpila[SUB_NEXT];

#define PRINT           1
#define INPUT           2
#define IF              3
#define THEN            4
#define FOR             5
#define NEXT            6
#define TO              7
#define GOTO            8
#define GOSUB           11
#define RETURN          12
#define END             13
#define ELSE		14
#define CLS             15
#define LOCATE          16
#define COLOR		17
#define REM             19
#define WAIT_KEY        20


// funciones prototipos
void ejecuta_comando();
void asignacion();
void print();
void busca_etiquetas();
void busca_fdl();
int  obtiene_siguiente_etiqueta(char *s);
char *busca_etiqueta(char *s);
void ejecuta_goto();
void etiqueta_inicializacion();
void ejecuta_if();
void fpone(struct for_estructura i);
struct for_estructura fsaca();
void ejecuta_for();
void next();
void input();
void gpone(char *s);
char *gsaca();
void gosub();
void greturn();
void cls();
void locate();
void color();
void rem();
void wait_key();
void outdebug( const char *cadena );
void a( float, int );
VOID setcursor (UINT shape);

#endif // __COMMANDS_H

