// ===============================================================
//
//    HBasic v0.1
//    Ene/2002
//
//    Hugo Rozas M.
//    hugo_rozas@terra.com.pe
// 
//    Adaptacion de una version antigua del wxDiv
//    de Echosoft. 
//
// ===============================================================

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

#include "hbasic.h"
#include "comandos.h"
#include "parser.h"

char *prog_buf;      // Aca se leera el programa fuente.
int   prog_size;       // Tamao del programa.
char  nom_prog[ 50 ]; // Nombre del programa. (Max:50 caracteres)

char  *prog;              // analizador de expresiones
char  *gpila[SUB_NEXT];
extern int linea_fuente;

CONSOLE_CURSOR_INFO curinfo;
unsigned int shortcursor = 0x0607, tallcursor = 0x0507, normalcursor = 0x0407,
         nocursor = 0x2000;

// Alojamiento de Variables
int var_num[ 26 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

char var_cad[26][255] = { "", "", "", "", "", "", "", "", "", "", "", "", "",
                          "", "", "", "", "", "", "", "", "", "", "", "", "" };

// Prototipos
void NombreDelPrograma( void );
int load_program(char *p, char *fname);
unsigned file_size(char *filename);


//===============================================
int main(int argc, char **argv) {
//===============================================
  // NombreDelPrograma();
  // Chequea que se ingrese el nombre del programa
  if (argc < 2) {
    printf("Sintaxis de Uso:\n");
    printf("HBASIC <programa.bas>\n");
    exit( ERROR_EXIT );
  }
  strcpy( nom_prog, argv[ 1 ] );
  // Separa memoria para el programa.
  // (+ 1 para poner un cero al final)
  prog_size = file_size( nom_prog ) + 1;
  if (!prog_size ) {
    printf("Error al intentar cargar el archivo : %s\n", nom_prog );
    exit( ERROR_EXIT );
  }
  if(!(prog_buf = (char *)malloc(prog_size))) {
    printf("No hay suficiente memoria para cargar el programa : %s\n", nom_prog );
    exit( ERROR_EXIT );
  }
  // Carga el programa.
  if(!load_program(prog_buf, nom_prog)) {
    printf("No se pudo cargar el archivo : %s\n", nom_prog );
    exit( ERROR_EXIT );
  }
  // printf("%s\n",prog_buf);

  si = GetStdHandle (STD_INPUT_HANDLE);
  so = GetStdHandle (STD_OUTPUT_HANDLE);
  SetConsoleMode (si, ENABLE_WINDOW_INPUT);
  SetConsoleTitle ("HBasic");
  setcursor (nocursor);

  prog = prog_buf;
  busca_etiquetas();
  ftos = 0;
  gtos = 0;

  // Loop principal
  do {
     token_tipo = obtiene_token();
     ejecuta_comando();
  } while(1);


  return 0;
}


//-----------------------------------------------
void NombreDelPrograma( void ) {
//-----------------------------------------------
// Copyright del programa y esas cosas.
  printf("HBasic v 0.1 (Beta)\n");
  printf("Hugo Rozas M. Enero - 2002\n");
}


//-----------------------------------------------
int load_program(char *p, char *fname) {
//-----------------------------------------------
// Carga el programa "fname" en la zona de memoria
// apuntada por *p.
  FILE *fp;

  // Si no lo pudo abrir retorna FALSE
  if(!(fp = fopen(fname, "r"))) return FALSE;

  do {
    *p = getc(fp);
    p++;
  } while(!feof(fp));
  fclose(fp);
  // Le pone un cero final (para que sea un zero-terminated string)
  *p = 0;
  return TRUE;
}

//-----------------------------------------------
unsigned file_size(char *filename) {
//-----------------------------------------------
// Devuelve el tamao del archivo "filename".
  FILE *fp;
  unsigned size;

  fp = fopen(filename, "rt");

  // Si hay algun error retorna 0
  if ( fp == NULL ) return ( 0 );

  fseek(fp, 0L, SEEK_END);
  size = ftell(fp);
  fclose(fp);

  return ( size );
}


