#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <windows.h>

#include "parser.h"
#include "comandos.h"

int linea_fuente = 1;
char token[180];
char token_tipo, tok;
HANDLE si, so;

//-----------------------------------------------
int obtiene_token() {
//-----------------------------------------------
   register char *temp;

   token_tipo = tok = 0;
   temp = token;

   if (*prog == EOF) {
      *token = 0;
      tok = TERMINADO;
      return(token_tipo = DELIMITADOR);
   }

   while(esblanco(*prog)) prog++;

   if (*prog == '\n') {
      prog++;
      linea_fuente++;
      tok = FDL;
      *token = '\n';
      token[1] = 0;
      return (token_tipo = DELIMITADOR);
   }

   if (strchr("+-*^/%=;(),<>", *prog) ) {
      *temp = *prog;
      prog++;
      temp++;
      *temp = 0;
      return(token_tipo = DELIMITADOR);
   }

   if (*prog == '"') {
      int i = 0;

      prog++;
      token[i] = *prog;
      while(*prog != '"' && *prog != '\r')
         token[i++] = *prog++;
      if(*prog == '\n')
         serror(1);
      prog++;
      token[i] = 0;
      return(token_tipo = COMILLA);
   }

   if (isdigit(*prog)) {
      while(!esdelimitador(*prog))
         *temp++ = *prog++;
      *temp = 0;
      return(token_tipo = NUMERO);
    }

    if (isalpha(*prog)) {
       while(!esdelimitador(*prog)) *temp++ = *prog++;
       token_tipo = CADENA;
    }
    *temp = '\0';

    if ( token_tipo == CADENA ) {
        tok = buscar(token);
        if (!tok)
           token_tipo = VARIABLE;
        else
           token_tipo = COMANDO;
     }

    return token_tipo;
}


//-----------------------------------------------
void devolver() {
//-----------------------------------------------
  char *t;

  if ( tok == FDL ) linea_fuente--;
  t = token;
  for(; *t; t++) prog--;
}


//-----------------------------------------------
int buscar(char *s) {
//-----------------------------------------------
   register int i;
   char *p;

   p = s;
   while (*p) {
      *p = tolower(*p);
      p++;
   }
   for (i = 0; *tabla[i].comando; i++)
      if (!strcmp(tabla[i].comando, s))
         return tabla[i].tok;

   return 0;
}


//-----------------------------------------------
int esdelimitador(char c) {
//-----------------------------------------------
   if (strchr(" ;,+-<>/*%^=()", c) || c == 9 || c == '\n' || c == 0)
      return 1;

   return 0;
}


//-----------------------------------------------
int esblanco(char c) {
//-----------------------------------------------
   if (c == ' ' || c == '\t')
      return 1;
   else
      return 0;
}

//-----------------------------------------------
// Listado de errores del sistema
void serror(int error) {
//-----------------------------------------------
   static char *e[] = {
       "Error de sintaxis",
       "Parametros desbalanciados",
       "Sin expresion",
       "Esperado: =",
       "No es una variable",
       "Tabla de label desvordada",
       "Label duplicado",
       "Label no definido",
       "Esperado: THEN",
       "FOR sin TO",
       "Hay demasiados FOR loops",
       "NEXT sin FOR",
       "Demasiados GOSUBs",
       "RETURN sin GOSUB" };

   printf("Linea %d: %s\n", linea_fuente, e[error]);
   exit( 1 );
}

//-----------------------------------------------
void obtiene_expresion(int *resultado) {
//-----------------------------------------------
   obtiene_token();
   if (!*token) {
      serror(2);
   }
   nivel1(resultado);
   devolver();
}


//-----------------------------------------------
void nivel1(int *resultado) {
//-----------------------------------------------
   register char op;
   char op2;
   int guarda;

   nivel2(resultado);

   if (token_tipo==DELIMITADOR) {
      op = *token;
      switch(op) {
         case '>':
            obtiene_token();
            if (token_tipo==DELIMITADOR) {
               op2=*token;
               if (op2=='=') {
                  obtiene_token();
                  nivel2(&guarda);
                  *resultado = ( (*resultado>=guarda) ? 1 : 0);
               }
               else
                  serror(0);
            }
            else {
               nivel2(&guarda);
               *resultado = ( (*resultado>guarda) ? 1 : 0 );
            }
            break;
         case '<':
            obtiene_token();
            if (token_tipo==DELIMITADOR) {
               op2=*token;
               switch(*token) {
                  case '>':   // <>
                     obtiene_token();
                     nivel2(&guarda);
                     *resultado = ( (*resultado!=guarda) ? 1 : 0 );
                     break;
                  case '=':   // <=
                     obtiene_token();
                     nivel2(&guarda);
                     *resultado = ( (*resultado<=guarda) ? 1 : 0 );
                     break;
                  default:
                     serror(0);
               }
            }
            else    // cambia al <
            {
               nivel2(&guarda);
               *resultado = ( (*resultado<guarda) ? 1 : 0 );
            }
            break;
         case '=':
            a(1,0);
            obtiene_token();
            nivel2(&guarda);
            *resultado = ( (*resultado==guarda) ? 1 : 0 );
            break;
      }
   }
}

/* +- */
//-----------------------------------------------
void nivel2(int *resultado) {
//-----------------------------------------------
   register char op;
   int guarda;

   nivel3(resultado);
   while ((op = *token) == '+' || op == '-') {
      obtiene_token();
      nivel3(&guarda);
      aritmetica(op, resultado, &guarda);
   }
}

/* /%* */
//-----------------------------------------------
void nivel3(int *resultado) {
//-----------------------------------------------
   register char op;
   int guarda;

   nivel4(resultado);
   while ((op = *token) == '*' || op == '/' || op == '%') {
      obtiene_token();
      nivel4(&guarda);
      aritmetica(op, resultado, &guarda);
   }
}

//-----------------------------------------------
void nivel4(int *resultado) {
//-----------------------------------------------
   int guarda;

    nivel5(resultado);
    while (*token == '^') {
       obtiene_token();
       nivel4(&guarda);
       aritmetica('^', resultado, &guarda);
	}
}

//-----------------------------------------------
void nivel5(int *resultado) {
//-----------------------------------------------
   register char op;

   op = 0;
   if ((token_tipo == DELIMITADOR) && (*token == '+' || *token == '-')) {
      op = *token;
      obtiene_token();
   }
   nivel6(resultado);
   if (op)
      unitario(op, resultado);
}

//-----------------------------------------------
void nivel6(int *resultado) {
//-----------------------------------------------
   if ((*token == '(') && (token_tipo == DELIMITADOR)) {
      obtiene_token();
      nivel1(resultado);
      if (*token != ')')
        serror(1);
      obtiene_token();
   }
   else
      primitiva(resultado);
}

//-----------------------------------------------
void primitiva(int *resultado) {
//-----------------------------------------------
   switch(token_tipo) {
      case VARIABLE:
         *resultado = busca_var(token);
         obtiene_token();
         return;
      case NUMERO:
         *resultado = atoi(token);
         obtiene_token();
         return;
      default:
         serror(0);
   }
}

//-----------------------------------------------
void aritmetica(char o, int *r, int *h) {
//-----------------------------------------------
   register int t, ex;

   switch( o ){
      case '-':
         *r = *r - *h;
         break;
      case '+':
         *r = *r + *h;
         break;
      case '*':
         *r = *r * *h;
         break;
      case '/':
         *r = (*r) / (*h);
         break;
      case '%':
         t = (*r) / (*h);
         *r = *r - (t * (*h));
         break;
      case '^':
         ex = *r;
         if (*h == 0) {
            *r = 1;
            break;
         }
         for (t = *h-1; t > 0; --t)
            *r = (*r) * ex;
         break;
   }
}

//-----------------------------------------------
void unitario( char o, int *r ) {
//-----------------------------------------------
   if (o == '-')
      *r = -(*r);
}

//-----------------------------------------------
void obtiene_expresion_cadena(char *resultado) {
//-----------------------------------------------
   obtiene_token();
   if (!(*token))
      serror(2);
   cadena_nivel2(resultado);
   devolver();
}

//-----------------------------------------------
void cadena_nivel2(char *resultado) {
//-----------------------------------------------
   register char op;
   char guarda[80];

   cadena_primitiva(resultado);  // toma el primer valor
   obtiene_token();
   while( (op = *token) == '+' ) {
      obtiene_token();
      cadena_primitiva(guarda);    // cambia al siguiente valor
      strcat(resultado, guarda);
      obtiene_token();            // chequea por otro +
   }
}

//-----------------------------------------------
void cadena_primitiva(char *resultado) {
//-----------------------------------------------
   switch(token_tipo) {
      case VARIABLE:
         if (*(prog-1)!='$')
            serror(3);   // No es un CADENA
         strcpy(resultado,var_cad[toupper((int)(*token))-'A']);
         break;
      case COMILLA:
         strcpy(resultado,token);
         break;
      default:        // Cambio
         serror(0);
   }
}

//-----------------------------------------------
int busca_var(char *s) {
//-----------------------------------------------
   if (!isalpha(*s)) {
      serror(4);
   }
   return var_num[toupper(*token) - 'A'];
}

