// ===============================================================
//   PARSER.H
// ===============================================================

#ifndef __PARSER_H
#define __PARSER_H

#define DELIMITADOR     101
#define VARIABLE        102
#define NUMERO          103
#define COMANDO         104
#define CADENA          105
#define COMILLA         106
#define FDL             107
#define TERMINADO       108

extern char *prog;      /* Expresion a ser analizado */
extern int var_num[26];
extern char var_cad[26][255];
extern int linea_fuente;

extern char token[];    /* Representaciones */
extern char token_tipo;
extern char tok;

// prototipos de funciones
void obtiene_expresion(int *resultado);
void nivel1(int *resultado);
void nivel2(int *resultado);
void nivel3(int *resultado);
void nivel4(int *resultado);
void nivel5(int *resultado);
void nivel6(int *resultado);
void primitiva(int *resultado);
void aritmetica(char o, int *r, int *h);
void unitario(char o, int *r);
void obtiene_expresion_cadena(char *resultado);
void cadena_nivel2(char *resultado);
void cadena_primitiva(char *resultado);
void serror(int error); 
void devolver();
int  obtiene_token();
int  buscar(char *s);
int  esdelimitador(char c);
int  esblanco(char c);
int  busca_var(char *s);

#endif // __PARSER_H
