'   Copyright (2003)
'
'  File Name:   QuanTab8.bas
'
'  History:
'  06/28/2001 00 TCS Program Written
'  03/19/2003 01 TCS Upgraded Level Control for V8
'
'  Written by tshoemaker@yahoo.com
'
'  Imports data from QuanTab8 Spreadsheet at active scale.
'-----------------------------------------------------------------------
' Use, modification, or distribution of this program implies that the
' user accepts all responsibility and liablility for the results.  No
' warranty of any kind is made by the author.  This program is free,
' please use it with that in mind.
'-----------------------------------------------------------------------
sub main()

  dim scaleFactor#

  dim lcode$
  dim field$
  dim txt$
  dim x#,y#
  dim scale#

  dim point     as MbePoint
  dim opoint    as MbePoint
  dim status    as integer
  dim endOfFile as Long
  dim filePos   as Long
  dim elem      as new MbeElement
  
  dim stat&
  
  MbeSendCommand "null"

  open "c:\tmp.txt" for input as #1

  stat&=MbeSettings.getScale(point)
  scale#=point.x
  
  'mark current end of file
  endOfFile = MbeDgnInfo.endOfFile

  'get origin point into variable opoint
  MbeWritePrompt "Pick Origin Point"
  MbeGetInput MBE_DataPointInput, MBE_ResetInput, MBE_KeyinInput, MBE_CommandInput
  If MbeState.InputType <> MBE_DataPointInput Then Exit Sub
  status = MbeState.getInputDataPoint(opoint)
  
  'read each line of the file and process
  while not eof(1)
    line input #1, txt$
    if( txt$ <> "" ) then
      
      'determine type of line and process it
      lcode$ = item$(txt$,1,1)
      select case lcode$

        case "L"  'Line
          MbeSendCommand "Place Line"
          field$ = item$(txt$,2,2)
          point.x = opoint.x + val(field$) * scale#
          field$ = item$(txt$,3,3)
          point.y = opoint.y + val(field$) * scale#
          point.z = 0.0
          MbeSendDataPoint point
          field$ = item$(txt$,4,4)
          point.x = opoint.x + val(field$) * scale#
          field$ = item$(txt$,5,5)
          point.y = opoint.y + val(field$) * scale#
          MbeSendDataPoint point
          MbeSendCommand "null"          

        case "S"  'symbology
          field$ = item$(txt$,2,2)
          MbeSendKeyin "level create " + chr$(34) + field$ + chr$(34)
          MbeSendKeyin "lv=" + field$
          field$ = item$(txt$,3,3)
          MbeSettings.color = val(field$)
          field$ = item$(txt$,4,4)
          MbeSettings.lineStyle = val(field$)
          field$ = item$(txt$,5,5)
          MbeSettings.weight = val(field$)
        
        case "T"  'place text
          MbeSendCommand "Place Text"
          field$ = item$(txt$,2,2) 'x offset
          point.x = opoint.x + val(field$)*scale#
          field$ = item$(txt$,3,3) 'y offset
          point.y = opoint.y + val(field$)*scale#
          point.z = 0
          'need to find 3rd comma and take rest of text
          i% = instr(3,txt$,",") 'find position of second comma
          i% = i% + 1
          i% = instr(i% ,txt$,",") 'find position of third comma
          field$ = right$(txt$, len(txt)-i%)
          MbeSendKeyin "`" + field$
          MbeSendDataPoint point
          MbeSendCommand "null"
          
        case "X"  'text settings
          field$ = item$(txt$,2,2) 'font
          MbeSettings.font = val(field$)
          field$ = item$(txt$,3,3) 'text height
          MbeSettings.textHeight = val(field$)*scale#
          field$ = item$(txt$,4,4) 'text width
          MbeSettings.textWidth = val(field$)*scale#
          field$ = item$(txt$,5,5) 'text justification
          MbeSettings.textJustification = val(field$)
          field$ = item$(txt$,6,6) 'active angle
          MbeSettings.angle = val(field$) * Pi/180.0
      end select
      
      
    end if
  wend

  close #1
  
  'now graphic group the elements
  MbeStartDefaultCommand
  MbeSendCommand "group add"
  filePos = elem.fromFile(endOfFile)
  Do While FilePos >= 0
    MbeLocateElement filePos
    filePos = elem.fromFile(filePos + elem.fileSize)
  Loop
  MbeSendDataPoint point,1%
  
  MbeStartDefaultCommand
'  MbeState.parseAll = 1
end sub
