
import java.awt.*;
import java.applet.*;

public final class Canon extends Sprite
{
	public static final int ID = 2;	
	private Sequence fireSeq = new Sequence();
	private boolean fire = false;
	private Missile theMissile = null;

	public Canon(  Scene scene, int xPosition, int yPosition )
	{
		super( ID, scene, xPosition, yPosition );
		widthCollision = 60;
		heightCollision = 75;
		normalSeq.addImage( getImage( "canon.gif" ) );
		fireSeq.addImage( getImage( "fire1.gif") );
		fireSeq.addImage( getImage( "fire2.gif") );
		fireSeq.addImage( getImage( "fire3.gif") );
	}

	public void fire()
	{
		if( theMissile != null && !theMissile.isDead() )
		{
			return;
		}
		setSequence(fireSeq);
		fire = true;
	}

	public void moveLeft()
	{
		if( fire || xPos - 5 <= 0 )
		{
			return;
		}
		xPos -= 10;
	}

	public void moveRight()
	{
		if( fire || getXPosition() >= theScene.getWidth()-getWidth() )
		{
			return;
		}
		xPos += 10;
	}

	public void collision( Sprite obj )
	{
	}

	
	public void draw( Graphics g )
	{
		super.draw( g );
		if( fire && fireSeq.isComplete() )
	 	{
			fire = false;
			theMissile = new Missile(theScene,xPos+10,yPos-10);
			theScene.addObject( theMissile );
			setSequence( normalSeq );	
		}
	}

}


