


import java.applet.*;
import java.awt.*;

public final class Droppings extends Sprite
{
	private static final int Z_ORDER = 3;
	private static final int VELOCITY = 6;
	public static final int ID = 4;	
	
	public Droppings(  Scene scene, int xPosition, int yPosition )
	{
		super( ID, scene, xPosition, yPosition, VELOCITY, Z_ORDER );
		widthCollision = 90;
		heightCollision = 90;
		normalSeq.addImage( getImage( "droppings.gif" ) );
	}

	public void collision( Sprite obj )
	{
		if( !dead && obj.getTypeID() == Canon.ID )
		{
			dead = true;	
			buried = true;
			theScene.death();
		}
	}

	public void kill()
	{
		dead = true;
		buried = true;
	}


	public void draw( Graphics g )
	{
		if( yPos > theScene.getHeight() )
		{
			dead = true;
			buried = true;
			return;
		}
		super.draw( g );
		yPos += theVelocity;
	}

}


