
import java.util.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

public final class Game1 extends Applet implements KeyListener, ActionListener, ItemListener, Game
{

	private boolean started = false;
	private Canvas theCanvas = new Canvas( );
	private Label scoreLabel = new Label("Score.......");
	private Label livesLabel = new Label("Lives left......");
	private Label nextLevelLabel = new Label("Next level change: 50 points.");
	private Label levelLabel = new Label("1");
	private Canon theCanon;
	private Scene theScene;
	private Panel controlPanel = new Panel();
	private Button stopButton = new Button("Stop");
	private Button startButton = new Button("Start");
	private Panel scorePanel = new Panel();
	private Label titleLabel = new Label("Shooting Birds with Cannons - all programming by Ulrik Magnusson");
	private int oldScore = 0;
	private GameProperties theGameProperties = new GameProperties(this);
	
	private void incrementLevel( )
	{
		theGameProperties.setProperty("LEVEL", theGameProperties.getProperty("LEVEL")+1);
		theGameProperties.setProperty("TARGET_VELOCITY", theGameProperties.getProperty("TARGET_VELOCITY")+3);
	}

	public void init()
	{
		theGameProperties.setProperty("INIT_MISSILE_VELOCITY",15);
		theGameProperties.setProperty("INIT_TARGET_VELOCITY",11);
		theGameProperties.setProperty("INIT_LIVES",3);
		theGameProperties.setProperty("INIT_SCORE",0);
		addItems();
	}

	private void addItems()
	{
		setBackground( Color.lightGray );
		setLayout( new BorderLayout(2,2));
		controlPanel.setLayout( new GridLayout(10,1,0,0) );
		controlPanel.add(new Label("Level:"));
		controlPanel.add(levelLabel);
		controlPanel.add( startButton );
		controlPanel.add( stopButton );
		stopButton.setEnabled( false );
		stopButton.addActionListener(this);
		startButton.addActionListener(this);
		add( controlPanel, "West" );
		add( titleLabel, "North" );
		titleLabel.setFont( new Font("Helvetica",Font.BOLD,12) );
		scorePanel.setLayout(new FlowLayout(1,30,FlowLayout.LEFT));
		scorePanel.add( scoreLabel, "West" );
		scorePanel.add( nextLevelLabel, "Center" );
		scorePanel.add( livesLabel, "East" );
		add( scorePanel,"South");
		add( theCanvas,"Center");
		theCanvas.addKeyListener( this );
	}

	
	public void itemStateChanged( java.awt.event.ItemEvent e )
	{
	}

	public void actionPerformed( ActionEvent e )
	{
		if( e.getSource() == startButton )
		{
			startGame();
		}
		else if( e.getSource() == stopButton )
		{
			stopGame();
		}
	}


	private void startGame()
	{
		oldScore = 0;
		theGameProperties.setProperty("MISSILE_VELOCITY","INIT_MISSILE_VELOCITY");
		theGameProperties.setProperty("TARGET_VELOCITY","INIT_TARGET_VELOCITY");
		theGameProperties.setProperty("SCORE", "INIT_SCORE");
		theGameProperties.setProperty("GAME_OVER", 0);
		theGameProperties.setProperty("LIVES", "INIT_LIVES");
		theGameProperties.setProperty("LEVEL",1);
		stopButton.setEnabled( true );
		startButton.setEnabled( false );
		initScene();
		theScene.start();
	}

	private void initScene()
	{
		theScene.clear();
		theGameProperties.setProperty("LIVES",3);
		theGameProperties.setProperty("SCORE",0);
		theGameProperties.setProperty("GAME_OVER",0);
		theCanon = new Canon( theScene, theScene.getWidth() / 2, theScene.getHeight()-50 );
		Target t = new Target( theScene, 0, 0 );
		Missile m = new Missile( theScene, 0, 0 );
		Droppings d = new Droppings( theScene, 0, 0 );
		theScene.addObject( new Building( theScene, theScene.getWidth()-10, 110, "birdhouse.gif" ) );
		theScene.addObject( theCanon );
		int rand = Tools.getRandomInt(3,8);
		for( int i = 0; i < rand; i++ )
		{
			theScene.addObject( new Cloud(theScene, Tools.getRandomInt(theScene.getWidth()), Tools.getRandomInt(theScene.getHeight()/3) ) );
		}
		theScene.addObject( new Target( theScene, -100, 0 ) );
	}

	public void propertyChanged( String property )
	{
		int score = theGameProperties.getProperty("SCORE");
		if( property.equals("SCORE") )
		{
			scoreLabel.setText( "Score: " + score );
			if( score >= oldScore + 50 )
			{
				incrementLevel();
				oldScore = score;
			}
		}
		else if( property.equals("LIVES") )
		{
			livesLabel.setText( "Lives left: " + theGameProperties.getProperty("LIVES") );
		}
		else if( property.equals("LEVEL"))
		{
			int level = theGameProperties.getProperty("LEVEL");
			levelLabel.setText(""+level);
			nextLevelLabel.setText("Next level change: "+ (score+50) + " points.");
			theScene.drawText("Level " + level, new Font("Helvetica", Font.BOLD, 26), Color.black, 8);
			theScene.levelChange();		
		}
		if( theGameProperties.getProperty("GAME_OVER") == 1 )
		{
			stopGame();
		}
	}

	private void stopGame()
	{
		stopButton.setEnabled( false );
		startButton.setEnabled( true );
		theScene.setGameOver(true);
		theScene.stop();
	}
	
	public void start()
	{
		if( !started )
		{
			started = true;
			theScene = new Scene( this, theCanvas, theGameProperties );
			initScene();
		}
	}

	public int getWidth()
	{
		return 400;
	}

	public int getHeight()
	{
		return 300;
	}

	public void stop()
	{
		stopGame();
	}

	
	public void keyTyped(java.awt.event.KeyEvent k)
	{
	}
	public void keyReleased(java.awt.event.KeyEvent k)
	{
	}
	public void keyPressed(java.awt.event.KeyEvent k)
	{
		switch( k.getKeyCode() )
		{
			case KeyEvent.VK_LEFT:
			{
				theCanon.moveLeft();
				break;
			}
			case KeyEvent.VK_RIGHT:
			{
				theCanon.moveRight();
				break;
			}
			case KeyEvent.VK_CONTROL:
			{
				theCanon.fire();
				break;
			}
		}
	}

	public void paint( Graphics g )
	{
		theScene.draw();
	}
	/*
	public void update( Graphics g )
	{
		theScene.draw();
	}
*/

}






