
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.applet.*;

public final class ImageCollection
{
	private static Hashtable images = new Hashtable();
	private MediaTracker tracker;
	private Applet theApplet;
	private int id;
	private static int idCount = 0;
	
	public ImageCollection( Applet applet )
	{
		theApplet = applet;
		tracker = new MediaTracker( theApplet );
	}
		
	public Image getImage( String name )
	{
		Image i;
		if( (i = (Image)images.get(name)) != null )
		{
			return i;
		}
		i = theApplet.getImage(theApplet.getDocumentBase(), name ); 
		int id = idCount++;
		tracker.addImage( i, id );
		try
		{
			tracker.waitForID( id );
		}
		catch( InterruptedException e )
		{
		}
		images.put( name, i );
		return i;
	}


	public int getWidth( Image i )
	{
		return i.getWidth( theApplet );
	}
	
	public ImageObserver getImageObserver()
	{
		return theApplet;
	}

	public int getHeight( Image i )
	{
		return i.getHeight( theApplet );
	}

}
