
import java.applet.*;
import java.awt.*;

public final class Missile extends Sprite
{
	private static final int Z_ORDER = 3;
	public static final int ID = 1;	
	private Sequence hitSeq = new Sequence();

	public Missile(  Scene scene, int xPosition, int yPosition )
	{
		super( ID, scene, xPosition, yPosition, scene.getProperty("MISSILE_VELOCITY"), Z_ORDER );
		widthCollision = 90;
		heightCollision = 90;
		normalSeq.addImage( getImage( "missile.gif" ) );
		hitSeq.addImage( getImage( "missile_explode1.gif" ) );
		hitSeq.addImage( getImage( "missile_explode2.gif" ) );
	}

	
	public void collision( Sprite obj )
	{
		if( obj.getTypeID() == Target.ID )
		{
			setPosition( getXPosition(), getYPosition()+getHeight());
			setSequence(hitSeq);
			dead = true;
		}
	}

	public void kill()
	{
		dead = true;
		buried = true;
	}


	public void draw( Graphics g )
	{
		if( yPos < -20 )
		{
			dead = true;
			buried = true;
			return;
		}
		if( dead  )
		{
			if( hitSeq.isComplete() )
			{
				buried = true;
			}
			super.draw( g );
			return;
		}
		super.draw( g );
		yPos -= theVelocity;
	}

}



