
// responsible for painting objects

import java.util.*;
import java.awt.*;
import java.awt.image.*;
import java.applet.*;

public final class Scene implements Runnable
{
	private Vector textVector = new Vector();
	private Vector objects = new Vector();
	private Thread theThread;
	private Graphics theGraphics;
	private int theHeight;
	private int theWidth;
	private Image offScreenImage;
	private Graphics offScreenGraphics; 
	private Game1 theApplet;
	private boolean gameOver = false;
	private Image image;
	private boolean threadSuspended = true;
	private Font textFont;
	private String text;
	private int textTimeToLive;
	private Hashtable images = new Hashtable();
	private MediaTracker tracker;
	private ImageCollection theImageCollection;
	private Canvas theCanvas;
	private GameProperties theGameProperties;
	private int cloudInterval = 1;
	private int textX;
	private int textY;

	public Scene( Game1 applet, Canvas canvas, GameProperties props)
	{
		theGameProperties = props;
		theCanvas = canvas;
		theApplet = applet;
		theImageCollection = new ImageCollection( theApplet );
		theWidth = theCanvas.getBounds().width;
		theHeight = theCanvas.getBounds().height;
		theGraphics = theCanvas.getGraphics();
		offScreenImage = applet.createImage(theWidth,theHeight);
		offScreenGraphics = offScreenImage.getGraphics();
		image = theImageCollection.getImage("background.gif");
		theThread = new Thread(this);
		theThread.start();
	}

	public int getProperty( String name )
	{
		return theGameProperties.getProperty( name );
	}


	public void setProperty( String name, int value )
	{
		theGameProperties.setProperty( name, value );
	}
	
	public void setProperty( String name, String property )
	{
		theGameProperties.setProperty( name, property );
	}
	
	public void score( int points )
	{
		setProperty( "SCORE", getProperty("SCORE")+points );	
	}

	public void death(  )
	{
		int lives = getProperty("LIVES")-1;
		setProperty( "LIVES", lives );
		announceDeath();
		if( lives == 0 )
		{
			gameOver = true;
			setProperty( "GAME_OVER", 1 );
		}
	}

	public int getWidth()
	{
		return theCanvas.getBounds().width;
	}

	public int getHeight()
	{
		return theCanvas.getBounds().height;
	}

	public ImageCollection getImageCollection()
	{
		return theImageCollection;
	}

	public void clear()
	{
		objects = new Vector();
		textVector = new Vector();
		draw();
	}

	public synchronized void start()
	{
		theCanvas.requestFocus();
		gameOver = false;
		threadSuspended = false; 
		notify();
	}
	

	public void drawText( String t, Font f, Color c, int timeToLive )
	{
		FontMetrics fm = offScreenGraphics.getFontMetrics();
		drawText( t, f, c, (theWidth-fm.stringWidth(t))/2, (theHeight-fm.getHeight())/2, timeToLive );
	}
	
	public void drawText( String t, Font f, Color c, int x, int y, int timeToLive )
	{
		textVector.addElement( new Text(t,f,c,x,y,timeToLive) );
		draw();
	}

	public void pause(int ms)
	{
		try
		{
			theThread.sleep(ms);
		}
		catch( InterruptedException e )
		{}
	}

	public void addObject( Sprite obj )
	{
		int objZ = obj.getZOrder();
		for( int i = 0; i < objects.size(); i++ )
		{
			if( ((Sprite)objects.elementAt(i)).getZOrder() >= objZ )
			{
				objects.insertElementAt(obj,i);
				return;
			}
		}
		objects.addElement(obj);
	}

	public void detectCollisions()
	{
		Sprite obj1;
		Sprite obj2;
		for( int i = 0; i < objects.size(); i++ )
		{
			obj1 = (Sprite)objects.elementAt(i);
			for( int j = 0; j < objects.size(); j++ )
			{
				obj2 = (Sprite)objects.elementAt(j);
				if( obj1.collides(obj2) )
				{
					obj1.collision( obj2 );
					obj2.collision( obj1 );
				}
			}
		}
	}

	public void setGameOver( boolean over )
	{
		gameOver = over;
	}

	public void killAll()
	{
		for( int i = 0; i < objects.size(); i++ )
		{
			((Sprite)objects.elementAt(i)).kill();
		}
	}

	public void stop()
	{
		textVector = new Vector();
		killAll();
		draw();
		threadSuspended = true;
	}

	public void levelChange()
	{
		if( !threadSuspended )
		{
			killAll();
			draw();
			pause(1000);
			//addObject( new Target( this, -100, 0 ) );
		}
	}

	private void announceDeath()
	{
		drawText( "Aaaarrrghhh", new Font("Helvetica",Font.BOLD,30), Color.black );
		theGraphics.drawImage( offScreenImage, 0, 0, theCanvas );
		pause(2000);
		killAll();
		addObject( new Target( this, -100, 0 ) );
	}

	public void draw()
	{
		if( !threadSuspended && --cloudInterval == 0 )
		{
			cloudInterval = Tools.getRandomInt(20,60);
			addObject( new Cloud(this) );
		}
		offScreenGraphics.drawImage(image, 0, 0, theApplet);
		Sprite obj;
		for( int i = 0; i < objects.size(); i++ )
		{
			obj = (Sprite)objects.elementAt(i);
			if( obj.isBuried() )
			{
				objects.removeElementAt(i);
			}
			else
			{
				obj.draw(offScreenGraphics);
			}
		}
		Text t;
		for( int i = 0; i < textVector.size(); i++ )
		{
			t = (Text)textVector.elementAt(i);
			if( t.timeToLive-- != 0 )
			{
				drawText( t.text, t.font, t.color, t.x, t.y );
			}
			else
			{
				textVector.removeElementAt(i);
			}
		}
		if( gameOver )
		{
			drawText("Game Over",new Font("Helvetica",Font.BOLD,30),Color.black);
		}
		theGraphics.drawImage( offScreenImage, 0, 0, theApplet );
	}

	private void drawText( String t, Font f, Color c  )
	{
		offScreenGraphics.setColor( c );
		offScreenGraphics.setFont( f );
		FontMetrics fm = offScreenGraphics.getFontMetrics();
		offScreenGraphics.drawString( t, (theWidth-fm.stringWidth(t))/2, (theHeight-fm.getHeight())/2 );
	}

	private void drawText( String t, Font f, Color c, int xPos, int yPos  )
	{
		offScreenGraphics.setColor( c );
		offScreenGraphics.setFont( f );
		FontMetrics fm = offScreenGraphics.getFontMetrics();
		offScreenGraphics.drawString( t, xPos, yPos );
	}

	public void run()
	{
		while( true )
		{
			try
			{
				draw();
				detectCollisions();
				Thread.sleep(83);
				synchronized(this) 
				{
            	while(threadSuspended)
					{
            		wait();
            	}
				}
			}
			catch( Exception e )
			{
			}
		}
	}	

	private class Text
	{
		String text;
		Font font;
		Color color;
		int x;
		int y;
		int timeToLive;

		public Text( String t, Font f, Color c, int xPos, int yPos, int time )
		{
			text = t;
			font = f;
			color = c;
			x = xPos;
			y = yPos;
			timeToLive = time;
		}
			
	}

}



