

// a sequence is a non-empty collection of images that is used as animation

import java.awt.*;
import java.util.*;
import java.applet.*;

public final class Sequence
{
	private Vector images = new Vector();
	private int index = 0;
	private int width;
	private int height;
	private boolean added = false;
	private boolean complete = false;

	public void reset()
	{
		index = 0;
	}

	public void addImage( Image i )
	{
		added = true;
		images.addElement( i );
	}

	public int getHeight( Scene a )
	{
		if( added )
		{
			return a.getImageCollection().getHeight((Image)images.elementAt(0));
		}
		return 0;
	}

	public int getWidth( Scene a )
	{
		if( added )
		{
			return a.getImageCollection().getHeight((Image)images.elementAt(0));
		}
		return 0;
	}

	// returns true if resetting
	public Image advance()
	{
		if( ++index == images.size() )
		{
			complete = true;
			index = 0;
		}
		else
		{
			complete = false;
		}
		return (Image)images.elementAt(index);
	}

	public boolean isComplete()
	{
		return complete;
	}

	public Image getImage( )
	{
		return (Image)images.elementAt(index);
	}

	public Image getImage( int i )
	{
		return (Image)images.elementAt(i);
	}
}
